/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.AbstractSingleFileGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarker;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarkerWireForm;
import com.gigaspaces.internal.io.IOUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class SingleFileBacklogMarker
implements IMarker {
    private final AbstractSingleFileGroupBacklog<?, ?> _groupBacklog;
    private final String _memberName;
    private final long _markedKey;

    public SingleFileBacklogMarker(AbstractSingleFileGroupBacklog<?, ?> groupBacklog, String memberName, long markedKey) {
        this._groupBacklog = groupBacklog;
        this._memberName = memberName;
        this._markedKey = markedKey;
    }

    @Override
    public boolean isMarkerReached() {
        return this._groupBacklog.isMarkerReached(this._memberName, this._markedKey);
    }

    @Override
    public IMarkerWireForm toWireForm() {
        return new SingleFileBacklogMarkerWireForm(this._groupBacklog.getGroupName(), this._memberName, this._markedKey);
    }

    public String toString() {
        return "member=" + this._memberName + " key=" + this._markedKey;
    }

    public static class SingleFileBacklogMarkerWireForm
    implements IMarkerWireForm {
        private static final long serialVersionUID = 1L;
        private String _groupName;
        private String _memberName;
        private long _markedKey;

        public SingleFileBacklogMarkerWireForm() {
        }

        public SingleFileBacklogMarkerWireForm(String groupName, String memberName, long markedKey) {
            this._groupName = groupName;
            this._memberName = memberName;
            this._markedKey = markedKey;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            IOUtils.writeRepetitiveString(out, this._groupName);
            IOUtils.writeRepetitiveString(out, this._memberName);
            out.writeLong(this._markedKey);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this._groupName = IOUtils.readRepetitiveString(in);
            this._memberName = IOUtils.readRepetitiveString(in);
            this._markedKey = in.readLong();
        }

        @Override
        public IMarker toFinalizedForm(IReplicationGroupBacklog backlog) {
            return new SingleFileBacklogMarker((AbstractSingleFileGroupBacklog)backlog, this._memberName, this._markedKey);
        }

        @Override
        public String getGroupName() {
            return this._groupName;
        }

        public String toString() {
            return "member=" + this._memberName + " key=" + this._markedKey;
        }
    }
}

