/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.ReplicationMultipleOperationType;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationChannelDataFilterResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.ObjectLongMap;
import com.j_spaces.core.exception.internal.ReplicationInternalSpaceException;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class SynchronizingData<T extends IReplicationPacketData<?>> {
    private static final int _maxAfterIterationDoneStageLength = 100000;
    private final ObjectLongMap<String> _entriesUidMap = CollectionsFactory.getInstance().createObjectLongMap();
    private final Logger _logger;
    private final boolean _isDirectPersistencySync;
    private final ObjectLongMap<Object> _dataIdMap = CollectionsFactory.getInstance().createObjectLongMap();
    private long _keyWhenCopyStageCompleted = -1L;

    public SynchronizingData(Logger logger, boolean isDirectPersistencySync) {
        this._logger = logger;
        this._isDirectPersistencySync = isDirectPersistencySync;
    }

    public synchronized boolean updateUidKey(String uid, long currentKey) {
        if (this._entriesUidMap.containsKey(uid)) {
            return true;
        }
        this._entriesUidMap.put(uid, currentKey);
        this._keyWhenCopyStageCompleted = Math.max(this._keyWhenCopyStageCompleted, currentKey);
        return false;
    }

    public synchronized boolean isDone(long key) {
        if (this._keyWhenCopyStageCompleted >= key) {
            return false;
        }
        if (key - this._keyWhenCopyStageCompleted >= 100000L) {
            if (this._logger.isLoggable(Level.WARNING)) {
                this._logger.warning("Synchronization state at completion stage exceeded the allowed number of packets, synchronization state is moving to done");
            }
            return true;
        }
        return this._dataIdMap.isEmpty();
    }

    public synchronized boolean filterEntryData(String uid, long packetKey, boolean filterIfNotPresentInReplicaState) {
        if (!this._entriesUidMap.containsKey(uid)) {
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.finer("[SynchronizingData::filterEntryData] not in _entriesUidMap: uid=" + uid + " ,_keyWhenCopyStageCompleted=" + this._keyWhenCopyStageCompleted + " ,packetKey=" + packetKey + " ,isDirectPersistency=" + this._isDirectPersistencySync);
            }
            if (this._isDirectPersistencySync) {
                return false;
            }
            if (!filterIfNotPresentInReplicaState) {
                this._entriesUidMap.put(uid, packetKey);
            }
            return filterIfNotPresentInReplicaState;
        }
        long keyAtGenerationTime = this._entriesUidMap.get(uid);
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.finer("[SynchronizingData::filterEntryData] in _entriesUidMap: uid=" + uid + " ,_keyWhenCopyStageCompleted=" + this._keyWhenCopyStageCompleted + " ,packetKey=" + packetKey + " ,isDirectPersistency=" + this._isDirectPersistencySync);
        }
        return keyAtGenerationTime >= packetKey;
    }

    public synchronized void setKeyWhenCopyStageCompleted(long keyWhenCopyStageCompleted) {
        this._keyWhenCopyStageCompleted = keyWhenCopyStageCompleted;
    }

    public synchronized ReplicationChannelDataFilterResult filterData(Object dataId, long packetKey, ReplicationMultipleOperationType operationType) {
        if (this._isDirectPersistencySync) {
            return ReplicationChannelDataFilterResult.PASS;
        }
        switch (operationType) {
            case TRANSACTION_TWO_PHASE_PREPARE: {
                this._dataIdMap.put(dataId, packetKey);
                if (packetKey > this._keyWhenCopyStageCompleted) {
                    return ReplicationChannelDataFilterResult.PASS;
                }
                return ReplicationChannelDataFilterResult.FILTER_DATA;
            }
            case TRANSACTION_TWO_PHASE_COMMIT: {
                long removedDataKey;
                if (this._dataIdMap.containsKey(dataId) && (removedDataKey = this._dataIdMap.remove(dataId)) > this._keyWhenCopyStageCompleted) {
                    return ReplicationChannelDataFilterResult.PASS;
                }
                return ReplicationChannelDataFilterResult.getConvertToOperationResult(ReplicationMultipleOperationType.TRANSACTION_ONE_PHASE);
            }
            case TRANSACTION_TWO_PHASE_ABORT: {
                long removedDataKey;
                if (this._dataIdMap.containsKey(dataId) && (removedDataKey = this._dataIdMap.remove(dataId)) > this._keyWhenCopyStageCompleted) {
                    return ReplicationChannelDataFilterResult.PASS;
                }
                return ReplicationChannelDataFilterResult.FILTER_DATA;
            }
        }
        throw new ReplicationInternalSpaceException("Unexpected packet type " + (Object)((Object)operationType));
    }
}

