/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.globalorder;

import com.gigaspaces.cluster.replication.ReplicationException;
import com.gigaspaces.internal.cluster.node.impl.ReplicationMultipleOperationType;
import com.gigaspaces.internal.cluster.node.impl.ReplicationOutContext;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.backlog.AbstractSingleFileGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.CompletedHandshakeContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.EmptyIdleStateData;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.backlog.IIdleStateData;
import com.gigaspaces.internal.cluster.node.impl.backlog.NonExistingBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderConfirmationHolder;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderDeletedBacklogPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderDiscardedReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderOperationPacket;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.SourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeContext;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataProducer;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessLogHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderProcessLogHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderProcessResult;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.jini.core.transaction.server.ServerTransaction;

public abstract class AbstractGlobalOrderGroupBacklog
extends AbstractSingleFileGroupBacklog<IReplicationOrderedPacket, GlobalOrderConfirmationHolder> {
    public AbstractGlobalOrderGroupBacklog(DynamicSourceGroupConfigHolder groupConfig, String name, IReplicationPacketDataProducer<?> dataProducer) {
        super(groupConfig, name, dataProducer);
    }

    @Override
    protected Map<String, GlobalOrderConfirmationHolder> createConfirmationMap(SourceGroupConfig groupConfig) {
        HashMap<String, GlobalOrderConfirmationHolder> confirmationMap = new HashMap<String, GlobalOrderConfirmationHolder>();
        String[] membersLookupNames = groupConfig.getMembersLookupNames();
        for (int i = 0; i < membersLookupNames.length; ++i) {
            confirmationMap.put(membersLookupNames[i], new GlobalOrderConfirmationHolder());
        }
        return confirmationMap;
    }

    @Override
    protected GlobalOrderConfirmationHolder createNewConfirmationHolder() {
        GlobalOrderConfirmationHolder confirmationHolder = new GlobalOrderConfirmationHolder();
        confirmationHolder.setLastConfirmedKey(this.getNextKeyUnsafe() - 1L, 0L);
        return confirmationHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalOrderBacklogHandshakeRequest getHandshakeRequest(String memberName, Object customBacklogMetadata) {
        this._rwLock.writeLock().lock();
        try {
            GlobalOrderConfirmationHolder confirmationHolder = (GlobalOrderConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
            GlobalOrderBacklogHandshakeRequest globalOrderBacklogHandshakeRequest = new GlobalOrderBacklogHandshakeRequest(!confirmationHolder.hadAnyHandshake(), confirmationHolder.getLastConfirmedKey());
            return globalOrderBacklogHandshakeRequest;
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    @Override
    protected IReplicationOrderedPacket createBacklogOverflowPacket(long lastConfirmedKey, long firstKeyInBacklog, String memberName) {
        return new GlobalOrderDeletedBacklogPacket(lastConfirmedKey + 1L, firstKeyInBacklog - 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IHandshakeContext processHandshakeResponse(String memberName, IBacklogHandshakeRequest request, IProcessLogHandshakeResponse response, PlatformLogicalVersion targetLogicalVersion, Object customBacklogMetadata) {
        GlobalOrderProcessLogHandshakeResponse typedResponse = (GlobalOrderProcessLogHandshakeResponse)response;
        this._rwLock.writeLock().lock();
        try {
            long lastProcessedKey = typedResponse.getLastProcessedKey();
            this.updateLastConfirmedKeyUnsafe(memberName, lastProcessedKey);
            this.clearConfirmedPackets();
            CompletedHandshakeContext completedHandshakeContext = new CompletedHandshakeContext();
            return completedHandshakeContext;
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    @Override
    protected long getMemberUnconfirmedKey(GlobalOrderConfirmationHolder value) {
        return value.hadAnyHandshake() ? value.getLastConfirmedKey() : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResult(String memberName, IProcessResult result, List<IReplicationOrderedPacket> packets) throws ReplicationException {
        GlobalOrderProcessResult typedResult = (GlobalOrderProcessResult)result;
        this._rwLock.writeLock().lock();
        try {
            if (typedResult.isProcessed()) {
                this.confirmedPackets(memberName, packets);
            } else {
                this.handlePendingErrorBatchPackets(memberName, packets, typedResult.getError(), typedResult.getLastProcessedKey() + 1L);
                this.handleErrorResult(memberName, typedResult);
            }
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResult(String memberName, IProcessResult result, IReplicationOrderedPacket packet) throws ReplicationException {
        GlobalOrderProcessResult typedResult = (GlobalOrderProcessResult)result;
        this._rwLock.writeLock().lock();
        try {
            if (typedResult.isProcessed()) {
                this.confirmedPackets(memberName, packet);
            } else {
                this.handlePendingErrorSinglePacket(memberName, packet, typedResult.getError());
                this.handleErrorResult(memberName, typedResult);
            }
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    private void confirmedPackets(String memberName, List<IReplicationOrderedPacket> packets) {
        IReplicationOrderedPacket lastPacket = packets.get(packets.size() - 1);
        this.confirmedPackets(memberName, lastPacket);
    }

    private void confirmedPackets(String memberName, IReplicationOrderedPacket packet) {
        long packetKeykey = packet.getKey();
        if (packet.isDiscardedPacket() && packet instanceof GlobalOrderDiscardedReplicationPacket) {
            packetKeykey = ((GlobalOrderDiscardedReplicationPacket)packet).getEndKey();
        }
        this.confirmedKey(memberName, packetKeykey);
    }

    private void confirmedKey(String memberName, long packetKeykey) {
        GlobalOrderConfirmationHolder confirmationHolder = (GlobalOrderConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
        long lastConfirmedKey = confirmationHolder.getLastConfirmedKey();
        if (!confirmationHolder.hadAnyHandshake() || packetKeykey > lastConfirmedKey) {
            confirmationHolder.setLastConfirmedKey(packetKeykey, memberName, this);
            this.cleanPendingErrorStateIfNeeded(memberName, packetKeykey, confirmationHolder);
        }
        this.clearConfirmedPackets();
    }

    private void handleErrorResult(String memberName, GlobalOrderProcessResult result) throws ReplicationException {
        Throwable error = result.getError();
        long lastProcessedKey = result.getLastProcessedKey();
        this.handleErrorResult(memberName, error, lastProcessedKey);
    }

    private void handleErrorResult(String memberName, Throwable error, long lastProcessedKey) throws ReplicationException {
        GlobalOrderConfirmationHolder confirmationHolder;
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.finer(this.getLogPrefix() + "handling error result in backlog - " + error);
        }
        if (!(confirmationHolder = (GlobalOrderConfirmationHolder)this.getConfirmationHolderUnsafe(memberName)).hadAnyHandshake() || confirmationHolder.getLastConfirmedKey() < lastProcessedKey) {
            this.updateLastConfirmedKeyUnsafe(memberName, lastProcessedKey);
            this.clearConfirmedPackets();
        }
        throw new ReplicationException(error.getMessage(), error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBacklogMemberState getState(String memberName) {
        this._rwLock.readLock().lock();
        try {
            GlobalOrderConfirmationHolder confirmationHolder = (GlobalOrderConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
            if (confirmationHolder == null) {
                NonExistingBacklogMemberState nonExistingBacklogMemberState = NonExistingBacklogMemberState.INSTANCE;
                return nonExistingBacklogMemberState;
            }
            long lastConfirmedKey = confirmationHolder.getLastConfirmedKey();
            boolean hasAnyHandshake = confirmationHolder.hadAnyHandshake();
            Throwable pendingError = confirmationHolder.hasPendingError() ? confirmationHolder.getPendingError() : null;
            boolean backlogDropped = this._outOfSyncDueToDeletionTargets.contains(memberName);
            GlobalOrderBacklogMemberState globalOrderBacklogMemberState = new GlobalOrderBacklogMemberState(memberName, hasAnyHandshake, lastConfirmedKey, backlogDropped, pendingError);
            return globalOrderBacklogMemberState;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    private void updateLastConfirmedKeyUnsafe(String memberName, long key) {
        GlobalOrderConfirmationHolder confirmationHolder = (GlobalOrderConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
        confirmationHolder.setLastConfirmedKey(key, memberName, this);
    }

    @Override
    protected void onBeginSynchronization(String memberName) {
        long key = this.getNextKeyUnsafe() - 1L;
        this.updateLastConfirmedKeyUnsafe(memberName, key);
    }

    @Override
    public IReplicationOrderedPacket replaceWithDiscarded(IReplicationOrderedPacket packet, boolean forceDiscard) {
        return new GlobalOrderDiscardedReplicationPacket(packet.getKey());
    }

    @Override
    public boolean mergeWithDiscarded(IReplicationOrderedPacket previousDiscardedPacket, IReplicationOrderedPacket mergedPacket, String memberName) {
        return false;
    }

    @Override
    public boolean supportDiscardMerge() {
        return true;
    }

    public GlobalOrderConfirmationHolder getLastConfirmationInternal(String memberName) {
        this._rwLock.readLock().lock();
        try {
            GlobalOrderConfirmationHolder globalOrderConfirmationHolder = (GlobalOrderConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
            return globalOrderConfirmationHolder;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    @Override
    public String dumpState() {
        this._rwLock.readLock().lock();
        try {
            StringBuilder dump = new StringBuilder("Type [" + this.getClass().getName() + "]");
            dump.append(StringUtils.NEW_LINE);
            dump.append("Backlog statistics {" + this.getStatistics() + "}");
            this.appendConfirmationStateString(dump);
            String string = dump.toString();
            return string;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    protected IReplicationOrderedPacket addSingleOperationPacket(IReplicationGroupOutContext groupContext, IEntryHolder entryHolder, ReplicationSingleOperationType operationType) {
        ReplicationOutContext outContext = groupContext.getEntireContext();
        Object data = this.getDataProducer().createSingleOperationData(entryHolder, operationType, outContext);
        GlobalOrderOperationPacket packet = this.insertPacketToBacklog((IReplicationPacketData<?>)data, outContext);
        return packet;
    }

    protected IReplicationOrderedPacket addTransactionOperationPacket(IReplicationGroupOutContext groupContext, ServerTransaction transaction, ArrayList<IEntryHolder> lockedEntries, ReplicationMultipleOperationType operationType) {
        ReplicationOutContext outContext = groupContext.getEntireContext();
        Object data = this.getDataProducer().createTransactionOperationData(transaction, lockedEntries, outContext, operationType);
        if (data.isEmpty()) {
            return null;
        }
        GlobalOrderOperationPacket packet = this.insertPacketToBacklog((IReplicationPacketData<?>)data, outContext);
        return packet;
    }

    protected IReplicationOrderedPacket addGenericOperationPacket(IReplicationGroupOutContext groupContext, Object operationData, ReplicationSingleOperationType operationType) {
        ReplicationOutContext outContext = groupContext.getEntireContext();
        Object data = this.getDataProducer().createGenericOperationData(operationData, operationType, outContext);
        GlobalOrderOperationPacket packet = this.insertPacketToBacklog((IReplicationPacketData<?>)data, outContext);
        return packet;
    }

    private GlobalOrderOperationPacket insertPacketToBacklog(IReplicationPacketData<?> data, ReplicationOutContext outContext) {
        this._rwLock.writeLock().lock();
        try {
            this.setPacketWeight(data);
            if (!this.shouldInsertPacket(data)) {
                GlobalOrderOperationPacket globalOrderOperationPacket = null;
                return globalOrderOperationPacket;
            }
            GlobalOrderOperationPacket packet = new GlobalOrderOperationPacket(this.takeNextKeyUnsafe(outContext), data);
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.finest(this.getLogPrefix() + "inserting packet [" + packet + "] to backlog");
            }
            this.insertReplicationOrderedPacketToBacklog(packet, outContext);
            GlobalOrderOperationPacket globalOrderOperationPacket = packet;
            return globalOrderOperationPacket;
        }
        catch (RuntimeException e) {
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, "exception while inserting a packet to the backlog file (insertPacketToBacklog), [" + this.getStatistics() + "]", e);
            }
            this.validateIntegrity();
            throw e;
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    @Override
    protected long getLastConfirmedKeyUnsafe(String memberLookupName) {
        GlobalOrderConfirmationHolder confirmationHolder = (GlobalOrderConfirmationHolder)this.getConfirmationHolderUnsafe(memberLookupName);
        return confirmationHolder.hadAnyHandshake() ? confirmationHolder.getLastConfirmedKey() : -1L;
    }

    @Override
    protected void deleteBatchFromBacklog(long deletionBatchSize) {
        this.decreaseWeightToAllMembersFromOldestPacket(this.getFirstKeyInBacklogInternal() + deletionBatchSize - 1L);
        this.getBacklogFile().deleteOldestPackets(deletionBatchSize);
    }

    @Override
    public IProcessResult fromWireForm(Object wiredProcessResult) {
        if (wiredProcessResult == null) {
            return GlobalOrderProcessResult.OK;
        }
        return (IProcessResult)wiredProcessResult;
    }

    @Override
    public IIdleStateData getIdleStateData(String memberName, PlatformLogicalVersion targetMemberVersion) {
        return EmptyIdleStateData.INSTANCE;
    }

    @Override
    public void processIdleStateDataResult(String memberName, IProcessResult result, IIdleStateData idleStateData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getConfirmed(String memberName) {
        this._rwLock.readLock().lock();
        try {
            long l = this.getLastConfirmedKeyUnsafe(memberName);
            return l;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }
}

