/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.globalorder;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationBacklogBuilder;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderAsyncGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderReliableAsyncGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderSyncGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataProducer;

@InternalApi
public class GlobalOrderBacklogBuilder
implements IReplicationBacklogBuilder {
    private final IReplicationPacketDataProducer<?> _dataProducer;
    private final String _name;

    public GlobalOrderBacklogBuilder(IReplicationPacketDataProducer<?> dataProducer, String name) {
        this._dataProducer = dataProducer;
        this._name = name;
    }

    @Override
    public GlobalOrderSyncGroupBacklog createSyncGroupBacklog(DynamicSourceGroupConfigHolder groupConfig) {
        return new GlobalOrderSyncGroupBacklog(groupConfig, this._name, this._dataProducer);
    }

    @Override
    public GlobalOrderAsyncGroupBacklog createAsyncGroupBacklog(DynamicSourceGroupConfigHolder groupConfig) {
        return new GlobalOrderAsyncGroupBacklog(groupConfig, this._name, this._dataProducer);
    }

    @Override
    public GlobalOrderReliableAsyncGroupBacklog createReliableAsyncGroupBacklog(DynamicSourceGroupConfigHolder groupConfig) {
        return new GlobalOrderReliableAsyncGroupBacklog(groupConfig, this._name, this._dataProducer);
    }

    public String toString() {
        return "GlobalOrderBacklogBuilder [_dataProducer=" + this._dataProducer + ", _name=" + this._name + "]";
    }
}

