/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.globalorder;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class GlobalOrderBacklogHandshakeRequest
implements IBacklogHandshakeRequest {
    private static final long serialVersionUID = 1L;
    private boolean _firstHandshake;
    private long _lastConfirmedKey;

    public GlobalOrderBacklogHandshakeRequest() {
    }

    public GlobalOrderBacklogHandshakeRequest(boolean firstHandshake, long lastConfirmedKey) {
        this._firstHandshake = firstHandshake;
        this._lastConfirmedKey = lastConfirmedKey;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._firstHandshake = in.readBoolean();
        this._lastConfirmedKey = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this._firstHandshake);
        out.writeLong(this._lastConfirmedKey);
    }

    public long getLastConfirmedKey() {
        return this._lastConfirmedKey;
    }

    @Override
    public boolean isFirstHandshake() {
        return this._firstHandshake;
    }

    @Override
    public String toLogMessage() {
        return "Handshake request. First handshake by source [" + this._firstHandshake + "]. Last confirmed key by source [" + this._lastConfirmedKey + "]";
    }

    public String toString() {
        return this.toLogMessage();
    }
}

