/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.globalorder;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.DiscardReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class GlobalOrderDeletedBacklogPacket
implements IReplicationOrderedPacket {
    private static final long serialVersionUID = 1L;
    private long _startKey;
    private long _endKey;

    public GlobalOrderDeletedBacklogPacket() {
    }

    public GlobalOrderDeletedBacklogPacket(long startKey, long endKey) {
        this._startKey = startKey;
        this._endKey = endKey;
    }

    public IReplicationPacketData getData() {
        return DiscardReplicationPacketData.instance();
    }

    @Override
    public long getKey() {
        return this._startKey;
    }

    @Override
    public long getEndKey() {
        return this._endKey;
    }

    @Override
    public boolean isDataPacket() {
        return false;
    }

    @Override
    public boolean isDiscardedPacket() {
        return false;
    }

    @Override
    public GlobalOrderDeletedBacklogPacket clone() {
        return this;
    }

    @Override
    public IReplicationOrderedPacket cloneWithNewData(IReplicationPacketData<?> newData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getWeight() {
        return 1;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternalImpl(in);
    }

    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternalImpl(in);
    }

    private void readExternalImpl(ObjectInput in) throws IOException {
        this._startKey = in.readLong();
        this._endKey = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternalImpl(out);
    }

    public void writeToSwap(ObjectOutput out) throws IOException {
        this.writeExternalImpl(out);
    }

    private void writeExternalImpl(ObjectOutput out) throws IOException {
        out.writeLong(this._startKey);
        out.writeLong(this._endKey);
    }

    public String toString() {
        return "key=" + this._startKey + " deleted backlog indicator, end key=" + this._endKey;
    }
}

