/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.globalorder;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.DiscardReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class GlobalOrderDiscardedReplicationPacket
implements IReplicationOrderedPacket {
    private static final long serialVersionUID = 1L;
    private long _key;
    private long _endKey;

    public GlobalOrderDiscardedReplicationPacket() {
    }

    public GlobalOrderDiscardedReplicationPacket(long key) {
        this._key = key;
        this._endKey = key;
    }

    @Override
    public IReplicationPacketData<?> getData() {
        return DiscardReplicationPacketData.instance();
    }

    @Override
    public long getKey() {
        return this._key;
    }

    @Override
    public long getEndKey() {
        return this._endKey;
    }

    public void setEndKey(long endKey) {
        this._endKey = endKey;
    }

    @Override
    public boolean isDataPacket() {
        return false;
    }

    @Override
    public boolean isDiscardedPacket() {
        return true;
    }

    @Override
    public GlobalOrderDiscardedReplicationPacket clone() {
        return this;
    }

    @Override
    public IReplicationOrderedPacket cloneWithNewData(IReplicationPacketData<?> newData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getWeight() {
        return 0;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._key = in.readLong();
        boolean hasRange = in.readBoolean();
        this._endKey = hasRange ? in.readLong() : this._key;
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v12_1_0) && version.lessThan(PlatformLogicalVersion.v12_3_0)) {
            in.readInt();
        }
    }

    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this._key = in.readLong();
        this._endKey = in.readLong();
        PlatformLogicalVersion version = PlatformLogicalVersion.getLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v12_1_0) && version.lessThan(PlatformLogicalVersion.v12_3_0)) {
            in.readInt();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        PlatformLogicalVersion endpointLogicalVersion;
        out.writeLong(this._key);
        out.writeBoolean(this.hasKeyRange());
        if (this.hasKeyRange()) {
            out.writeLong(this._endKey);
        }
        if ((endpointLogicalVersion = LRMIInvocationContext.getEndpointLogicalVersion()).greaterOrEquals(PlatformLogicalVersion.v12_1_0) && endpointLogicalVersion.lessThan(PlatformLogicalVersion.v12_3_0)) {
            out.writeInt(0);
        }
    }

    public void writeToSwap(ObjectOutput out) throws IOException {
        out.writeLong(this._key);
        out.writeLong(this._endKey);
        PlatformLogicalVersion version = PlatformLogicalVersion.getLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v12_1_0) && version.lessThan(PlatformLogicalVersion.v12_3_0)) {
            out.writeInt(0);
        }
    }

    private boolean hasKeyRange() {
        return this._key != this._endKey;
    }

    public String toString() {
        return (this.hasKeyRange() ? "keys=" + this._key + "-" + this._endKey : "key=" + this._key) + " data=" + this.getData();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalOrderDiscardedReplicationPacket that = (GlobalOrderDiscardedReplicationPacket)o;
        if (this._key != that._key) {
            return false;
        }
        return this._endKey == that._endKey;
    }
}

