/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.globalorder;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.io.IOUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class GlobalOrderOperationPacket
implements IReplicationOrderedPacket {
    private static final long serialVersionUID = 1L;
    private long _key;
    private IReplicationPacketData _data;

    public GlobalOrderOperationPacket() {
    }

    public GlobalOrderOperationPacket(long key, IReplicationPacketData data) {
        this._key = key;
        this._data = data;
    }

    public IReplicationPacketData getData() {
        return this._data;
    }

    @Override
    public long getKey() {
        return this._key;
    }

    @Override
    public long getEndKey() {
        return this._key;
    }

    @Override
    public boolean isDataPacket() {
        return true;
    }

    @Override
    public boolean isDiscardedPacket() {
        return false;
    }

    @Override
    public GlobalOrderOperationPacket clone() {
        try {
            GlobalOrderOperationPacket clone = (GlobalOrderOperationPacket)super.clone();
            clone._data = this._data.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public IReplicationOrderedPacket cloneWithNewData(IReplicationPacketData<?> newData) {
        try {
            GlobalOrderOperationPacket clone = (GlobalOrderOperationPacket)super.clone();
            clone._data = newData;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public int getWeight() {
        if (this._data != null) {
            return this._data.getWeight();
        }
        return 1;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._key = in.readLong();
        this._data = (IReplicationPacketData)in.readObject();
    }

    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this._key = in.readLong();
        this._data = (IReplicationPacketData)IOUtils.readSwapExternalizableObject(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this._key);
        out.writeObject(this._data);
    }

    public void writeToSwap(ObjectOutput out) throws IOException {
        out.writeLong(this._key);
        IOUtils.writeSwapExternalizableObject(out, this._data);
    }

    public String toString() {
        return "key=" + this._key + " data=" + this._data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalOrderOperationPacket that = (GlobalOrderOperationPacket)o;
        if (this._key != that._key) {
            return false;
        }
        return this._data != null ? this._data.equals(that._data) : that._data == null;
    }
}

