/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.globalorder;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderConfirmationHolder;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReliableAsyncState;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReliableAsyncTargetState;
import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

@InternalApi
public class GlobalOrderReliableAsyncState
implements Externalizable,
IReliableAsyncState {
    private static final long serialVersionUID = 1L;
    private AsyncTargetState[] _asyncTargetsState;

    public GlobalOrderReliableAsyncState() {
    }

    public GlobalOrderReliableAsyncState(AsyncTargetState[] asyncTargetsState) {
        this._asyncTargetsState = asyncTargetsState;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._asyncTargetsState = (AsyncTargetState[])IOUtils.readObject(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject(out, this._asyncTargetsState);
    }

    public AsyncTargetState[] getAsyncTargetsState() {
        return this._asyncTargetsState;
    }

    @Override
    public IReliableAsyncTargetState[] getReliableAsyncTargetsState() {
        return this.getAsyncTargetsState();
    }

    public long getMinimumUnconfirmedKey() {
        if (this._asyncTargetsState.length == 0) {
            return Long.MAX_VALUE;
        }
        long minConfirmed = Long.MAX_VALUE;
        for (AsyncTargetState asyncTargetState : this._asyncTargetsState) {
            if (!asyncTargetState.hadAnyHandshake()) {
                return 0L;
            }
            minConfirmed = Math.min(minConfirmed, asyncTargetState.getLastConfirmedKey());
        }
        return minConfirmed + 1L;
    }

    public String toString() {
        return Arrays.toString(this._asyncTargetsState);
    }

    public static class AsyncTargetState
    implements Externalizable,
    IReliableAsyncTargetState {
        private static final long serialVersionUID = 1L;
        private String _targetMemberName;
        private long _lastConfirmedKey = -1L;
        private boolean _hadAnyHandshake = false;

        public AsyncTargetState() {
        }

        public AsyncTargetState(String targetMemberName, GlobalOrderConfirmationHolder confirmationHolder) {
            this._targetMemberName = targetMemberName;
            this._lastConfirmedKey = confirmationHolder.getLastConfirmedKey();
            this._hadAnyHandshake = confirmationHolder.hadAnyHandshake();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this._targetMemberName = IOUtils.readRepetitiveString(in);
            this._hadAnyHandshake = in.readBoolean();
            this._lastConfirmedKey = in.readLong();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            IOUtils.writeRepetitiveString(out, this._targetMemberName);
            out.writeBoolean(this._hadAnyHandshake);
            out.writeLong(this._lastConfirmedKey);
        }

        @Override
        public String getTargetMemberName() {
            return this._targetMemberName;
        }

        public long getLastConfirmedKey() {
            return this._lastConfirmedKey;
        }

        public boolean hadAnyHandshake() {
            return this._hadAnyHandshake;
        }

        public String toString() {
            return "AsyncTargetState [targetMemberName=" + this._targetMemberName + ", lastConfirmedKey=" + this._lastConfirmedKey + ", hadAnyHandshake=" + this._hadAnyHandshake + "]";
        }
    }
}

