/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile;

import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.BucketKey;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.IMultiBucketSingleFileReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileConfirmationHolder;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileProcessResult;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.ShortObjectIterator;
import com.gigaspaces.internal.collections.ShortObjectMap;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractMultiBucketOrderedPacket
implements IMultiBucketSingleFileReplicationOrderedPacket {
    private static final long serialVersionUID = 1L;
    private ShortObjectMap<BucketKey> _bucketsKeys;
    private long _globalKey;
    private transient IMultiBucketSingleFileReplicationOrderedPacket _beforeFilterPacket;

    public AbstractMultiBucketOrderedPacket() {
    }

    public AbstractMultiBucketOrderedPacket(long globalKey, ShortObjectMap<BucketKey> bucketsKeys) {
        this._globalKey = globalKey;
        this._bucketsKeys = bucketsKeys;
    }

    @Override
    public long getBucketKey(short bucketIndex) {
        BucketKey bucketKey = this._bucketsKeys.get(bucketIndex);
        if (bucketKey == null) {
            throw new IllegalArgumentException("No bucket key exists for bucket index " + bucketIndex);
        }
        return bucketKey.bucketKey;
    }

    public ShortObjectMap<BucketKey> getBucketsKeys() {
        return this._bucketsKeys;
    }

    @Override
    public short[] getBuckets() {
        return this._bucketsKeys.keys();
    }

    @Override
    public short bucketCount() {
        return (short)this._bucketsKeys.size();
    }

    @Override
    public void associateToBuckets(ShortObjectMap<List<IMultiBucketSingleFileReplicationOrderedPacket>> bucketsPackets) {
        ShortObjectMap<BucketKey> bucketsKeys = this._bucketsKeys;
        for (short bucketIndex : bucketsKeys.keys()) {
            List<IMultiBucketSingleFileReplicationOrderedPacket> list = bucketsPackets.get(bucketIndex);
            if (list == null) {
                list = new LinkedList<IMultiBucketSingleFileReplicationOrderedPacket>();
                bucketsPackets.put(bucketIndex, list);
            }
            list.add(this);
        }
    }

    protected void writeBucketKeys(ObjectOutput out) throws IOException {
        out.writeShort(this._bucketsKeys.size());
        ShortObjectIterator<BucketKey> iterator = this._bucketsKeys.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            out.writeShort(iterator.key());
            out.writeLong(iterator.value().bucketKey);
        }
    }

    protected void readBucketKeys(ObjectInput in) throws IOException {
        int size = in.readShort();
        this._bucketsKeys = CollectionsFactory.getInstance().createShortObjectMap(size);
        for (int i = 0; i < size; ++i) {
            this._bucketsKeys.put(in.readShort(), new BucketKey(in.readLong()));
        }
    }

    @Override
    public long processResult(String memberName, MultiBucketSingleFileProcessResult processResult, MultiBucketSingleFileConfirmationHolder confirmationHolder) {
        ShortObjectIterator<BucketKey> iterator = this._bucketsKeys.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            short bucketIndex = iterator.key();
            long bucketKey = iterator.value().bucketKey;
            Long knownLastConfirmedKey = confirmationHolder.getBucketLastConfirmedKeys()[bucketIndex];
            if (knownLastConfirmedKey != null && knownLastConfirmedKey >= bucketKey) continue;
            confirmationHolder.getBucketLastConfirmedKeys()[bucketIndex] = bucketKey;
        }
        return confirmationHolder.addGlobalKeyConfirmed(this.getKey());
    }

    @Override
    public void reliableAsyncKeysUpdate(long[] bucketLastKeys, MultiBucketSingleFileConfirmationHolder confirmationHolder) {
        ShortObjectIterator<BucketKey> iterator = this._bucketsKeys.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            short bucketIndex = iterator.key();
            long bucketKey = iterator.value().bucketKey;
            bucketLastKeys[bucketIndex] = bucketKey + 1L;
            confirmationHolder.getBucketLastConfirmedKeys()[bucketIndex] = bucketKey;
        }
        confirmationHolder.overrideGlobalLastConfirmedKey(this.getKey());
    }

    @Override
    public IMultiBucketSingleFileReplicationOrderedPacket getReliableAsyncBeforeFilterPacket() {
        return this._beforeFilterPacket;
    }

    @Override
    public void setReliableAsyncBeforeFilterPacket(IMultiBucketSingleFileReplicationOrderedPacket beforeFilterPacket) {
        this._beforeFilterPacket = beforeFilterPacket;
    }

    @Override
    public long getKey() {
        return this._globalKey;
    }

    @Override
    public long getEndKey() {
        return this._globalKey;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternalImpl(out);
    }

    public void writeToSwap(ObjectOutput out) throws IOException {
        this.writeExternalImpl(out);
    }

    private void writeExternalImpl(ObjectOutput out) throws IOException {
        out.writeLong(this._globalKey);
        this.writeBucketKeys(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternalImpl(in);
    }

    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternalImpl(in);
    }

    private void readExternalImpl(ObjectInput in) throws IOException {
        this._globalKey = in.readLong();
        this.readBucketKeys(in);
    }

    @Override
    public abstract AbstractMultiBucketOrderedPacket clone();

    public String toString() {
        return "globalKey=" + this._globalKey + " keys=" + this._bucketsKeys + " data=" + this.getData();
    }

    public int hashCode() {
        return (int)(this._globalKey ^ this._globalKey >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMultiBucketOrderedPacket other = (AbstractMultiBucketOrderedPacket)obj;
        if (this._bucketsKeys == null ? other._bucketsKeys != null : !this._bucketsKeys.equals(other._bucketsKeys)) {
            return false;
        }
        return this._globalKey == other._globalKey;
    }

    @Override
    public int getWeight() {
        if (this._beforeFilterPacket != null) {
            return this._beforeFilterPacket.getWeight();
        }
        return 1;
    }
}

