/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile;

import com.gigaspaces.cluster.replication.ReplicationException;
import com.gigaspaces.internal.cluster.node.impl.ReplicationMultipleOperationType;
import com.gigaspaces.internal.cluster.node.impl.ReplicationOutContext;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.backlog.AbstractSingleFileGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.CompletedHandshakeContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.EmptyIdleStateData;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.backlog.IIdleStateData;
import com.gigaspaces.internal.cluster.node.impl.backlog.NonExistingBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.BucketKey;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.DeletedMultiBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.IMultiBucketSingleFileReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileBacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileConfirmationHolder;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultipleBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.SingleBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.SourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeContext;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.ISyncReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataProducer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessLogHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileProcessResult;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.ShortLongIterator;
import com.gigaspaces.internal.collections.ShortLongMap;
import com.gigaspaces.internal.collections.ShortObjectMap;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.jini.core.transaction.server.ServerTransaction;

public abstract class AbstractMultiBucketSingleFileGroupBacklog
extends AbstractSingleFileGroupBacklog<IMultiBucketSingleFileReplicationOrderedPacket, MultiBucketSingleFileConfirmationHolder> {
    protected final long[] _bucketLastKeys;
    protected final ShortLongMap _bucketsDeletionState;
    private final short _numberOfBuckets;

    public AbstractMultiBucketSingleFileGroupBacklog(DynamicSourceGroupConfigHolder sourceConfig, String name, IReplicationPacketDataProducer<?> dataProducer) {
        super(sourceConfig, name, dataProducer);
        MultiBucketSingleFileBacklogConfig backlogConfig = (MultiBucketSingleFileBacklogConfig)((SourceGroupConfig)this.getGroupConfigSnapshot()).getBacklogConfig();
        this._numberOfBuckets = backlogConfig.getBucketsCount();
        this._bucketLastKeys = new long[this._numberOfBuckets];
        this._bucketsDeletionState = CollectionsFactory.getInstance().createShortLongMap();
    }

    @Override
    protected Map<String, MultiBucketSingleFileConfirmationHolder> createConfirmationMap(SourceGroupConfig groupConfig) {
        HashMap<String, MultiBucketSingleFileConfirmationHolder> result = new HashMap<String, MultiBucketSingleFileConfirmationHolder>();
        short bucketsCount = ((MultiBucketSingleFileBacklogConfig)groupConfig.getBacklogConfig()).getBucketsCount();
        for (String member : groupConfig.getMembersLookupNames()) {
            long[] bucketLastConfirmedKeys = this.createEmptyBucketConfirmation(bucketsCount);
            result.put(member, new MultiBucketSingleFileConfirmationHolder(bucketLastConfirmedKeys));
        }
        return result;
    }

    @Override
    protected MultiBucketSingleFileConfirmationHolder createNewConfirmationHolder() {
        MultiBucketSingleFileConfirmationHolder confirmationHolder = new MultiBucketSingleFileConfirmationHolder(this.createEmptyBucketConfirmation(this._numberOfBuckets));
        this.updateConfirmationHolderToCurrentLast(confirmationHolder);
        return confirmationHolder;
    }

    private long[] createEmptyBucketConfirmation(short bucketsCount) {
        long[] bucketLastConfirmedKeys = new long[bucketsCount];
        for (int i = 0; i < bucketLastConfirmedKeys.length; ++i) {
            bucketLastConfirmedKeys[i] = -1L;
        }
        return bucketLastConfirmedKeys;
    }

    protected MultiBucketSingleFileConfirmationHolder getConfirmationHolder(String memberName) {
        this._rwLock.readLock().lock();
        try {
            MultiBucketSingleFileConfirmationHolder multiBucketSingleFileConfirmationHolder = (MultiBucketSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
            return multiBucketSingleFileConfirmationHolder;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiBucketSingleFileHandshakeRequest getHandshakeRequest(String memberName, Object customBacklogMetadata) {
        this._rwLock.writeLock().lock();
        try {
            MultiBucketSingleFileConfirmationHolder confirmationHolder = (MultiBucketSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
            long globalLastConfirmedKey = confirmationHolder.getGlobalLastConfirmedKey();
            long[] lastConfirmedKeys = confirmationHolder.getBucketLastConfirmedKeys();
            boolean isFirstHandshake = !confirmationHolder.hadAnyHandshake();
            MultiBucketSingleFileHandshakeRequest multiBucketSingleFileHandshakeRequest = new MultiBucketSingleFileHandshakeRequest(isFirstHandshake ? -1L : globalLastConfirmedKey, lastConfirmedKeys, isFirstHandshake);
            return multiBucketSingleFileHandshakeRequest;
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IHandshakeContext processHandshakeResponse(String memberName, IBacklogHandshakeRequest request, IProcessLogHandshakeResponse response, PlatformLogicalVersion targetLogicalVersion, Object customBacklogMetadata) {
        this._rwLock.writeLock().lock();
        try {
            MultiBucketSingleFileHandshakeResponse typedResponse = (MultiBucketSingleFileHandshakeResponse)response;
            long[] lastProcessesKeysBuckets = typedResponse.getLastProcessesKeysBuckets();
            long lastProcessedGlobalKey = typedResponse.getLastProcessedGlobalKey();
            MultiBucketSingleFileConfirmationHolder confirmationHolder = (MultiBucketSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
            long[] lastConfirmedKeys = confirmationHolder.getBucketLastConfirmedKeys();
            confirmationHolder.overrideGlobalLastConfirmedKey(lastProcessedGlobalKey);
            for (int i = 0; i < lastConfirmedKeys.length; ++i) {
                lastConfirmedKeys[i] = lastProcessesKeysBuckets[i];
            }
            CompletedHandshakeContext completedHandshakeContext = new CompletedHandshakeContext();
            return completedHandshakeContext;
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBacklogMemberState getState(String memberName) {
        this._rwLock.readLock().lock();
        try {
            MultiBucketSingleFileConfirmationHolder confirmationHolder = (MultiBucketSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
            if (confirmationHolder == null) {
                NonExistingBacklogMemberState nonExistingBacklogMemberState = NonExistingBacklogMemberState.INSTANCE;
                return nonExistingBacklogMemberState;
            }
            long lastConfirmedKey = confirmationHolder.getGlobalLastConfirmedKey();
            boolean hadAnyHandshake = confirmationHolder.hadAnyHandshake();
            Throwable pendingError = confirmationHolder.hasPendingError() ? confirmationHolder.getPendingError() : null;
            boolean backlogDropped = this._outOfSyncDueToDeletionTargets.contains(memberName);
            MultiBucketSingleFileBacklogMemberState multiBucketSingleFileBacklogMemberState = new MultiBucketSingleFileBacklogMemberState(memberName, hadAnyHandshake, lastConfirmedKey, confirmationHolder.getBucketLastConfirmedKeys(), backlogDropped, pendingError);
            return multiBucketSingleFileBacklogMemberState;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResult(String memberName, IProcessResult result, List<IReplicationOrderedPacket> packets) throws ReplicationException {
        block5: {
            this._rwLock.writeLock().lock();
            try {
                MultiBucketSingleFileProcessResult typedResult = (MultiBucketSingleFileProcessResult)result;
                if (typedResult.isProcessed()) {
                    MultiBucketSingleFileConfirmationHolder confirmationHolder = (MultiBucketSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
                    IMultiBucketSingleFileReplicationOrderedPacket typedPacket = null;
                    long lastConfirmedKey = confirmationHolder.getGlobalLastConfirmedKey();
                    for (IReplicationOrderedPacket packet : packets) {
                        typedPacket = (IMultiBucketSingleFileReplicationOrderedPacket)packet;
                        lastConfirmedKey = typedPacket.processResult(memberName, typedResult, confirmationHolder);
                    }
                    this.cleanPendingErrorStateIfNeeded(memberName, lastConfirmedKey, confirmationHolder);
                    this.clearConfirmedPackets();
                    break block5;
                }
                IReplicationOrderedPacket lastPacket = packets.get(packets.size() - 1);
                Throwable error = typedResult.getError();
                this.handlePendingErrorBatchPackets(memberName, packets, error, lastPacket.getKey());
                throw new ReplicationException(error.getMessage(), error);
            }
            finally {
                this._rwLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResult(String memberName, IProcessResult result, IReplicationOrderedPacket packet) throws ReplicationException {
        block4: {
            this._rwLock.writeLock().lock();
            try {
                MultiBucketSingleFileProcessResult typedResult = (MultiBucketSingleFileProcessResult)result;
                if (typedResult.isProcessed()) {
                    IMultiBucketSingleFileReplicationOrderedPacket typedPacket = (IMultiBucketSingleFileReplicationOrderedPacket)packet;
                    MultiBucketSingleFileConfirmationHolder confirmationHolder = (MultiBucketSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
                    long lastConfirmedKey = typedPacket.processResult(memberName, typedResult, confirmationHolder);
                    this.cleanPendingErrorStateIfNeeded(memberName, lastConfirmedKey, confirmationHolder);
                    this.clearConfirmedPackets();
                    break block4;
                }
                Throwable error = typedResult.getError();
                this.handlePendingErrorSinglePacket(memberName, packet, error);
                throw new ReplicationException(error.getMessage(), error);
            }
            finally {
                this._rwLock.writeLock().unlock();
            }
        }
    }

    @Override
    protected long getLastConfirmedKeyUnsafe(String memberLookupName) {
        MultiBucketSingleFileConfirmationHolder confirmationHolder = (MultiBucketSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(memberLookupName);
        return confirmationHolder.hadAnyHandshake() ? confirmationHolder.getGlobalLastConfirmedKey() : -1L;
    }

    @Override
    protected long getMemberUnconfirmedKey(MultiBucketSingleFileConfirmationHolder value) {
        return value.hadAnyHandshake() ? value.getGlobalLastConfirmedKey() : -1L;
    }

    @Override
    protected DeletedMultiBucketOrderedPacket createBacklogOverflowPacket(long globalLastConfirmedKey, long firstKeyInBacklog, String memberName) {
        ShortObjectMap<BucketKey> bucketStartKeys = CollectionsFactory.getInstance().createShortObjectMap();
        ShortLongMap bucketEndKeys = CollectionsFactory.getInstance().createShortLongMap();
        Collection allConfirmations = this.getAllConfirmationHoldersUnsafe();
        long[] minConfirmation = null;
        for (MultiBucketSingleFileConfirmationHolder confirmationHolder : allConfirmations) {
            if (minConfirmation == null) {
                minConfirmation = confirmationHolder.getBucketLastConfirmedKeys();
                continue;
            }
            long[] bucketLastConfirmedKeys = confirmationHolder.getBucketLastConfirmedKeys();
            for (int i = 0; i < bucketLastConfirmedKeys.length; i = (int)((short)(i + 1))) {
                if (minConfirmation[i] == -1L || bucketLastConfirmedKeys[i] != -1L && bucketLastConfirmedKeys[i] >= minConfirmation[i]) continue;
                minConfirmation[i] = bucketLastConfirmedKeys[i];
            }
        }
        long[] bucketLastConfirmedKeys = ((MultiBucketSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(memberName)).getBucketLastConfirmedKeys();
        ShortLongIterator it = this._bucketsDeletionState.iterator();
        while (it.hasNext()) {
            it.advance();
            short bucketIndex = it.key();
            long lastDeletedKey = it.value();
            long minBucketConfirmedKey = minConfirmation[bucketIndex];
            if (minBucketConfirmedKey != -1L && minBucketConfirmedKey > lastDeletedKey) {
                it.remove();
                continue;
            }
            long bucketLastConfirmedKey = bucketLastConfirmedKeys[bucketIndex];
            if (lastDeletedKey <= bucketLastConfirmedKey) continue;
            bucketStartKeys.put(bucketIndex, new BucketKey(bucketLastConfirmedKey + 1L));
            bucketEndKeys.put(bucketIndex, lastDeletedKey);
        }
        return new DeletedMultiBucketOrderedPacket(globalLastConfirmedKey + 1L, firstKeyInBacklog - 1L, bucketStartKeys, bucketEndKeys);
    }

    @Override
    protected void onBeginSynchronization(String memberName) {
        MultiBucketSingleFileConfirmationHolder confirmationHolder = (MultiBucketSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
        this.updateConfirmationHolderToCurrentLast(confirmationHolder);
    }

    protected void updateConfirmationHolderToCurrentLast(MultiBucketSingleFileConfirmationHolder confirmationHolder) {
        confirmationHolder.overrideGlobalLastConfirmedKey(this.getNextKeyUnsafe() - 1L);
        confirmationHolder.overrideBucketKeys(this._bucketLastKeys);
    }

    public SingleBucketOrderedPacket addSingleOperationPacket(ISyncReplicationGroupOutContext groupContext, IEntryHolder entryHolder, ReplicationSingleOperationType operationType) {
        ReplicationOutContext outContext = groupContext.getEntireContext();
        Object data = this.getDataProducer().createSingleOperationData(entryHolder, operationType, outContext);
        return this.createAndInsertSingleBucketPacket((IReplicationPacketData<?>)data, outContext);
    }

    public SingleBucketOrderedPacket addGenericOperationPacket(ISyncReplicationGroupOutContext groupContext, Object operationData, ReplicationSingleOperationType operationType) {
        ReplicationOutContext outContext = groupContext.getEntireContext();
        Object data = this.getDataProducer().createGenericOperationData(operationData, operationType, outContext);
        return this.createAndInsertSingleBucketPacket((IReplicationPacketData<?>)data, outContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SingleBucketOrderedPacket createAndInsertSingleBucketPacket(IReplicationPacketData<?> data, ReplicationOutContext outContext) {
        this._rwLock.writeLock().lock();
        try {
            this.setPacketWeight(data);
            if (!this.shouldInsertPacket(data)) {
                SingleBucketOrderedPacket singleBucketOrderedPacket = null;
                return singleBucketOrderedPacket;
            }
            IReplicationPacketEntryData entryData = data.getSingleEntryData();
            short bucketId = this.extractBucketIndex(entryData);
            long key = this._bucketLastKeys[bucketId];
            this._bucketLastKeys[bucketId] = key + 1L;
            SingleBucketOrderedPacket packet = new SingleBucketOrderedPacket(this.takeNextKeyUnsafe(outContext), key, bucketId, data);
            this.insertPacketToBacklog(packet, outContext);
            SingleBucketOrderedPacket singleBucketOrderedPacket = packet;
            return singleBucketOrderedPacket;
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    private short extractBucketIndex(IReplicationPacketEntryData entryData) {
        return (short)Math.abs(entryData.getOrderCode() % this._numberOfBuckets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMultiBucketSingleFileReplicationOrderedPacket addTransactionOperationPacket(ISyncReplicationGroupOutContext groupContext, ServerTransaction transaction, ArrayList<IEntryHolder> lockedEntries, ReplicationMultipleOperationType operationType) {
        Object data = this.getDataProducer().createTransactionOperationData(transaction, lockedEntries, groupContext.getEntireContext(), operationType);
        if (data.isEmpty()) {
            return null;
        }
        this._rwLock.writeLock().lock();
        try {
            this.setPacketWeight((IReplicationPacketData<?>)data);
            if (!this.shouldInsertPacket((IReplicationPacketData<?>)data)) {
                IMultiBucketSingleFileReplicationOrderedPacket iMultiBucketSingleFileReplicationOrderedPacket = null;
                return iMultiBucketSingleFileReplicationOrderedPacket;
            }
            boolean firstEntryData = true;
            short singleBucketIndex = 0;
            long singleBucketKey = 0L;
            ShortObjectMap<BucketKey> bucketsKeys = null;
            for (IReplicationPacketEntryData entryData : data) {
                if (firstEntryData) {
                    singleBucketIndex = this.extractBucketIndex(entryData);
                    singleBucketKey = this._bucketLastKeys[singleBucketIndex];
                    this._bucketLastKeys[singleBucketIndex] = singleBucketKey + 1L;
                    firstEntryData = false;
                    continue;
                }
                short bucketIndex = this.extractBucketIndex(entryData);
                if (bucketIndex == singleBucketIndex) continue;
                if (bucketsKeys == null) {
                    bucketsKeys = CollectionsFactory.getInstance().createShortObjectMap();
                    bucketsKeys.put(singleBucketIndex, new BucketKey(singleBucketKey));
                }
                if (bucketsKeys.containsKey(bucketIndex)) continue;
                long key = this._bucketLastKeys[bucketIndex];
                this._bucketLastKeys[bucketIndex] = key + 1L;
                bucketsKeys.put(bucketIndex, new BucketKey(key));
            }
            if (firstEntryData) {
                throw new IllegalArgumentException("cannot add an empty transaction to replication backlog");
            }
            IMultiBucketSingleFileReplicationOrderedPacket packet = bucketsKeys != null ? new MultipleBucketOrderedPacket(this.takeNextKeyUnsafe(groupContext.getEntireContext()), bucketsKeys, (IReplicationPacketData<?>)data) : new SingleBucketOrderedPacket(this.takeNextKeyUnsafe(groupContext.getEntireContext()), singleBucketKey, singleBucketIndex, (IReplicationPacketData<?>)data);
            this.insertPacketToBacklog(packet, groupContext.getEntireContext());
            IMultiBucketSingleFileReplicationOrderedPacket iMultiBucketSingleFileReplicationOrderedPacket = packet;
            return iMultiBucketSingleFileReplicationOrderedPacket;
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    private void insertPacketToBacklog(IMultiBucketSingleFileReplicationOrderedPacket packet, ReplicationOutContext outContext) {
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.finest(this.getLogPrefix() + "inserting packet [" + packet + "] to backlog");
        }
        try {
            this.insertReplicationOrderedPacketToBacklog(packet, outContext);
        }
        catch (RuntimeException e) {
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, "exception while inserting a packet to the backlog file (insertPacketToBacklog), [" + this.getStatistics() + "]", e);
            }
            this.validateIntegrity();
            throw e;
        }
    }

    @Override
    public IMultiBucketSingleFileReplicationOrderedPacket replaceWithDiscarded(IReplicationOrderedPacket packet, boolean forceDiscard) {
        IMultiBucketSingleFileReplicationOrderedPacket typedPacket = (IMultiBucketSingleFileReplicationOrderedPacket)packet;
        return typedPacket.replaceWithDiscarded();
    }

    @Override
    public boolean mergeWithDiscarded(IReplicationOrderedPacket previousDiscardedPacket, IReplicationOrderedPacket mergedPacket, String memberName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportDiscardMerge() {
        return false;
    }

    @Override
    protected void deleteBatchFromBacklog(long deletionBatchSize) {
        if (deletionBatchSize == 0L) {
            return;
        }
        long size = this.getBacklogFile().size();
        int i = 0;
        while ((long)i < Math.min(size, deletionBatchSize)) {
            IMultiBucketSingleFileReplicationOrderedPacket oldestPacket = (IMultiBucketSingleFileReplicationOrderedPacket)this.getBacklogFile().removeOldest();
            for (short bucketIndex : oldestPacket.getBuckets()) {
                this._bucketsDeletionState.put(bucketIndex, oldestPacket.getBucketKey(bucketIndex));
            }
            ++i;
        }
    }

    @Override
    public IProcessResult fromWireForm(Object wiredProcessResult) {
        if (wiredProcessResult == null) {
            return MultiBucketSingleFileProcessResult.OK;
        }
        return (IProcessResult)wiredProcessResult;
    }

    @Override
    public String dumpState() {
        this._rwLock.readLock().lock();
        try {
            StringBuilder dump = new StringBuilder("Type [" + this.getClass().getName() + "]");
            dump.append(StringUtils.NEW_LINE);
            dump.append("Backlog statistics {" + this.getStatistics() + "}");
            dump.append(StringUtils.NEW_LINE);
            dump.append("Buckets " + AbstractMultiBucketSingleFileGroupBacklog.printBucketsKeys(this._bucketLastKeys));
            dump.append(StringUtils.NEW_LINE);
            dump.append("Buckets Deletion state " + AbstractMultiBucketSingleFileGroupBacklog.toString(this._bucketsDeletionState));
            dump.append(StringUtils.NEW_LINE);
            this.appendConfirmationStateString(dump);
            String string = dump.toString();
            return string;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    public static String printBucketsKeys(long[] keys) {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < keys.length; ++i) {
            sb.append(i);
            sb.append(": ");
            sb.append(keys[i]);
            if (i >= keys.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private static String toString(ShortLongMap bucketsDeletionState) {
        StringBuilder result = new StringBuilder("{");
        ShortLongIterator it = bucketsDeletionState.iterator();
        while (it.hasNext()) {
            it.advance();
            result.append(it.key());
            result.append("=");
            result.append(it.value());
            result.append(",");
        }
        result.append("}");
        return result.toString();
    }

    @Override
    public IIdleStateData getIdleStateData(String memberName, PlatformLogicalVersion targetMemberVersion) {
        return EmptyIdleStateData.INSTANCE;
    }

    @Override
    public void processIdleStateDataResult(String memberName, IProcessResult result, IIdleStateData idleStateData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getConfirmed(String memberName) {
        this._rwLock.readLock().lock();
        try {
            long l = this.getLastConfirmedKeyUnsafe(memberName);
            return l;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }
}

