/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile;

import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.IMultiBucketSingleFileReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.ISingleBucketReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileConfirmationHolder;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.PacketConsumeState;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileProcessResult;
import com.gigaspaces.internal.collections.ShortObjectMap;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractSingleBucketOrderedPacket
implements ISingleBucketReplicationOrderedPacket {
    private static final long serialVersionUID = 1L;
    private long _bucketKey;
    private short _bucketIndex;
    private long _globalKey;
    private transient IMultiBucketSingleFileReplicationOrderedPacket _beforeFilterPacket;

    public AbstractSingleBucketOrderedPacket() {
    }

    public AbstractSingleBucketOrderedPacket(long globalKey, long bucketKey, short bucketIndex) {
        this._globalKey = globalKey;
        this._bucketKey = bucketKey;
        this._bucketIndex = bucketIndex;
    }

    @Override
    public long getKey() {
        return this._globalKey;
    }

    @Override
    public long getEndKey() {
        return this._globalKey;
    }

    @Override
    public long getBucketKey(short bucketIndex) {
        if (this._bucketIndex != bucketIndex) {
            throw new IllegalArgumentException("This packet only belong to bucket " + this._bucketIndex + " and not to " + bucketIndex);
        }
        return this._bucketKey;
    }

    @Override
    public short[] getBuckets() {
        return new short[]{this._bucketIndex};
    }

    @Override
    public PacketConsumeState getConsumeState(short bucketIndex) {
        if (bucketIndex != this._bucketIndex) {
            throw new IllegalArgumentException("This packet only belong to bucket " + this._bucketIndex + " and not to " + bucketIndex);
        }
        return PacketConsumeState.CAN_CONSUME;
    }

    @Override
    public boolean setConsumed() {
        return true;
    }

    @Override
    public short getBucketIndex() {
        return this._bucketIndex;
    }

    @Override
    public long getBucketKey() {
        return this._bucketKey;
    }

    @Override
    public short bucketCount() {
        return 1;
    }

    @Override
    public void associateToBuckets(ShortObjectMap<List<IMultiBucketSingleFileReplicationOrderedPacket>> bucketsPackets) {
        List<IMultiBucketSingleFileReplicationOrderedPacket> list = bucketsPackets.get(this._bucketIndex);
        if (list == null) {
            list = new LinkedList<IMultiBucketSingleFileReplicationOrderedPacket>();
            bucketsPackets.put(this._bucketIndex, list);
        }
        list.add(this);
    }

    @Override
    public long processResult(String memberName, MultiBucketSingleFileProcessResult processResult, MultiBucketSingleFileConfirmationHolder confirmationHolder) {
        short bucketIndex = this._bucketIndex;
        long bucketKey = this._bucketKey;
        Long knownLastConfirmedKey = confirmationHolder.getBucketLastConfirmedKeys()[bucketIndex];
        if (knownLastConfirmedKey == null || knownLastConfirmedKey < bucketKey) {
            confirmationHolder.getBucketLastConfirmedKeys()[bucketIndex] = bucketKey;
        }
        return confirmationHolder.addGlobalKeyConfirmed(this.getKey());
    }

    @Override
    public void reliableAsyncKeysUpdate(long[] bucketLastKeys, MultiBucketSingleFileConfirmationHolder confirmationHolder) {
        short bucketIndex = this._bucketIndex;
        long bucketKey = this._bucketKey;
        bucketLastKeys[bucketIndex] = bucketKey + 1L;
        confirmationHolder.overrideGlobalLastConfirmedKey(this._globalKey);
        confirmationHolder.getBucketLastConfirmedKeys()[bucketIndex] = this._bucketKey;
    }

    @Override
    public IMultiBucketSingleFileReplicationOrderedPacket getReliableAsyncBeforeFilterPacket() {
        return this._beforeFilterPacket;
    }

    @Override
    public void setReliableAsyncBeforeFilterPacket(IMultiBucketSingleFileReplicationOrderedPacket beforeFilterPacket) {
        this._beforeFilterPacket = beforeFilterPacket;
    }

    @Override
    public abstract AbstractSingleBucketOrderedPacket clone();

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternalImpl(out);
    }

    public void writeToSwap(ObjectOutput out) throws IOException {
        this.writeExternalImpl(out);
    }

    private void writeExternalImpl(ObjectOutput out) throws IOException {
        out.writeLong(this._globalKey);
        out.writeLong(this._bucketKey);
        out.writeShort(this._bucketIndex);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternalImpl(in);
    }

    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternalImpl(in);
    }

    private void readExternalImpl(ObjectInput in) throws IOException {
        this._globalKey = in.readLong();
        this._bucketKey = in.readLong();
        this._bucketIndex = in.readShort();
    }

    public String toString() {
        return "sourceGlobalKey=" + this._globalKey + " bucketIndex=" + this._bucketIndex + " bucketKey=" + this._bucketKey + " data=" + this.getData();
    }

    public int hashCode() {
        return (int)(this._globalKey ^ this._globalKey >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSingleBucketOrderedPacket other = (AbstractSingleBucketOrderedPacket)obj;
        if (this._bucketIndex != other._bucketIndex) {
            return false;
        }
        if (this._bucketKey != other._bucketKey) {
            return false;
        }
        return this._globalKey == other._globalKey;
    }

    @Override
    public int getWeight() {
        if (this._beforeFilterPacket != null) {
            return this._beforeFilterPacket.getWeight();
        }
        return 1;
    }
}

