/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.AbstractMultiBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.BucketKey;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.IMultiBucketSingleFileReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileConfirmationHolder;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.PacketConsumeState;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilterCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.DiscardReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.IMultiBucketSingleFileProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.ParallelBatchProcessingContext;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.ShortLongIterator;
import com.gigaspaces.internal.collections.ShortLongMap;
import com.gigaspaces.internal.collections.ShortObjectMap;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class DeletedMultiBucketOrderedPacket
extends AbstractMultiBucketOrderedPacket {
    private static final long serialVersionUID = 1L;
    private long _globalEndKey;
    private ShortLongMap _bucketsEndKeys;
    private boolean _consumed;

    public DeletedMultiBucketOrderedPacket() {
    }

    public DeletedMultiBucketOrderedPacket(long startGlobalKey, long endGlobalKey, ShortObjectMap<BucketKey> bucketsStartKeys, ShortLongMap bucketEndKeys) {
        super(startGlobalKey, bucketsStartKeys);
        this._globalEndKey = endGlobalKey;
        this._bucketsEndKeys = bucketEndKeys;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.writeExternalImpl(out);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        this.writeExternalImpl(out);
    }

    private void writeExternalImpl(ObjectOutput out) throws IOException {
        out.writeLong(this._globalEndKey);
        this._bucketsEndKeys.serialize(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.readExternalImpl(in);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this.readExternalImpl(in);
    }

    private void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        this._globalEndKey = in.readLong();
        this._bucketsEndKeys = CollectionsFactory.getInstance().deserializeShortLongMap(in);
    }

    @Override
    public IReplicationPacketData<?> getData() {
        return DiscardReplicationPacketData.instance();
    }

    @Override
    public long getEndKey() {
        return this._globalEndKey;
    }

    public long getBucketEndKey(short bucketIndex) {
        if (!this._bucketsEndKeys.containsKey(bucketIndex)) {
            throw new IllegalArgumentException("No bucket end key exists for bucket index " + bucketIndex);
        }
        return this._bucketsEndKeys.get(bucketIndex);
    }

    @Override
    public boolean isDataPacket() {
        return false;
    }

    @Override
    public boolean isDiscardedPacket() {
        return false;
    }

    @Override
    public DeletedMultiBucketOrderedPacket clone() {
        return this;
    }

    @Override
    public IMultiBucketSingleFileReplicationOrderedPacket cloneWithNewData(IReplicationPacketData<?> newData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MultiBucketSingleFileProcessResult process(String sourceLookupName, IMultiBucketSingleFileProcessLog processLog, IReplicationInFilterCallback inFilterCallback, ParallelBatchProcessingContext context, int segmentIndex) {
        return processLog.process(sourceLookupName, this, inFilterCallback, context, segmentIndex);
    }

    @Override
    public long processResult(String memberName, MultiBucketSingleFileProcessResult processResult, MultiBucketSingleFileConfirmationHolder confirmationHolder) {
        ShortLongIterator iterator = this._bucketsEndKeys.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            short bucketIndex = iterator.key();
            long bucketKey = iterator.value();
            Long knownLastConfirmedKey = confirmationHolder.getBucketLastConfirmedKeys()[bucketIndex];
            if (knownLastConfirmedKey != null && knownLastConfirmedKey >= bucketKey) continue;
            confirmationHolder.getBucketLastConfirmedKeys()[bucketIndex] = bucketKey;
        }
        return confirmationHolder.overrideGlobalLastConfirmedKey(this.getEndKey());
    }

    @Override
    public void reliableAsyncKeysUpdate(long[] bucketLastKeys, MultiBucketSingleFileConfirmationHolder confirmationHolder) {
        ShortLongIterator iterator = this._bucketsEndKeys.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            short bucketIndex = iterator.key();
            long bucketKey = iterator.value();
            bucketLastKeys[bucketIndex] = bucketKey + 1L;
            confirmationHolder.getBucketLastConfirmedKeys()[bucketIndex] = bucketKey;
        }
        confirmationHolder.overrideGlobalLastConfirmedKey(this.getEndKey());
    }

    @Override
    public PacketConsumeState getConsumeState(short bucketIndex) {
        return PacketConsumeState.CAN_CONSUME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setConsumed() {
        if (this._consumed) {
            return false;
        }
        DeletedMultiBucketOrderedPacket deletedMultiBucketOrderedPacket = this;
        synchronized (deletedMultiBucketOrderedPacket) {
            if (this._consumed) {
                return false;
            }
            this._consumed = true;
            return true;
        }
    }

    @Override
    public IMultiBucketSingleFileReplicationOrderedPacket replaceWithDiscarded() {
        throw new IllegalStateException("DeletedMultiBucketOrderedPacket should not be replaced by discarded packet");
    }
}

