/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogMemberState;
import com.gigaspaces.internal.io.IOUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

@InternalApi
public class MultiBucketSingleFileBacklogMemberState
implements IBacklogMemberState {
    private static final long serialVersionUID = 1L;
    private String _memberName;
    private boolean _backlogDropped;
    private long _lastConfirmedKey;
    private long[] _bucketLastConfirmedKeys;
    private boolean _hadAnyHandshake;
    private Throwable _inconsistencyReason;

    public MultiBucketSingleFileBacklogMemberState() {
    }

    public MultiBucketSingleFileBacklogMemberState(String memberName, boolean hadAnyHandshake, long lastConfirmedKey, long[] bucketLastConfirmedKeys, boolean backlogDropped, Throwable inconsistencyReason) {
        this._memberName = memberName;
        this._hadAnyHandshake = hadAnyHandshake;
        this._lastConfirmedKey = lastConfirmedKey;
        this._bucketLastConfirmedKeys = bucketLastConfirmedKeys;
        this._backlogDropped = backlogDropped;
        this._inconsistencyReason = inconsistencyReason;
    }

    @Override
    public boolean isExistingMember() {
        return true;
    }

    @Override
    public boolean isBacklogDropped() {
        return this._backlogDropped;
    }

    @Override
    public boolean isInconsistent() {
        return this._inconsistencyReason != null;
    }

    @Override
    public long getLastConfirmedKey() {
        return this._lastConfirmedKey;
    }

    @Override
    public Throwable getInconsistencyReason() {
        return this._inconsistencyReason;
    }

    @Override
    public String toLogMessage() {
        return "Member [" + this._memberName + "] Had any handshake [" + this._hadAnyHandshake + "] Last confirmed key [" + this.getLastConfirmedKey() + "] Buckets confirmed keys " + Arrays.toString(this._bucketLastConfirmedKeys) + " Backlog dropped [" + this._backlogDropped + "]";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeRepetitiveString(out, this._memberName);
        out.writeBoolean(this._hadAnyHandshake);
        out.writeLong(this._lastConfirmedKey);
        out.writeBoolean(this._backlogDropped);
        IOUtils.writeObject(out, this._bucketLastConfirmedKeys);
        IOUtils.writeObject(out, this._inconsistencyReason);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._memberName = IOUtils.readRepetitiveString(in);
        this._hadAnyHandshake = in.readBoolean();
        this._lastConfirmedKey = in.readLong();
        this._backlogDropped = in.readBoolean();
        this._bucketLastConfirmedKeys = (long[])IOUtils.readObject(in);
        this._inconsistencyReason = (Throwable)IOUtils.readObject(in);
    }
}

