/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.AbstractSingleFileConfirmationHolder;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.AbstractMultiBucketSingleFileGroupBacklog;
import com.gigaspaces.internal.utils.StringUtils;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

@InternalApi
public class MultiBucketSingleFileConfirmationHolder
extends AbstractSingleFileConfirmationHolder {
    private final long[] _bucketLastConfirmedKeys;
    private long _globalLastConfirmedKey = -1L;
    private boolean _hadAnyHandshake = false;
    private final SortedSet<Long> _globalLastConfirmedKeysWindow = new TreeSet<Long>();

    public MultiBucketSingleFileConfirmationHolder(long[] bucketLastConfirmedKeys) {
        this._bucketLastConfirmedKeys = bucketLastConfirmedKeys;
    }

    public long[] getBucketLastConfirmedKeys() {
        return this._bucketLastConfirmedKeys;
    }

    public long getGlobalLastConfirmedKey() {
        return this._globalLastConfirmedKey;
    }

    @Override
    public long getLastConfirmedKey() {
        return this.getGlobalLastConfirmedKey();
    }

    public boolean hadAnyHandshake() {
        return this._hadAnyHandshake;
    }

    public long overrideGlobalLastConfirmedKey(long globalLastConfirmedKey) {
        this._hadAnyHandshake = true;
        this._globalLastConfirmedKey = globalLastConfirmedKey;
        long nextConsecutiveGlobalKey = this._globalLastConfirmedKey + 1L;
        Iterator iterator = this._globalLastConfirmedKeysWindow.iterator();
        while (iterator.hasNext()) {
            Long globalConfirmedKey = (Long)iterator.next();
            if (globalConfirmedKey <= this._globalLastConfirmedKey) {
                iterator.remove();
                continue;
            }
            if (globalConfirmedKey != nextConsecutiveGlobalKey) break;
            iterator.remove();
            this._globalLastConfirmedKey = globalConfirmedKey;
            ++nextConsecutiveGlobalKey;
        }
        return this._globalLastConfirmedKey;
    }

    public void overrideBucketKeys(long[] bucketNextKeys) {
        for (int i = 0; i < bucketNextKeys.length; ++i) {
            this._bucketLastConfirmedKeys[i] = bucketNextKeys[i] - 1L;
        }
    }

    public long addGlobalKeyConfirmed(long globalKey) {
        this._hadAnyHandshake = true;
        long nextConsecutiveGlobalKey = this._globalLastConfirmedKey + 1L;
        if (this._globalLastConfirmedKeysWindow.isEmpty() && globalKey == nextConsecutiveGlobalKey) {
            this._globalLastConfirmedKey = globalKey;
        } else {
            Long globalConfirmedKey;
            this._globalLastConfirmedKeysWindow.add(globalKey);
            Iterator iterator = this._globalLastConfirmedKeysWindow.iterator();
            while (iterator.hasNext() && (globalConfirmedKey = (Long)iterator.next()) <= nextConsecutiveGlobalKey) {
                iterator.remove();
                if (globalConfirmedKey != nextConsecutiveGlobalKey) continue;
                this._globalLastConfirmedKey = Math.max(globalConfirmedKey, nextConsecutiveGlobalKey);
                ++nextConsecutiveGlobalKey;
            }
        }
        return this._globalLastConfirmedKey;
    }

    @Override
    public String toString() {
        return "ConfirmationHolder [_bucketLastConfirmedKeys=" + StringUtils.NEW_LINE + AbstractMultiBucketSingleFileGroupBacklog.printBucketsKeys(this._bucketLastConfirmedKeys) + ", _globalLastConfirmedKey=" + this._globalLastConfirmedKey + ", _globalLastConfirmedKeysWindow=" + this._globalLastConfirmedKeysWindow + "]";
    }
}

