/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.AbstractMultiBucketSingleFileGroupBacklog;
import com.gigaspaces.internal.io.IOUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class MultiBucketSingleFileHandshakeRequest
implements IBacklogHandshakeRequest {
    private static final long serialVersionUID = 1L;
    private long[] _bucketsConfirmedKeys;
    private long _globalConfirmedKey;
    private boolean _firstHandshake;

    public MultiBucketSingleFileHandshakeRequest(long globalConfirmedKey, long[] bucketsConfirmedKeys, boolean firstHandshake) {
        this._globalConfirmedKey = globalConfirmedKey;
        this._firstHandshake = firstHandshake;
        this._bucketsConfirmedKeys = new long[bucketsConfirmedKeys.length];
        for (int i = 0; i < bucketsConfirmedKeys.length; ++i) {
            this._bucketsConfirmedKeys[i] = bucketsConfirmedKeys[i];
        }
    }

    public MultiBucketSingleFileHandshakeRequest() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this._firstHandshake);
        out.writeLong(this._globalConfirmedKey);
        IOUtils.writeLongArray(out, this._bucketsConfirmedKeys);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._firstHandshake = in.readBoolean();
        this._globalConfirmedKey = in.readLong();
        this._bucketsConfirmedKeys = IOUtils.readLongArray(in);
    }

    @Override
    public boolean isFirstHandshake() {
        return this._firstHandshake;
    }

    public long[] getBucketsConfirmedKeys() {
        return this._bucketsConfirmedKeys;
    }

    public long getGlobalConfirmedKey() {
        return this._globalConfirmedKey;
    }

    @Override
    public String toLogMessage() {
        return "Handshake request. First handshake [" + this._firstHandshake + "]. Last global confirmed key by source [" + this.getGlobalConfirmedKey() + "] Last confirmed bucket keys by source " + AbstractMultiBucketSingleFileGroupBacklog.printBucketsKeys(this._bucketsConfirmedKeys) + "]";
    }

    public String toString() {
        return this.toLogMessage();
    }
}

