/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.ReplicationMultipleOperationType;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.backlog.CompletedHandshakeContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.NoSuchReplicationMemberException;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.IPacketFilteredHandler;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.AbstractMultiBucketSingleFileGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.DeletedMultiBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.IMultiBucketSingleFileReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileConfirmationHolder;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileReliableAsyncHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileReliableAsyncKeptDiscardedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileReliableAsyncState;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiStepHandshakeContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.SingleBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReliableAsyncState;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReplicationReliableAsyncGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.MissingReliableAsyncTargetStateException;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.ReliableAsyncHandshakeContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.ReliableAsyncHandshakeIteration;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.SynchronizeMissingPacketsHandshakeContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.SynchronizeMissingPacketsHandshakeIteration;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeContext;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeIteration;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncSourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataProducer;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessLogHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileHandshakeResponse;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class MultiBucketSingleFileReliableAsyncGroupBacklog
extends AbstractMultiBucketSingleFileGroupBacklog
implements IReplicationReliableAsyncGroupBacklog,
IPacketFilteredHandler {
    private final Map<String, Long> _ongoingReliableAsyncHandshakeCompletion = new HashMap<String, Long>();
    private final SortedSet<IMultiBucketSingleFileReplicationOrderedPacket> _insertionSorter = new TreeSet<IMultiBucketSingleFileReplicationOrderedPacket>(new PacketComperator());

    public MultiBucketSingleFileReliableAsyncGroupBacklog(DynamicSourceGroupConfigHolder groupConfig, String name, IReplicationPacketDataProducer<?> dataProducer) {
        super(groupConfig, name, dataProducer);
    }

    @Override
    public void add(ReliableAsyncReplicationGroupOutContext groupContext, IEntryHolder entryHolder, ReplicationSingleOperationType operationType) {
        if (!this.hasExistingMember()) {
            return;
        }
        SingleBucketOrderedPacket packet = this.addSingleOperationPacket(groupContext, entryHolder, operationType);
        if (packet != null) {
            groupContext.addOrderedPacket(packet);
        }
    }

    @Override
    public void addGeneric(ReliableAsyncReplicationGroupOutContext groupContext, Object operationData, ReplicationSingleOperationType operationType) {
        if (!this.hasExistingMember()) {
            return;
        }
        SingleBucketOrderedPacket packet = this.addGenericOperationPacket(groupContext, operationData, operationType);
        if (packet != null) {
            groupContext.addOrderedPacket(packet);
        }
    }

    @Override
    public void addTransaction(ReliableAsyncReplicationGroupOutContext groupContext, ServerTransaction transaction, ArrayList<IEntryHolder> lockedEntries, ReplicationMultipleOperationType operationType) {
        if (!this.hasExistingMember()) {
            return;
        }
        IMultiBucketSingleFileReplicationOrderedPacket packet = this.addTransactionOperationPacket(groupContext, transaction, lockedEntries, operationType);
        if (packet != null) {
            groupContext.addOrderedPacket(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiBucketSingleFileHandshakeRequest getHandshakeRequest(String memberName, Object customBacklogMetadata) {
        this._rwLock.writeLock().lock();
        try {
            MultiBucketSingleFileHandshakeRequest handshakeRequest = super.getHandshakeRequest(memberName, customBacklogMetadata);
            if (this.isAsyncKeeper(memberName)) {
                MultiBucketSingleFileReliableAsyncState reliableAsyncState = this.getReliableAsyncState(memberName);
                this._ongoingReliableAsyncHandshakeCompletion.put(memberName, reliableAsyncState.getMinimumUnconfirmedKey());
                MultiBucketSingleFileReliableAsyncHandshakeRequest multiBucketSingleFileReliableAsyncHandshakeRequest = new MultiBucketSingleFileReliableAsyncHandshakeRequest(handshakeRequest, reliableAsyncState);
                return multiBucketSingleFileReliableAsyncHandshakeRequest;
            }
            MultiBucketSingleFileHandshakeRequest multiBucketSingleFileHandshakeRequest = handshakeRequest;
            return multiBucketSingleFileHandshakeRequest;
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    private boolean isAsyncKeeper(String memberName) {
        ReliableAsyncSourceGroupConfig sourceGroupConfig = (ReliableAsyncSourceGroupConfig)this.getGroupConfigSnapshot();
        for (String syncMember : sourceGroupConfig.getSyncMembersLookupNames()) {
            if (!syncMember.equals(memberName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IReplicationOrderedPacket> getReliableAsyncPackets(String memberName, int maxSize, IReplicationReliableAsyncGroupBacklog.KeeperMemberState[] keeperMembersState, IReplicationChannelDataFilter dataFilter, PlatformLogicalVersion targetMemberVersion, Logger logger) {
        this._rwLock.readLock().lock();
        try {
            long minConfirmedKey = Long.MAX_VALUE;
            for (IReplicationReliableAsyncGroupBacklog.KeeperMemberState keeperMemberState : keeperMembersState) {
                if (!keeperMemberState.cannotBypass) continue;
                MultiBucketSingleFileConfirmationHolder confirmationHolder = (MultiBucketSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(keeperMemberState.memberName);
                if (!confirmationHolder.hadAnyHandshake()) {
                    minConfirmedKey = -1L;
                    break;
                }
                long lastConfirmedKey = confirmationHolder.getGlobalLastConfirmedKey();
                minConfirmedKey = Math.min(minConfirmedKey, lastConfirmedKey);
            }
            if (minConfirmedKey == -1L) {
                LinkedList<IReplicationOrderedPacket> linkedList = new LinkedList<IReplicationOrderedPacket>();
                return linkedList;
            }
            List<IReplicationOrderedPacket> list = this.getPacketsUnsafe(memberName, maxSize, minConfirmedKey, dataFilter, this._defaultFilteredHandler, targetMemberVersion, logger);
            return list;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    @Override
    public IHandshakeContext processHandshakeResponse(String memberName, IBacklogHandshakeRequest request, IProcessLogHandshakeResponse response, PlatformLogicalVersion targetLogicalVersion, Object customBacklogMetadata) {
        super.processHandshakeResponse(memberName, request, response, targetLogicalVersion, customBacklogMetadata);
        if (!this.isAsyncKeeper(memberName)) {
            return new CompletedHandshakeContext();
        }
        MultiBucketSingleFileHandshakeResponse typedResponse = (MultiBucketSingleFileHandshakeResponse)response;
        MultiBucketSingleFileReliableAsyncHandshakeRequest typedRequest = (MultiBucketSingleFileReliableAsyncHandshakeRequest)request;
        MultiBucketSingleFileReliableAsyncState reliableAsyncState = typedRequest.getReliableAsyncState();
        long minimumUnconfirmedKey = reliableAsyncState.getMinimumUnconfirmedKey();
        long lastProcessedKey = typedResponse.getLastProcessedGlobalKey();
        IHandshakeContext handshakeContext = new CompletedHandshakeContext();
        if (!Boolean.FALSE.equals(customBacklogMetadata)) {
            for (int i = 0; i < typedResponse.getLastProcessesKeysBuckets().length; ++i) {
                if (this._bucketLastKeys[i] > typedResponse.getLastProcessesKeysBuckets()[i]) continue;
                handshakeContext = new SynchronizeMissingPacketsHandshakeContext(this._bucketLastKeys[i] - 1L, typedResponse.getLastProcessesKeysBuckets()[i]);
                break;
            }
        }
        if (lastProcessedKey < minimumUnconfirmedKey) {
            this._ongoingReliableAsyncHandshakeCompletion.remove(memberName);
            return handshakeContext;
        }
        if (handshakeContext.isDone()) {
            return new ReliableAsyncHandshakeContext(minimumUnconfirmedKey, lastProcessedKey);
        }
        return new MultiStepHandshakeContext(handshakeContext, new ReliableAsyncHandshakeContext(minimumUnconfirmedKey, lastProcessedKey));
    }

    @Override
    public void reliableAsyncSourceKeep(String sourceMemberName, IReplicationOrderedPacket packet) {
        this.insertReliableAsyncPacket(sourceMemberName, packet, true);
    }

    @Override
    public void reliableAsyncSourceAdd(String sourceMemberName, IReplicationOrderedPacket packet) {
        this.insertReliableAsyncPacket(sourceMemberName, packet, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertReliableAsyncPacket(String sourceMemberName, IReplicationOrderedPacket packet, boolean allowOlderPackets) {
        ReliableAsyncSourceGroupConfig groupConfig = (ReliableAsyncSourceGroupConfig)this.getGroupConfigSnapshot();
        if (groupConfig.getAsyncMembersLookupNames().length == 0 && groupConfig.getSyncMembersLookupNames().length <= 1) {
            return;
        }
        this._rwLock.writeLock().lock();
        try {
            IMultiBucketSingleFileReplicationOrderedPacket nextPacket;
            this._insertionSorter.add((IMultiBucketSingleFileReplicationOrderedPacket)packet);
            Iterator iterator = this._insertionSorter.iterator();
            while (iterator.hasNext() && (nextPacket = (IMultiBucketSingleFileReplicationOrderedPacket)iterator.next()).getKey() <= this.getNextKeyUnsafe()) {
                this.ensureLimit(packet.getData());
                if (nextPacket instanceof DeletedMultiBucketOrderedPacket) {
                    this.setNextKeyUnsafe(((DeletedMultiBucketOrderedPacket)nextPacket).getEndKey() + 1L);
                } else {
                    this.setNextKeyUnsafe(nextPacket.getKey() + 1L);
                }
                this.getBacklogFile().add(nextPacket);
                this.increaseAllMembersWeight(nextPacket.getWeight(), nextPacket.getKey());
                nextPacket.reliableAsyncKeysUpdate(this._bucketLastKeys, (MultiBucketSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(sourceMemberName));
                iterator.remove();
            }
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    @Override
    public MultiBucketSingleFileReliableAsyncState getEntireReliableAsyncState() {
        Set<Map.Entry<String, MultiBucketSingleFileConfirmationHolder>> asyncTargetsConfirmations = this.getAllConfirmations();
        return this.buildReliableAsyncState(asyncTargetsConfirmations);
    }

    @Override
    public MultiBucketSingleFileReliableAsyncState getReliableAsyncState(String targetMemberName) {
        Set<Map.Entry<String, MultiBucketSingleFileConfirmationHolder>> asyncTargetsConfirmations = this.getAllConfirmations(targetMemberName);
        return this.buildReliableAsyncState(asyncTargetsConfirmations);
    }

    private MultiBucketSingleFileReliableAsyncState buildReliableAsyncState(Set<Map.Entry<String, MultiBucketSingleFileConfirmationHolder>> asyncTargetsConfirmations) {
        MultiBucketSingleFileReliableAsyncState.AsyncTargetState[] asyncTargetStates = new MultiBucketSingleFileReliableAsyncState.AsyncTargetState[asyncTargetsConfirmations.size()];
        int index = 0;
        for (Map.Entry<String, MultiBucketSingleFileConfirmationHolder> entry : asyncTargetsConfirmations) {
            MultiBucketSingleFileConfirmationHolder confirmationHolder = entry.getValue();
            asyncTargetStates[index++] = new MultiBucketSingleFileReliableAsyncState.AsyncTargetState(entry.getKey(), confirmationHolder.hadAnyHandshake(), confirmationHolder.getGlobalLastConfirmedKey(), confirmationHolder.getBucketLastConfirmedKeys());
        }
        return new MultiBucketSingleFileReliableAsyncState(asyncTargetStates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateReliableAsyncState(IReliableAsyncState reliableAsyncState, String sourceMemberName) throws NoSuchReplicationMemberException, MissingReliableAsyncTargetStateException {
        MultiBucketSingleFileReliableAsyncState typedState = (MultiBucketSingleFileReliableAsyncState)reliableAsyncState;
        this._rwLock.writeLock().lock();
        try {
            long[] minimumUnconfirmedBucketKeys;
            long minGlobalConfirmed;
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.finest(this.getLogPrefix() + "incoming reliable async state update " + typedState);
            }
            ReliableAsyncSourceGroupConfig sourceGroupConfig = (ReliableAsyncSourceGroupConfig)this.getGroupConfigSnapshot();
            this.validateReliableAsyncUpdateTargetsMatch(reliableAsyncState, sourceMemberName);
            for (MultiBucketSingleFileReliableAsyncState.AsyncTargetState asyncTargetState : typedState.getAsyncTargetsState()) {
                if (!asyncTargetState.hadAnyHandshake()) continue;
                long lastConfirmedKey = asyncTargetState.getGlobalLastConfirmedKey();
                long[] bucketLastConfirmedKeys = asyncTargetState.getBucketLastConfirmedKeys();
                MultiBucketSingleFileConfirmationHolder confirmationHolder = (MultiBucketSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(asyncTargetState.getTargetMemberName());
                confirmationHolder.overrideGlobalLastConfirmedKey(lastConfirmedKey);
                for (int i = 0; i < bucketLastConfirmedKeys.length; ++i) {
                    confirmationHolder.getBucketLastConfirmedKeys()[i] = bucketLastConfirmedKeys[i];
                }
            }
            if (typedState.getAsyncTargetsState().length > 0) {
                minGlobalConfirmed = typedState.getMinimumUnconfirmedKey() - 1L;
                if (this.getNextKeyUnsafe() < minGlobalConfirmed + 1L) {
                    this.setNextKeyUnsafe(minGlobalConfirmed + 1L);
                }
                minimumUnconfirmedBucketKeys = typedState.getMinimumUnconfirmedBucketKeys();
            } else {
                minGlobalConfirmed = this.getNextKeyUnsafe() - 1L;
                minimumUnconfirmedBucketKeys = new long[this._bucketLastKeys.length];
                for (int i = 0; i < minimumUnconfirmedBucketKeys.length; ++i) {
                    minimumUnconfirmedBucketKeys[i] = this._bucketLastKeys[i] - 1L;
                }
            }
            MultiBucketSingleFileConfirmationHolder confirmationHolder = (MultiBucketSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(sourceMemberName);
            this.overrideConfirmationHolderAccordingToReliableAsyncState(minGlobalConfirmed, minimumUnconfirmedBucketKeys, confirmationHolder);
            this.clearConfirmedPackets();
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    private void overrideConfirmationHolderAccordingToReliableAsyncState(long minGlobalConfirmed, long[] minimumUnconfirmedBucketKeys, MultiBucketSingleFileConfirmationHolder confirmationHolder) {
        long lastConfirmedByTarget = confirmationHolder.getGlobalLastConfirmedKey();
        if (!confirmationHolder.hadAnyHandshake() || lastConfirmedByTarget < minGlobalConfirmed) {
            confirmationHolder.overrideGlobalLastConfirmedKey(minGlobalConfirmed);
            confirmationHolder.overrideBucketKeys(minimumUnconfirmedBucketKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterHandshake(IProcessLogHandshakeResponse handshakeResponse) {
        MultiBucketSingleFileHandshakeResponse typedResponse = (MultiBucketSingleFileHandshakeResponse)handshakeResponse;
        this._rwLock.writeLock().lock();
        try {
            long newNextKey = typedResponse.getLastProcessedGlobalKey() + 1L;
            long[] lastProcessesKeysBuckets = typedResponse.getLastProcessesKeysBuckets();
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.finer(this.getLogPrefix() + " adjusting group key [" + newNextKey + "] and using last processed bucket keys " + Arrays.toString(lastProcessesKeysBuckets));
            }
            if (this.getNextKeyUnsafe() <= newNextKey) {
                if (this._logger.isLoggable(Level.FINER)) {
                    this._logger.finer(this.getLogPrefix() + " adjusting group key [" + newNextKey + "]");
                }
                this.setNextKeyUnsafe(newNextKey);
            }
            this._logger.finer(this.getLogPrefix() + " adjusting group bucket keys, existing keys " + Arrays.toString(this._bucketLastKeys) + " using last processed bucket keys " + Arrays.toString(lastProcessesKeysBuckets));
            for (int i = 0; i < lastProcessesKeysBuckets.length; ++i) {
                long nextBucketKey = lastProcessesKeysBuckets[i] + 1L;
                if (nextBucketKey <= this._bucketLastKeys[i]) continue;
                this._bucketLastKeys[i] = nextBucketKey;
            }
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    @Override
    protected long getMinimumUnconfirmedKeyUnsafe() {
        long minimumUnconfirmedKey = super.getMinimumUnconfirmedKeyUnsafe();
        if (minimumUnconfirmedKey == -1L) {
            return minimumUnconfirmedKey;
        }
        for (Long minKey : this._ongoingReliableAsyncHandshakeCompletion.values()) {
            minimumUnconfirmedKey = Math.min(minimumUnconfirmedKey, minKey);
        }
        return minimumUnconfirmedKey;
    }

    @Override
    protected long getInitialMaxAllowedDeleteUpTo() {
        long minimumUnconfirmedKey = super.getInitialMaxAllowedDeleteUpTo();
        for (Long minKey : this._ongoingReliableAsyncHandshakeCompletion.values()) {
            minimumUnconfirmedKey = Math.min(minimumUnconfirmedKey, minKey);
        }
        return minimumUnconfirmedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IHandshakeIteration getNextHandshakeIteration(String memberName, IHandshakeContext handshakeContext) {
        int maxSize;
        long upToKey;
        if (handshakeContext instanceof MultiStepHandshakeContext) {
            return this.getNextHandshakeIteration(memberName, ((MultiStepHandshakeContext)handshakeContext).getCurrentStep());
        }
        if (handshakeContext instanceof SynchronizeMissingPacketsHandshakeContext) {
            ((SynchronizeMissingPacketsHandshakeContext)handshakeContext).setDone();
            return new SynchronizeMissingPacketsHandshakeIteration();
        }
        ReliableAsyncHandshakeContext typedHandshakeContext = (ReliableAsyncHandshakeContext)handshakeContext;
        ReliableAsyncSourceGroupConfig sourceGroupConfig = (ReliableAsyncSourceGroupConfig)this.getGroupConfigSnapshot();
        long fromKey = typedHandshakeContext.getMinimumUnsentKey();
        List<IReplicationOrderedPacket> packets = this.getPacketsWithFullSerializedContent(fromKey, upToKey = typedHandshakeContext.getLastProcessedKey(), maxSize = sourceGroupConfig.getBacklogCompletionBatchSize());
        long minimumUnsentKey = packets.isEmpty() ? upToKey + 1L : packets.get(packets.size() - 1).getKey() + 1L;
        typedHandshakeContext.setMinimumUnsentKey(minimumUnsentKey);
        if (handshakeContext.isDone()) {
            this._rwLock.writeLock().lock();
            try {
                this._ongoingReliableAsyncHandshakeCompletion.remove(memberName);
                this.clearConfirmedPackets();
            }
            finally {
                this._rwLock.writeLock().unlock();
            }
        }
        return new ReliableAsyncHandshakeIteration(packets);
    }

    @Override
    protected IPacketFilteredHandler getFilteredHandler() {
        return this;
    }

    @Override
    public IReplicationOrderedPacket packetFiltered(IReplicationOrderedPacket beforeFilter, IReplicationOrderedPacket afterFilter, IReplicationGroupBacklog groupBacklog, String targetMemberName) {
        long minimumAsyncTargetsUnconfirmedKey = this.getReliableAsyncState(targetMemberName).getMinimumUnconfirmedKey();
        if (afterFilter.getKey() < minimumAsyncTargetsUnconfirmedKey) {
            return this._defaultFilteredHandler.packetFiltered(beforeFilter, afterFilter, groupBacklog, targetMemberName);
        }
        IMultiBucketSingleFileReplicationOrderedPacket typedBeforeFilter = (IMultiBucketSingleFileReplicationOrderedPacket)beforeFilter;
        IMultiBucketSingleFileReplicationOrderedPacket typedAfterFilter = (IMultiBucketSingleFileReplicationOrderedPacket)afterFilter;
        return new MultiBucketSingleFileReliableAsyncKeptDiscardedPacket(typedBeforeFilter, typedAfterFilter);
    }

    @Override
    public String dumpState() {
        return super.dumpState() + StringUtils.NEW_LINE + "Reliable async state " + this.getEntireReliableAsyncState() + StringUtils.NEW_LINE + "Ongoing Reliable Async Handshake Completion " + this._ongoingReliableAsyncHandshakeCompletion + StringUtils.NEW_LINE + "Insertion sorter " + this._insertionSorter;
    }

    public static class PacketComperator
    implements Comparator<IMultiBucketSingleFileReplicationOrderedPacket> {
        @Override
        public int compare(IMultiBucketSingleFileReplicationOrderedPacket o1, IMultiBucketSingleFileReplicationOrderedPacket o2) {
            return o1.getKey() < o2.getKey() ? -1 : (o1.getKey() == o2.getKey() ? 0 : 1);
        }
    }
}

