/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.AbstractMultiBucketSingleFileGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReliableAsyncState;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReliableAsyncTargetState;
import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

@InternalApi
public class MultiBucketSingleFileReliableAsyncState
implements IReliableAsyncState {
    private static final long serialVersionUID = 1L;
    private AsyncTargetState[] _asyncTargetsState;

    public MultiBucketSingleFileReliableAsyncState() {
    }

    public MultiBucketSingleFileReliableAsyncState(AsyncTargetState[] asyncTargetsState) {
        this._asyncTargetsState = asyncTargetsState;
    }

    public long getMinimumUnconfirmedKey() {
        if (this._asyncTargetsState.length == 0) {
            return Long.MAX_VALUE;
        }
        long minConfirmed = Long.MAX_VALUE;
        for (AsyncTargetState asyncTargetState : this._asyncTargetsState) {
            if (!asyncTargetState.hadAnyHandshake()) {
                return 0L;
            }
            minConfirmed = Math.min(minConfirmed, asyncTargetState.getGlobalLastConfirmedKey());
        }
        return minConfirmed + 1L;
    }

    public long[] getMinimumUnconfirmedBucketKeys() {
        long[] result = null;
        boolean firstIteration = true;
        for (AsyncTargetState asyncTargetState : this._asyncTargetsState) {
            long[] bucketLastConfirmedKeys = asyncTargetState.getBucketLastConfirmedKeys();
            if (result == null) {
                result = new long[bucketLastConfirmedKeys.length];
            }
            for (int i = 0; i < bucketLastConfirmedKeys.length; ++i) {
                long bucketKey = bucketLastConfirmedKeys[i];
                result[i] = firstIteration ? bucketKey + 1L : Math.min(result[i], bucketKey + 1L);
            }
            firstIteration = false;
        }
        return result;
    }

    public AsyncTargetState[] getAsyncTargetsState() {
        return this._asyncTargetsState;
    }

    @Override
    public IReliableAsyncTargetState[] getReliableAsyncTargetsState() {
        return this.getAsyncTargetsState();
    }

    public String toString() {
        return Arrays.toString(this._asyncTargetsState);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject(out, this._asyncTargetsState);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._asyncTargetsState = (AsyncTargetState[])IOUtils.readObject(in);
    }

    public static class AsyncTargetState
    implements Externalizable,
    IReliableAsyncTargetState {
        private static final long serialVersionUID = 1L;
        private String _targetMemberName;
        private long _globalLastConfirmedKey;
        private long[] _bucketLastConfirmedKeys;
        private boolean _hadAnyHandshake;

        public AsyncTargetState() {
        }

        public AsyncTargetState(String targetMemberName, boolean hadAnyHandshake, long globalLastConfirmedKey, long[] bucketLastConfirmedKeys) {
            this._targetMemberName = targetMemberName;
            this._hadAnyHandshake = hadAnyHandshake;
            this._globalLastConfirmedKey = globalLastConfirmedKey;
            this._bucketLastConfirmedKeys = new long[bucketLastConfirmedKeys.length];
            for (int i = 0; i < this._bucketLastConfirmedKeys.length; ++i) {
                this._bucketLastConfirmedKeys[i] = bucketLastConfirmedKeys[i];
            }
        }

        public long getGlobalLastConfirmedKey() {
            return this._globalLastConfirmedKey;
        }

        public long[] getBucketLastConfirmedKeys() {
            return this._bucketLastConfirmedKeys;
        }

        public boolean hadAnyHandshake() {
            return this._hadAnyHandshake;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            IOUtils.writeRepetitiveString(out, this._targetMemberName);
            out.writeBoolean(this._hadAnyHandshake);
            IOUtils.writeObject(out, this._bucketLastConfirmedKeys);
            out.writeLong(this._globalLastConfirmedKey);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this._targetMemberName = IOUtils.readRepetitiveString(in);
            this._hadAnyHandshake = in.readBoolean();
            this._bucketLastConfirmedKeys = (long[])IOUtils.readObject(in);
            this._globalLastConfirmedKey = in.readLong();
        }

        @Override
        public String getTargetMemberName() {
            return this._targetMemberName;
        }

        public String toString() {
            return "AsyncTargetState [targetMemberName=" + this._targetMemberName + ", globalLastConfirmedKey=" + this._globalLastConfirmedKey + ", bucketLastConfirmedKeys=" + AbstractMultiBucketSingleFileGroupBacklog.printBucketsKeys(this._bucketLastConfirmedKeys) + ", hadAnyHandshake=" + this._hadAnyHandshake + "]";
        }
    }
}

