/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeContext;
import com.gigaspaces.internal.utils.StringUtils;

@InternalApi
public class MultiStepHandshakeContext
implements IHandshakeContext {
    private final IHandshakeContext[] _steps;
    private int _index = 0;

    public MultiStepHandshakeContext(IHandshakeContext ... steps) {
        this._steps = steps;
    }

    @Override
    public boolean isDone() {
        if (this._index < this._steps.length) {
            if (this._steps[this._index].isDone()) {
                ++this._index;
            }
            return false;
        }
        return true;
    }

    public IHandshakeContext getCurrentStep() {
        return this._steps[Math.min(this._steps.length - 1, this._index)];
    }

    @Override
    public String toLogMessage() {
        StringBuilder builder = new StringBuilder("Multi step handshake context:");
        builder.append(StringUtils.NEW_LINE);
        for (IHandshakeContext step : this._steps) {
            builder.append(step.toLogMessage());
            builder.append(StringUtils.NEW_LINE);
        }
        return builder.toString();
    }
}

