/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.AbstractMultiBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.BucketKey;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.DiscardedMultiBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.PacketConsumeState;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilterCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.IMultiBucketSingleFileProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.ParallelBatchProcessingContext;
import com.gigaspaces.internal.collections.ShortObjectMap;
import com.gigaspaces.internal.io.IOUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class MultipleBucketOrderedPacket
extends AbstractMultiBucketOrderedPacket {
    private static final long serialVersionUID = 1L;
    private IReplicationPacketData<?> _data;
    private transient short _pendingBucketsCount;
    private transient boolean _consumed;

    public MultipleBucketOrderedPacket() {
    }

    public MultipleBucketOrderedPacket(long globalKey, ShortObjectMap<BucketKey> bucketsKeys, IReplicationPacketData<?> data) {
        super(globalKey, bucketsKeys);
        this._data = data;
        this._pendingBucketsCount = (short)this.getBucketsKeys().size();
    }

    @Override
    public IReplicationPacketData<?> getData() {
        return this._data;
    }

    @Override
    public boolean isDataPacket() {
        return true;
    }

    @Override
    public boolean isDiscardedPacket() {
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeObject(out, this._data);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        IOUtils.writeSwapExternalizableObject(out, this._data);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._pendingBucketsCount = this.bucketCount();
        this._data = (IReplicationPacketData)IOUtils.readObject(in);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this._pendingBucketsCount = this.bucketCount();
        this._data = (IReplicationPacketData)IOUtils.readSwapExternalizableObject(in);
    }

    @Override
    public MultiBucketSingleFileProcessResult process(String sourceLookupName, IMultiBucketSingleFileProcessLog processLog, IReplicationInFilterCallback inFilterCallback, ParallelBatchProcessingContext context, int segmentIndex) {
        return processLog.process(sourceLookupName, this, inFilterCallback, context, segmentIndex);
    }

    @Override
    public MultipleBucketOrderedPacket clone() {
        return new MultipleBucketOrderedPacket(this.getKey(), this.getBucketsKeys(), this._data.clone());
    }

    @Override
    public MultipleBucketOrderedPacket cloneWithNewData(IReplicationPacketData<?> newData) {
        return new MultipleBucketOrderedPacket(this.getKey(), this.getBucketsKeys(), newData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PacketConsumeState getConsumeState(short bucketIndex) {
        if (this._consumed) {
            return PacketConsumeState.CONSUMED;
        }
        BucketKey bucketKey = this.getBucketsKeys().get(bucketIndex);
        boolean alreadyReachedThisBucket = bucketKey.processed;
        bucketKey.processed = true;
        if (!alreadyReachedThisBucket) {
            MultipleBucketOrderedPacket multipleBucketOrderedPacket = this;
            synchronized (multipleBucketOrderedPacket) {
                this._pendingBucketsCount = (short)(this._pendingBucketsCount - 1);
                return this._pendingBucketsCount == 0 ? PacketConsumeState.CAN_CONSUME : PacketConsumeState.PENDING;
            }
        }
        return PacketConsumeState.PENDING;
    }

    @Override
    public boolean setConsumed() {
        this._consumed = true;
        return true;
    }

    @Override
    public AbstractMultiBucketOrderedPacket replaceWithDiscarded() {
        return new DiscardedMultiBucketOrderedPacket(this.getKey(), this.getBucketsKeys());
    }
}

