/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.AbstractSingleBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.DiscardedSingleBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilterCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.IMultiBucketSingleFileProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.ParallelBatchProcessingContext;
import com.gigaspaces.internal.io.IOUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class SingleBucketOrderedPacket
extends AbstractSingleBucketOrderedPacket {
    private static final long serialVersionUID = 1L;
    private IReplicationPacketData<?> _data;

    public SingleBucketOrderedPacket() {
    }

    public SingleBucketOrderedPacket(long globalKey, long bucketKey, short bucketIndex, IReplicationPacketData<?> data) {
        super(globalKey, bucketKey, bucketIndex);
        this._data = data;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeObject(out, this._data);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        IOUtils.writeSwapExternalizableObject(out, this._data);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._data = (IReplicationPacketData)IOUtils.readObject(in);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this._data = (IReplicationPacketData)IOUtils.readSwapExternalizableObject(in);
    }

    @Override
    public IReplicationPacketData<?> getData() {
        return this._data;
    }

    @Override
    public boolean isDataPacket() {
        return true;
    }

    @Override
    public boolean isDiscardedPacket() {
        return false;
    }

    @Override
    public MultiBucketSingleFileProcessResult process(String sourceLookupName, IMultiBucketSingleFileProcessLog processLog, IReplicationInFilterCallback inFilterCallback, ParallelBatchProcessingContext context, int segmentIndex) {
        return processLog.process(sourceLookupName, this, inFilterCallback, context, segmentIndex);
    }

    @Override
    public DiscardedSingleBucketOrderedPacket replaceWithDiscarded() {
        return new DiscardedSingleBucketOrderedPacket(this.getKey(), this.getBucketIndex(), this.getBucketKey());
    }

    @Override
    public SingleBucketOrderedPacket clone() {
        return new SingleBucketOrderedPacket(this.getKey(), this.getBucketKey(), this.getBucketIndex(), this._data.clone());
    }

    @Override
    public SingleBucketOrderedPacket cloneWithNewData(IReplicationPacketData<?> newData) {
        return new SingleBucketOrderedPacket(this.getKey(), this.getBucketKey(), this.getBucketIndex(), newData);
    }

    @Override
    public int getWeight() {
        if (this._data != null) {
            return this._data.getWeight();
        }
        return 1;
    }
}

