/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.multisourcesinglefile;

import com.gigaspaces.cluster.replication.ReplicationException;
import com.gigaspaces.internal.cluster.node.impl.ReplicationMultipleOperationType;
import com.gigaspaces.internal.cluster.node.impl.ReplicationOutContext;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.backlog.AbstractSingleFileGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.CompletedHandshakeContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.EmptyIdleStateData;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.backlog.IIdleStateData;
import com.gigaspaces.internal.cluster.node.impl.backlog.NonExistingBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderConfirmationHolder;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderDeletedBacklogPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderDiscardedReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderOperationPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multisourcesinglefile.MultiSourceSingleFileBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.multisourcesinglefile.MultiSourceSingleFileConfirmationHolder;
import com.gigaspaces.internal.cluster.node.impl.backlog.multisourcesinglefile.MultiSourceSingleFileIdleStateData;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.SourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeContext;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataProducer;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessLogHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderProcessLogHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderProcessResult;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.jini.core.transaction.server.ServerTransaction;

public abstract class AbstractMultiSourceSingleFileGroupBacklog
extends AbstractSingleFileGroupBacklog<IReplicationOrderedPacket, MultiSourceSingleFileConfirmationHolder> {
    public AbstractMultiSourceSingleFileGroupBacklog(DynamicSourceGroupConfigHolder groupConfig, String name, IReplicationPacketDataProducer<?> dataProducer) {
        super(groupConfig, name, dataProducer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiSourceSingleFileBacklogHandshakeRequest getHandshakeRequest(String memberName, Object customBacklogMetadata) {
        this._rwLock.writeLock().lock();
        try {
            GlobalOrderConfirmationHolder confirmationHolder = (GlobalOrderConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
            MultiSourceSingleFileBacklogHandshakeRequest handshakeRequest = new MultiSourceSingleFileBacklogHandshakeRequest(!confirmationHolder.hadAnyHandshake(), confirmationHolder.getLastConfirmedKey());
            MultiSourceSingleFileBacklogHandshakeRequest multiSourceSingleFileBacklogHandshakeRequest = this.getHandshakeRequestImpl(memberName, handshakeRequest);
            return multiSourceSingleFileBacklogHandshakeRequest;
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    protected MultiSourceSingleFileBacklogHandshakeRequest getHandshakeRequestImpl(String memberName, MultiSourceSingleFileBacklogHandshakeRequest handshakeRequest) {
        return handshakeRequest;
    }

    @Override
    protected long getFirstRequiredKeyUnsafe(String memberName) {
        MultiSourceSingleFileConfirmationHolder confirmationHolder = (MultiSourceSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
        if (confirmationHolder.hadAnyHandshake()) {
            return Math.max(confirmationHolder.getLastConfirmedKey(), confirmationHolder.getLastReceivedKey());
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IHandshakeContext processHandshakeResponse(String memberName, IBacklogHandshakeRequest request, IProcessLogHandshakeResponse response, PlatformLogicalVersion targetLogicalVersion, Object customBacklogMetadata) {
        GlobalOrderProcessLogHandshakeResponse typedResponse = (GlobalOrderProcessLogHandshakeResponse)response;
        this._rwLock.writeLock().lock();
        try {
            long lastProcessedKey = typedResponse.getLastProcessedKey();
            MultiSourceSingleFileConfirmationHolder confirmationHolder = (MultiSourceSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
            confirmationHolder.setLastConfirmedKey(lastProcessedKey, memberName, this);
            confirmationHolder.setLastReceivedKey(lastProcessedKey);
            this.clearConfirmedPackets();
            IHandshakeContext iHandshakeContext = this.getHandshakeContext(memberName, request, targetLogicalVersion, typedResponse, lastProcessedKey);
            return iHandshakeContext;
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    protected IHandshakeContext getHandshakeContext(String memberName, IBacklogHandshakeRequest request, PlatformLogicalVersion targetLogicalVersion, GlobalOrderProcessLogHandshakeResponse typedResponse, long lastProcessedKey) {
        return new CompletedHandshakeContext();
    }

    private void updateLastConfirmedKeyUnsafe(String memberName, long key) {
        MultiSourceSingleFileConfirmationHolder confirmationHolder = (MultiSourceSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
        confirmationHolder.setLastConfirmedKey(key, memberName, this);
        confirmationHolder.setLastReceivedKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBacklogMemberState getState(String memberName) {
        this._rwLock.readLock().lock();
        try {
            GlobalOrderConfirmationHolder confirmationHolder = (GlobalOrderConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
            if (confirmationHolder == null) {
                NonExistingBacklogMemberState nonExistingBacklogMemberState = NonExistingBacklogMemberState.INSTANCE;
                return nonExistingBacklogMemberState;
            }
            long lastConfirmedKey = confirmationHolder.getLastConfirmedKey();
            boolean hasAnyHandshake = confirmationHolder.hadAnyHandshake();
            Throwable pendingError = confirmationHolder.hasPendingError() ? confirmationHolder.getPendingError() : null;
            boolean backlogDropped = this._outOfSyncDueToDeletionTargets.contains(memberName);
            GlobalOrderBacklogMemberState globalOrderBacklogMemberState = new GlobalOrderBacklogMemberState(memberName, hasAnyHandshake, lastConfirmedKey, backlogDropped, pendingError);
            return globalOrderBacklogMemberState;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResult(String memberName, IProcessResult result, List<IReplicationOrderedPacket> packets) throws ReplicationException {
        GlobalOrderProcessResult typedResult = (GlobalOrderProcessResult)result;
        this._rwLock.writeLock().lock();
        try {
            if (typedResult.isProcessed()) {
                IReplicationOrderedPacket lastPacket = packets.get(packets.size() - 1);
                this.confirmedKey(memberName, lastPacket.getEndKey(), true);
            } else if (typedResult.getError() == null) {
                MultiSourceSingleFileConfirmationHolder confirmationHolder = (MultiSourceSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
                IReplicationOrderedPacket lastPacket = packets.get(packets.size() - 1);
                this.confirmedKey(memberName, typedResult.getLastProcessedKey(), lastPacket.getEndKey(), confirmationHolder, true);
            } else {
                this.handlePendingErrorBatchPackets(memberName, packets, typedResult.getError(), typedResult.getLastProcessedKey() + 1L);
                this.handleErrorResult(memberName, typedResult);
            }
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    private void confirmedKey(String memberName, long packetKey, boolean setLastReceivedKey) {
        MultiSourceSingleFileConfirmationHolder confirmationHolder = (MultiSourceSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
        this.confirmedKey(memberName, packetKey, packetKey, confirmationHolder, setLastReceivedKey);
    }

    private void confirmedKey(String memberName, long lastConfirmedKey, long lastReceivedKey, MultiSourceSingleFileConfirmationHolder confirmationHolder, boolean setLastReceivedKey) {
        boolean lastConfirmedKeyUpdated = false;
        if (confirmationHolder.hadAnyHandshake()) {
            if (lastConfirmedKey > confirmationHolder.getLastConfirmedKey()) {
                lastConfirmedKeyUpdated = true;
                confirmationHolder.setLastConfirmedKey(lastConfirmedKey, memberName, this);
            }
            if (setLastReceivedKey && lastReceivedKey > confirmationHolder.getLastReceivedKey()) {
                confirmationHolder.setLastReceivedKey(lastReceivedKey);
            }
        } else {
            lastConfirmedKeyUpdated = true;
            confirmationHolder.setLastConfirmedKey(lastConfirmedKey, memberName, this);
            if (setLastReceivedKey) {
                confirmationHolder.setLastReceivedKey(lastReceivedKey);
            }
        }
        if (lastConfirmedKeyUpdated) {
            this.cleanPendingErrorStateIfNeeded(memberName, lastConfirmedKey, confirmationHolder);
            this.clearConfirmedPackets();
        }
    }

    private void handleErrorResult(String memberName, GlobalOrderProcessResult result) throws ReplicationException {
        Throwable error = result.getError();
        long lastProcessedKey = result.getLastProcessedKey();
        this.handleErrorResult(memberName, error, lastProcessedKey);
    }

    private void handleErrorResult(String memberName, Throwable error, long lastProcessedKey) throws ReplicationException {
        GlobalOrderConfirmationHolder confirmationHolder;
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.finer(this.getLogPrefix() + "handling error result in backlog - " + error);
        }
        if (!(confirmationHolder = (GlobalOrderConfirmationHolder)this.getConfirmationHolderUnsafe(memberName)).hadAnyHandshake() || confirmationHolder.getLastConfirmedKey() <= lastProcessedKey) {
            this.updateLastConfirmedKeyUnsafe(memberName, lastProcessedKey);
            this.clearConfirmedPackets();
        }
        throw new ReplicationException(error.getMessage(), error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResult(String memberName, IProcessResult result, IReplicationOrderedPacket packet) throws ReplicationException {
        GlobalOrderProcessResult typedResult = (GlobalOrderProcessResult)result;
        this._rwLock.writeLock().lock();
        try {
            if (typedResult.isProcessed()) {
                this.confirmedKey(memberName, packet.getEndKey(), true);
            } else {
                this.handlePendingErrorSinglePacket(memberName, packet, typedResult.getError());
                this.handleErrorResult(memberName, typedResult);
            }
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    @Override
    public IReplicationOrderedPacket replaceWithDiscarded(IReplicationOrderedPacket packet, boolean forceDiscard) {
        if (forceDiscard || !packet.getData().isMultiParticipantData()) {
            return new GlobalOrderDiscardedReplicationPacket(packet.getKey());
        }
        return packet;
    }

    @Override
    public boolean mergeWithDiscarded(IReplicationOrderedPacket previousDiscardedPacket, IReplicationOrderedPacket mergedPacket, String memberName) {
        return false;
    }

    @Override
    public boolean supportDiscardMerge() {
        return true;
    }

    @Override
    public String dumpState() {
        this._rwLock.readLock().lock();
        try {
            StringBuilder dump = new StringBuilder("Type [" + this.getClass().getName() + "]");
            dump.append(StringUtils.NEW_LINE);
            dump.append("Backlog statistics {" + this.getStatistics() + "}");
            this.appendConfirmationStateString(dump);
            String string = dump.toString();
            return string;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    @Override
    public IProcessResult fromWireForm(Object wiredProcessResult) {
        if (wiredProcessResult == null) {
            return GlobalOrderProcessResult.OK;
        }
        return (IProcessResult)wiredProcessResult;
    }

    @Override
    protected Map<String, MultiSourceSingleFileConfirmationHolder> createConfirmationMap(SourceGroupConfig groupConfig) {
        HashMap<String, MultiSourceSingleFileConfirmationHolder> confirmationMap = new HashMap<String, MultiSourceSingleFileConfirmationHolder>();
        String[] membersLookupNames = groupConfig.getMembersLookupNames();
        for (int i = 0; i < membersLookupNames.length; ++i) {
            confirmationMap.put(membersLookupNames[i], new MultiSourceSingleFileConfirmationHolder());
        }
        return confirmationMap;
    }

    @Override
    protected MultiSourceSingleFileConfirmationHolder createNewConfirmationHolder() {
        MultiSourceSingleFileConfirmationHolder confirmationHolder = new MultiSourceSingleFileConfirmationHolder();
        long lastKeyPresentInBacklog = this.getNextKeyUnsafe() - 1L;
        confirmationHolder.setLastConfirmedKey(lastKeyPresentInBacklog, 0L);
        confirmationHolder.setLastReceivedKey(lastKeyPresentInBacklog);
        return confirmationHolder;
    }

    @Override
    protected void deleteBatchFromBacklog(long deletionBatchSize) {
        this.decreaseWeightToAllMembersFromOldestPacket(this.getFirstKeyInBacklogInternal() + deletionBatchSize - 1L);
        this.getBacklogFile().deleteOldestPackets(deletionBatchSize);
    }

    @Override
    protected long getLastConfirmedKeyUnsafe(String memberLookupName) {
        GlobalOrderConfirmationHolder confirmationHolder = (GlobalOrderConfirmationHolder)this.getConfirmationHolderUnsafe(memberLookupName);
        return confirmationHolder.hadAnyHandshake() ? confirmationHolder.getLastConfirmedKey() : -1L;
    }

    @Override
    protected void onBeginSynchronization(String memberName) {
        long key = this.getNextKeyUnsafe() - 1L;
        this.updateLastConfirmedKeyUnsafe(memberName, key);
    }

    @Override
    protected IReplicationOrderedPacket createBacklogOverflowPacket(long globalLastConfirmedKey, long firstKeyInBacklog, String memberName) {
        return new GlobalOrderDeletedBacklogPacket(globalLastConfirmedKey + 1L, firstKeyInBacklog - 1L);
    }

    @Override
    protected long getMemberUnconfirmedKey(MultiSourceSingleFileConfirmationHolder value) {
        return value.hadAnyHandshake() ? value.getLastConfirmedKey() : -1L;
    }

    protected IReplicationOrderedPacket addSingleOperationPacket(IReplicationGroupOutContext groupContext, IEntryHolder entryHolder, ReplicationSingleOperationType operationType) {
        ReplicationOutContext outContext = groupContext.getEntireContext();
        Object data = this.getDataProducer().createSingleOperationData(entryHolder, operationType, outContext);
        GlobalOrderOperationPacket packet = this.insertPacketToBacklog((IReplicationPacketData<?>)data, outContext);
        return packet;
    }

    private GlobalOrderOperationPacket insertPacketToBacklog(IReplicationPacketData<?> data, ReplicationOutContext outContext) {
        this._rwLock.writeLock().lock();
        try {
            this.setPacketWeight(data);
            if (!this.shouldInsertPacket(data)) {
                GlobalOrderOperationPacket globalOrderOperationPacket = null;
                return globalOrderOperationPacket;
            }
            GlobalOrderOperationPacket packet = new GlobalOrderOperationPacket(this.takeNextKeyUnsafe(outContext), data);
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.finest(this.getLogPrefix() + "inserting packet [" + packet + "] to backlog");
            }
            this.insertReplicationOrderedPacketToBacklog(packet, outContext);
            GlobalOrderOperationPacket globalOrderOperationPacket = packet;
            return globalOrderOperationPacket;
        }
        catch (RuntimeException e) {
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, "exception while inserting a packet to the backlog file (insertPacketToBacklog), [" + this.getStatistics() + "]", e);
            }
            this.validateIntegrity();
            throw e;
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    protected IReplicationOrderedPacket addGenericOperationPacket(IReplicationGroupOutContext groupContext, Object operationData, ReplicationSingleOperationType operationType) {
        ReplicationOutContext outContext = groupContext.getEntireContext();
        Object data = this.getDataProducer().createGenericOperationData(operationData, operationType, outContext);
        GlobalOrderOperationPacket packet = this.insertPacketToBacklog((IReplicationPacketData<?>)data, outContext);
        return packet;
    }

    protected IReplicationOrderedPacket addTransactionOperationPacket(IReplicationGroupOutContext groupContext, ServerTransaction transaction, ArrayList<IEntryHolder> lockedEntries, ReplicationMultipleOperationType operationType) {
        ReplicationOutContext outContext = groupContext.getEntireContext();
        Object data = this.getDataProducer().createTransactionOperationData(transaction, lockedEntries, outContext, operationType);
        if (data.isEmpty() && !data.isMultiParticipantData()) {
            return null;
        }
        GlobalOrderOperationPacket packet = this.insertPacketToBacklog((IReplicationPacketData<?>)data, outContext);
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IIdleStateData getIdleStateData(String memberName, PlatformLogicalVersion targetMemberVersion) {
        this._rwLock.readLock().lock();
        try {
            MultiSourceSingleFileConfirmationHolder confirmationHolder = (MultiSourceSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(memberName);
            if (confirmationHolder.getLastReceivedKey() <= confirmationHolder.getLastConfirmedKey()) {
                IIdleStateData iIdleStateData = EmptyIdleStateData.INSTANCE;
                return iIdleStateData;
            }
            MultiSourceSingleFileIdleStateData multiSourceSingleFileIdleStateData = new MultiSourceSingleFileIdleStateData(confirmationHolder.getLastConfirmedKey(), confirmationHolder.getLastReceivedKey());
            return multiSourceSingleFileIdleStateData;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processIdleStateDataResult(String memberName, IProcessResult result, IIdleStateData idleStateData) throws ReplicationException {
        GlobalOrderProcessResult typedResult = (GlobalOrderProcessResult)result;
        MultiSourceSingleFileIdleStateData typedIdleStateData = (MultiSourceSingleFileIdleStateData)idleStateData;
        this._rwLock.writeLock().lock();
        try {
            if (typedResult.isProcessed()) {
                this.confirmedKey(memberName, typedIdleStateData.getLastReceivedKey(), false);
            } else if (typedResult.getError() == null) {
                this.confirmedKey(memberName, typedResult.getLastProcessedKey(), false);
            } else {
                this.handlePendingErrorBatchPackets(memberName, this.getSpecificPackets(typedIdleStateData.getLastConfirmedKey() + 1L, typedIdleStateData.getLastReceivedKey()), typedResult.getError(), typedResult.getLastProcessedKey() + 1L);
                this.handleErrorResult(memberName, typedResult);
            }
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPendingError(String memberName, Throwable error, IIdleStateData idleStateData) {
        this._rwLock.writeLock().lock();
        try {
            MultiSourceSingleFileIdleStateData typedIdleStateData = (MultiSourceSingleFileIdleStateData)idleStateData;
            List<IReplicationOrderedPacket> packets = this.getSpecificPackets(typedIdleStateData.getLastConfirmedKey() + 1L, typedIdleStateData.getLastReceivedKey());
            this.handlePendingErrorBatchPackets(memberName, packets, error, typedIdleStateData.getLastConfirmedKey() + 1L);
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getConfirmed(String memberName) {
        this._rwLock.readLock().lock();
        try {
            long l = this.getLastConfirmedKeyUnsafe(memberName);
            return l;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }
}

