/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.multisourcesinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.ReplicationMultipleOperationType;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.backlog.CompletedHandshakeContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.NoSuchReplicationMemberException;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderConfirmationHolder;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderDeletedBacklogPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderDiscardedReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderReliableAsyncKeptDiscardedOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.IPacketFilteredHandler;
import com.gigaspaces.internal.cluster.node.impl.backlog.multisourcesinglefile.AbstractMultiSourceSingleFileGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.multisourcesinglefile.MultiSourceSingleFileBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.multisourcesinglefile.MultiSourceSingleFileConfirmationHolder;
import com.gigaspaces.internal.cluster.node.impl.backlog.multisourcesinglefile.MultiSourceSingleFileReliableAsyncBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.multisourcesinglefile.MultiSourceSingleFileReliableAsyncState;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReliableAsyncState;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReplicationReliableAsyncGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.MissingReliableAsyncTargetStateException;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.ReliableAsyncHandshakeContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.ReliableAsyncHandshakeIteration;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.SynchronizeMissingPacketsHandshakeContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.SynchronizeMissingPacketsHandshakeIteration;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeContext;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeIteration;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncSourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataProducer;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessLogHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderProcessLogHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderReliableAsyncKeeperProcessLogHandshakeResponse;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.j_spaces.core.exception.internal.ReplicationInternalSpaceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class MultiSourceSingleFileReliableAsyncGroupBacklog
extends AbstractMultiSourceSingleFileGroupBacklog
implements IReplicationReliableAsyncGroupBacklog,
IPacketFilteredHandler {
    protected final Map<String, Long> _ongoingReliableAsyncHandshakeCompletion = new HashMap<String, Long>();

    public MultiSourceSingleFileReliableAsyncGroupBacklog(DynamicSourceGroupConfigHolder groupConfig, String name, IReplicationPacketDataProducer<?> dataProducer) {
        super(groupConfig, name, dataProducer);
    }

    @Override
    public void add(ReliableAsyncReplicationGroupOutContext groupContext, IEntryHolder entryHolder, ReplicationSingleOperationType operationType) {
        if (!this.hasExistingMember()) {
            return;
        }
        IReplicationOrderedPacket packet = this.addSingleOperationPacket(groupContext, entryHolder, operationType);
        if (packet != null) {
            groupContext.addOrderedPacket(packet);
        }
    }

    @Override
    public void addGeneric(ReliableAsyncReplicationGroupOutContext groupContext, Object operationData, ReplicationSingleOperationType operationType) {
        if (!this.hasExistingMember()) {
            return;
        }
        IReplicationOrderedPacket packet = this.addGenericOperationPacket(groupContext, operationData, operationType);
        if (packet != null) {
            groupContext.addOrderedPacket(packet);
        }
    }

    @Override
    public void addTransaction(ReliableAsyncReplicationGroupOutContext groupContext, ServerTransaction transaction, ArrayList<IEntryHolder> lockedEntries, ReplicationMultipleOperationType operationType) {
        if (!this.hasExistingMember()) {
            return;
        }
        IReplicationOrderedPacket packet = this.addTransactionOperationPacket(groupContext, transaction, lockedEntries, operationType);
        if (packet != null) {
            groupContext.addOrderedPacket(packet);
        }
    }

    @Override
    public void reliableAsyncSourceAdd(String sourceMemberName, IReplicationOrderedPacket packet) {
        this.insertReliableAsyncAddedPacket(sourceMemberName, packet, false);
    }

    @Override
    public void reliableAsyncSourceKeep(String sourceMemberName, IReplicationOrderedPacket packet) {
        this.insertReliableAsyncAddedPacket(sourceMemberName, packet, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertReliableAsyncAddedPacket(String sourceMemberName, IReplicationOrderedPacket packet, boolean allowOlderPackets) {
        ReliableAsyncSourceGroupConfig groupConfig = (ReliableAsyncSourceGroupConfig)this.getGroupConfigSnapshot();
        if (groupConfig.getAsyncMembersLookupNames().length == 0 && groupConfig.getSyncMembersLookupNames().length <= 1) {
            return;
        }
        this._rwLock.writeLock().lock();
        try {
            IReplicationOrderedPacket lastPacketInBacklog;
            this.ensureLimit(packet.getData());
            if (packet.getEndKey() <= this.getLastInsertedKeyToBacklogUnsafe() && !this.getBacklogFile().isEmpty() && (lastPacketInBacklog = (IReplicationOrderedPacket)this.getBacklogFile().readOnlyIterator(this.getBacklogFile().size() - 1L).next()).getEndKey() != packet.getKey() - 1L) {
                throw new ReplicationInternalSpaceException("replication is out of sync, attempt to keep a reliable async packet in a keeper backlog with non strict ascending order, new packet key is [" + packet.getEndKey() + "] while the last existing packet key in the backlog is [" + lastPacketInBacklog.getEndKey() + "]");
            }
            if (packet instanceof GlobalOrderDeletedBacklogPacket) {
                this.setNextKeyUnsafe(((GlobalOrderDeletedBacklogPacket)packet).getEndKey() + 1L);
            } else {
                this.setNextKeyUnsafe(packet.getKey() + 1L);
            }
            this.getBacklogFile().add(packet);
            this.increaseAllMembersWeight(packet.getWeight(), packet.getKey());
            MultiSourceSingleFileConfirmationHolder confirmationHolder = (MultiSourceSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(sourceMemberName);
            confirmationHolder.setLastConfirmedKey(packet.getKey(), sourceMemberName, this);
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    @Override
    public MultiSourceSingleFileReliableAsyncState getEntireReliableAsyncState() {
        Set<Map.Entry<String, MultiSourceSingleFileConfirmationHolder>> asyncTargetsConfirmations = this.getAllConfirmations();
        return this.buildReliableAsyncState(asyncTargetsConfirmations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateReliableAsyncState(IReliableAsyncState reliableAsyncState, String sourceMemberName) throws NoSuchReplicationMemberException, MissingReliableAsyncTargetStateException {
        MultiSourceSingleFileReliableAsyncState sharedAsyncState = (MultiSourceSingleFileReliableAsyncState)reliableAsyncState;
        this._rwLock.writeLock().lock();
        try {
            MultiSourceSingleFileConfirmationHolder lastConfirmedBySource;
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.finest(this.getLogPrefix() + "incoming reliable async state update " + Arrays.toString(sharedAsyncState.getAsyncTargetsState()));
            }
            ReliableAsyncSourceGroupConfig sourceGroupConfig = (ReliableAsyncSourceGroupConfig)this.getGroupConfigSnapshot();
            this.validateReliableAsyncUpdateTargetsMatch(reliableAsyncState, sourceMemberName);
            for (MultiSourceSingleFileReliableAsyncState.MultiSourceAsyncTargetState asyncTargetState : sharedAsyncState.getAsyncTargetsState()) {
                if (!asyncTargetState.hadAnyHandshake()) continue;
                long lastConfirmedKey = asyncTargetState.getLastConfirmedKey();
                long lastReceivedKey = asyncTargetState.getLastReceivedKey();
                String targetMemberName = asyncTargetState.getTargetMemberName();
                MultiSourceSingleFileConfirmationHolder confirmationHolder = (MultiSourceSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(targetMemberName);
                confirmationHolder.setLastConfirmedKey(lastConfirmedKey, targetMemberName, this);
                confirmationHolder.setLastReceivedKey(lastReceivedKey);
            }
            long minConfirmed = this.getNextKeyUnsafe() - 1L;
            if (sharedAsyncState.getAsyncTargetsState().length > 0) {
                minConfirmed = sharedAsyncState.getMinimumUnconfirmedKey() - 1L;
                if (this.getNextKeyUnsafe() < minConfirmed + 1L) {
                    this.setNextKeyUnsafe(minConfirmed + 1L);
                }
            }
            if (!(lastConfirmedBySource = (MultiSourceSingleFileConfirmationHolder)this.getConfirmationHolderUnsafe(sourceMemberName)).hadAnyHandshake() || lastConfirmedBySource.getLastConfirmedKey() < minConfirmed) {
                lastConfirmedBySource.setLastConfirmedKey(minConfirmed, sourceMemberName, this);
            }
            this.clearConfirmedPackets();
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IReplicationOrderedPacket> getReliableAsyncPackets(String memberName, int maxSize, IReplicationReliableAsyncGroupBacklog.KeeperMemberState[] keeperMembersState, IReplicationChannelDataFilter dataFilter, PlatformLogicalVersion targetMemberVersion, Logger logger) {
        this._rwLock.readLock().lock();
        try {
            long minConfirmedKey = Long.MAX_VALUE;
            for (IReplicationReliableAsyncGroupBacklog.KeeperMemberState keeperMemberState : keeperMembersState) {
                if (!keeperMemberState.cannotBypass) continue;
                GlobalOrderConfirmationHolder confirmationHolder = (GlobalOrderConfirmationHolder)this.getConfirmationHolderUnsafe(keeperMemberState.memberName);
                if (!confirmationHolder.hadAnyHandshake()) {
                    minConfirmedKey = -1L;
                    break;
                }
                long lastConfirmedKey = confirmationHolder.getLastConfirmedKey();
                minConfirmedKey = Math.min(minConfirmedKey, lastConfirmedKey);
            }
            if (minConfirmedKey == -1L) {
                LinkedList<IReplicationOrderedPacket> linkedList = new LinkedList<IReplicationOrderedPacket>();
                return linkedList;
            }
            List<IReplicationOrderedPacket> list = this.getPacketsUnsafe(memberName, maxSize, minConfirmedKey, dataFilter, this._defaultFilteredHandler, targetMemberVersion, logger);
            return list;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterHandshake(IProcessLogHandshakeResponse handshakeResponse) {
        GlobalOrderProcessLogHandshakeResponse typedResponse = (GlobalOrderProcessLogHandshakeResponse)handshakeResponse;
        this._rwLock.writeLock().lock();
        try {
            long newNextKey = typedResponse.getLastProcessedKey() + 1L;
            if (this.getNextKeyUnsafe() <= newNextKey) {
                if (this._logger.isLoggable(Level.FINER)) {
                    this._logger.finer(this.getLogPrefix() + " adjusting group key [" + newNextKey + "]");
                }
                this.setNextKeyUnsafe(newNextKey);
            } else if (this._logger.isLoggable(Level.FINER)) {
                this._logger.finer(this.getLogPrefix() + " received next key [" + newNextKey + "] is older than the existing one [" + this.getNextKeyUnsafe() + "], skipping local group adjustment group key");
            }
            if (typedResponse instanceof GlobalOrderReliableAsyncKeeperProcessLogHandshakeResponse) {
                long lastKeyInBacklog = this.getBacklogFile().isEmpty() ? -1L : this.getLastInsertedKeyToBacklogUnsafe();
                ((GlobalOrderReliableAsyncKeeperProcessLogHandshakeResponse)typedResponse).setLastKeyInBacklog(lastKeyInBacklog);
            }
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    @Override
    public String dumpState() {
        return super.dumpState() + StringUtils.NEW_LINE + "Reliable async state " + this.getEntireReliableAsyncState() + StringUtils.NEW_LINE + "Ongoing Reliable Async Handshake Completion " + this._ongoingReliableAsyncHandshakeCompletion;
    }

    @Override
    protected MultiSourceSingleFileBacklogHandshakeRequest getHandshakeRequestImpl(String memberName, MultiSourceSingleFileBacklogHandshakeRequest handshakeRequest) {
        if (this.isAsyncKeeper(memberName)) {
            MultiSourceSingleFileReliableAsyncState reliableAsyncState = this.getReliableAsyncState(memberName);
            this._ongoingReliableAsyncHandshakeCompletion.put(memberName, reliableAsyncState.getMinimumUnconfirmedKey());
            return new MultiSourceSingleFileReliableAsyncBacklogHandshakeRequest(handshakeRequest, reliableAsyncState);
        }
        return handshakeRequest;
    }

    @Override
    protected IHandshakeContext getHandshakeContext(String memberName, IBacklogHandshakeRequest request, PlatformLogicalVersion targetLogicalVersion, GlobalOrderProcessLogHandshakeResponse typedResponse, long lastProcessedKey) {
        if (!this.isAsyncKeeper(memberName)) {
            return new CompletedHandshakeContext();
        }
        MultiSourceSingleFileReliableAsyncBacklogHandshakeRequest typedRequest = (MultiSourceSingleFileReliableAsyncBacklogHandshakeRequest)request;
        MultiSourceSingleFileReliableAsyncState reliableAsyncState = typedRequest.getReliableAsyncState();
        long minimumUnconfirmedKey = -1L;
        long lastInsertedPacketToBacklog = this.getLastInsertedKeyToBacklogUnsafe();
        if (lastInsertedPacketToBacklog < lastProcessedKey) {
            this._ongoingReliableAsyncHandshakeCompletion.remove(memberName);
            return new SynchronizeMissingPacketsHandshakeContext(lastInsertedPacketToBacklog, lastProcessedKey);
        }
        minimumUnconfirmedKey = ((GlobalOrderReliableAsyncKeeperProcessLogHandshakeResponse)typedResponse).getLastKeyInBacklog() + 1L;
        if (lastProcessedKey < (minimumUnconfirmedKey = Math.max(minimumUnconfirmedKey, reliableAsyncState.getMinimumUnconfirmedKey()))) {
            this._ongoingReliableAsyncHandshakeCompletion.remove(memberName);
            return new CompletedHandshakeContext();
        }
        return new ReliableAsyncHandshakeContext(minimumUnconfirmedKey, lastProcessedKey);
    }

    private boolean isAsyncKeeper(String memberName) {
        ReliableAsyncSourceGroupConfig sourceGroupConfig = (ReliableAsyncSourceGroupConfig)this.getGroupConfigSnapshot();
        for (String syncMember : sourceGroupConfig.getSyncMembersLookupNames()) {
            if (!syncMember.equals(memberName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MultiSourceSingleFileReliableAsyncState getReliableAsyncState(String targetMemberLookupName) {
        Set<Map.Entry<String, MultiSourceSingleFileConfirmationHolder>> asyncTargetsConfirmations = this.getAllConfirmations(targetMemberLookupName);
        return this.buildReliableAsyncState(asyncTargetsConfirmations);
    }

    protected MultiSourceSingleFileReliableAsyncState buildReliableAsyncState(Set<Map.Entry<String, MultiSourceSingleFileConfirmationHolder>> asyncTargetsConfirmations) {
        MultiSourceSingleFileReliableAsyncState.MultiSourceAsyncTargetState[] asyncTargetStates = new MultiSourceSingleFileReliableAsyncState.MultiSourceAsyncTargetState[asyncTargetsConfirmations.size()];
        int index = 0;
        for (Map.Entry<String, MultiSourceSingleFileConfirmationHolder> entry : asyncTargetsConfirmations) {
            asyncTargetStates[index++] = new MultiSourceSingleFileReliableAsyncState.MultiSourceAsyncTargetState(entry.getKey(), entry.getValue());
        }
        return new MultiSourceSingleFileReliableAsyncState(asyncTargetStates);
    }

    @Override
    public IReplicationOrderedPacket packetFiltered(IReplicationOrderedPacket beforeFilter, IReplicationOrderedPacket afterFilter, IReplicationGroupBacklog groupBacklog, String targetMemberName) {
        long minimumAsyncTargetsUnconfirmedKey = this.getReliableAsyncState(targetMemberName).getMinimumUnconfirmedKey();
        if (afterFilter.getKey() < minimumAsyncTargetsUnconfirmedKey) {
            return this._defaultFilteredHandler.packetFiltered(beforeFilter, afterFilter, groupBacklog, targetMemberName);
        }
        return new GlobalOrderReliableAsyncKeptDiscardedOrderedPacket(beforeFilter, afterFilter);
    }

    @Override
    protected IPacketFilteredHandler getFilteredHandler() {
        return this;
    }

    @Override
    public IHandshakeIteration getNextHandshakeIteration(String memberName, IHandshakeContext handshakeContext) {
        if (handshakeContext instanceof SynchronizeMissingPacketsHandshakeContext) {
            ((SynchronizeMissingPacketsHandshakeContext)handshakeContext).setDone();
            return new SynchronizeMissingPacketsHandshakeIteration();
        }
        return this.handleReliableAsyncBacklogCompletionIterativeHandshake(memberName, (ReliableAsyncHandshakeContext)handshakeContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHandshakeIteration handleReliableAsyncBacklogCompletionIterativeHandshake(String memberName, ReliableAsyncHandshakeContext handshakeContext) {
        int maxSize;
        long upToKey;
        ReliableAsyncSourceGroupConfig sourceGroupConfig = (ReliableAsyncSourceGroupConfig)this.getGroupConfigSnapshot();
        long fromKey = handshakeContext.getMinimumUnsentKey();
        List<IReplicationOrderedPacket> packets = this.getPacketsWithFullSerializedContent(fromKey, upToKey = handshakeContext.getLastProcessedKey(), maxSize = sourceGroupConfig.getBacklogCompletionBatchSize());
        long minimumUnsentKey = packets.isEmpty() ? upToKey + 1L : packets.get(packets.size() - 1).getKey() + 1L;
        handshakeContext.setMinimumUnsentKey(minimumUnsentKey);
        if (handshakeContext.isDone()) {
            this._rwLock.writeLock().lock();
            try {
                this._ongoingReliableAsyncHandshakeCompletion.remove(memberName);
                this.clearConfirmedPackets();
            }
            finally {
                this._rwLock.writeLock().unlock();
            }
        }
        return new ReliableAsyncHandshakeIteration(packets);
    }

    @Override
    protected long getMinimumUnconfirmedKeyUnsafe() {
        long minimumUnconfirmedKey = super.getMinimumUnconfirmedKeyUnsafe();
        if (minimumUnconfirmedKey == -1L) {
            return minimumUnconfirmedKey;
        }
        for (Long minKey : this._ongoingReliableAsyncHandshakeCompletion.values()) {
            minimumUnconfirmedKey = Math.min(minimumUnconfirmedKey, minKey);
        }
        return minimumUnconfirmedKey;
    }

    @Override
    protected long getInitialMaxAllowedDeleteUpTo() {
        long minimumUnconfirmedKey = super.getInitialMaxAllowedDeleteUpTo();
        for (Long minKey : this._ongoingReliableAsyncHandshakeCompletion.values()) {
            minimumUnconfirmedKey = Math.min(minimumUnconfirmedKey, minKey);
        }
        return minimumUnconfirmedKey;
    }

    @Override
    public boolean mergeWithDiscarded(IReplicationOrderedPacket previousDiscardedPacket, IReplicationOrderedPacket mergedPacket, String memberName) {
        ReliableAsyncSourceGroupConfig reliableAsyncGroupconfig;
        if (previousDiscardedPacket instanceof GlobalOrderDiscardedReplicationPacket && (reliableAsyncGroupconfig = (ReliableAsyncSourceGroupConfig)this.getGroupConfigSnapshot()).getChannelConfig(memberName) != null && !mergedPacket.getData().isMultiParticipantData()) {
            GlobalOrderDiscardedReplicationPacket typedDiscardedPacket = (GlobalOrderDiscardedReplicationPacket)previousDiscardedPacket;
            typedDiscardedPacket.setEndKey(mergedPacket.getKey());
            return true;
        }
        return false;
    }
}

