/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.multisourcesinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.multisourcesinglefile.MultiSourceSingleFileConfirmationHolder;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReliableAsyncState;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReliableAsyncTargetState;
import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class MultiSourceSingleFileReliableAsyncState
implements IReliableAsyncState {
    private static final long serialVersionUID = 1L;
    private MultiSourceAsyncTargetState[] _asyncTargetsState;

    public MultiSourceSingleFileReliableAsyncState() {
    }

    public MultiSourceSingleFileReliableAsyncState(MultiSourceAsyncTargetState[] asyncTargetState) {
        this._asyncTargetsState = asyncTargetState;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject(out, this._asyncTargetsState);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._asyncTargetsState = (MultiSourceAsyncTargetState[])IOUtils.readObject(in);
    }

    public MultiSourceAsyncTargetState[] getAsyncTargetsState() {
        return this._asyncTargetsState;
    }

    @Override
    public IReliableAsyncTargetState[] getReliableAsyncTargetsState() {
        return this.getAsyncTargetsState();
    }

    public long getMinimumUnconfirmedKey() {
        if (this._asyncTargetsState.length == 0) {
            return Long.MAX_VALUE;
        }
        long minConfirmed = Long.MAX_VALUE;
        for (MultiSourceAsyncTargetState asyncTargetState : this._asyncTargetsState) {
            if (!asyncTargetState.hadAnyHandshake()) {
                return 0L;
            }
            minConfirmed = Math.min(minConfirmed, asyncTargetState.getLastConfirmedKey());
        }
        return minConfirmed + 1L;
    }

    public static class MultiSourceAsyncTargetState
    implements Externalizable,
    IReliableAsyncTargetState {
        private static final long serialVersionUID = 1L;
        private String _targetMemberName;
        private long _lastConfirmedKey = -1L;
        private long _lastReceivedKey = -1L;
        private boolean _hadAnyHandshake = false;

        public MultiSourceAsyncTargetState() {
        }

        public MultiSourceAsyncTargetState(String targetMemberName, MultiSourceSingleFileConfirmationHolder confirmationHolder) {
            this._targetMemberName = targetMemberName;
            this._lastConfirmedKey = confirmationHolder.getLastConfirmedKey();
            this._lastReceivedKey = confirmationHolder.getLastReceivedKey();
            this._hadAnyHandshake = confirmationHolder.hadAnyHandshake();
        }

        public long getLastConfirmedKey() {
            return this._lastConfirmedKey;
        }

        public long getLastReceivedKey() {
            return this._lastReceivedKey;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            IOUtils.writeRepetitiveString(out, this._targetMemberName);
            out.writeLong(this._lastConfirmedKey);
            out.writeLong(this._lastReceivedKey);
            out.writeBoolean(this._hadAnyHandshake);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this._targetMemberName = IOUtils.readRepetitiveString(in);
            this._lastConfirmedKey = in.readLong();
            this._lastReceivedKey = in.readLong();
            this._hadAnyHandshake = in.readBoolean();
        }

        public boolean hadAnyHandshake() {
            return this._hadAnyHandshake;
        }

        @Override
        public String getTargetMemberName() {
            return this._targetMemberName;
        }

        public String toString() {
            return "MultiSourceAsyncTargetState [targetMemberName=" + this._targetMemberName + ", lastConfirmedKey=" + this._lastConfirmedKey + ", lastReceivedKey=" + this._lastReceivedKey + ", hadAnyHandshake=" + this._hadAnyHandshake + "]";
        }
    }
}

