/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeContext;

@InternalApi
public class ReliableAsyncHandshakeContext
implements IHandshakeContext {
    private volatile long _minimumUnsentKey;
    private final long _lastProcessedKey;

    public ReliableAsyncHandshakeContext(long minimumUnconfirmedKey, long lastProcessedKey) {
        this._minimumUnsentKey = minimumUnconfirmedKey;
        this._lastProcessedKey = lastProcessedKey;
    }

    @Override
    public boolean isDone() {
        return this._minimumUnsentKey > this._lastProcessedKey;
    }

    public long getMinimumUnsentKey() {
        return this._minimumUnsentKey;
    }

    public void setMinimumUnsentKey(long minimumUnsentKey) {
        this._minimumUnsentKey = minimumUnsentKey;
    }

    public long getLastProcessedKey() {
        return this._lastProcessedKey;
    }

    @Override
    public String toLogMessage() {
        return "Reliable async handshake context. Minimum unsent key [" + this._minimumUnsentKey + "]. Last processed key by target [" + this._lastProcessedKey + "].";
    }
}

