/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.ReplicationLogUtils;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeIteration;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.ChangeReplicationPacketData;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

@InternalApi
public class ReliableAsyncHandshakeIteration
implements IHandshakeIteration {
    private static final long serialVersionUID = 1L;
    private List<IReplicationOrderedPacket> _packets;

    public ReliableAsyncHandshakeIteration() {
    }

    public ReliableAsyncHandshakeIteration(List<IReplicationOrderedPacket> packets) {
        this._packets = packets;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v12_3_1)) {
            ChangeReplicationPacketData.forRecovery.set(true);
            try {
                this._packets = (List)IOUtils.readObject(in);
            }
            finally {
                ChangeReplicationPacketData.forRecovery.remove();
            }
        } else {
            this._packets = (List)IOUtils.readObject(in);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v12_3_1)) {
            ChangeReplicationPacketData.forRecovery.set(true);
            try {
                IOUtils.writeObject(out, this._packets);
            }
            finally {
                ChangeReplicationPacketData.forRecovery.remove();
            }
        } else {
            IOUtils.writeObject(out, this._packets);
        }
    }

    public List<IReplicationOrderedPacket> getPackets() {
        return this._packets;
    }

    @Override
    public String toLogMessage(boolean detailed) {
        String range = this._packets.isEmpty() ? "(Empty batch)" : "(From key " + this._packets.get(0).getKey() + " to key " + this._packets.get(this._packets.size() - 1).getEndKey() + ")";
        return "Reliable async packets completion, packet count [" + this._packets.size() + "] " + range + (detailed ? StringUtils.NEW_LINE + ReplicationLogUtils.packetsToLogString(this._packets) : "");
    }
}

