/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.config;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupMemberLifeCycle;
import com.gigaspaces.internal.cluster.node.impl.config.SourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.async.AsyncSourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.AsyncChannelConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

@InternalApi
public class DynamicAsyncSourceGroupConfigHolder
extends DynamicSourceGroupConfigHolder {
    public DynamicAsyncSourceGroupConfigHolder(AsyncSourceGroupConfig config) {
        super(config);
    }

    @Override
    protected SourceGroupConfig generateUpdatedConfig(String memberName, SourceGroupConfig config, BacklogConfig backlogConfig, Map<String, IReplicationChannelDataFilter> filters, Map<String, DynamicSourceGroupMemberLifeCycle> lifeCycles, Object customMetadata) {
        AsyncSourceGroupConfig oldConfig = (AsyncSourceGroupConfig)config;
        AsyncChannelConfig asyncChannelConfig = (AsyncChannelConfig)customMetadata;
        String[] newMembers = Arrays.copyOf(oldConfig.getMembersLookupNames(), oldConfig.getMembersLookupNames().length + 1);
        newMembers[newMembers.length - 1] = memberName;
        Map<String, String[]> membersGrouping = oldConfig.getMembersGrouping();
        AsyncSourceGroupConfig newConfig = new AsyncSourceGroupConfig(oldConfig.getName(), backlogConfig, oldConfig.getGroupConsistencyLevelPolicy(), filters, lifeCycles, membersGrouping, config.isNetworkCompressionEnabled(), newMembers);
        for (String oldMemberName : oldConfig.getMembersLookupNames()) {
            AsyncChannelConfig oldMemberConfig = (AsyncChannelConfig)oldConfig.getChannelConfig(oldMemberName);
            if (oldMemberConfig == null) continue;
            newConfig.setChannelConfig(oldMemberName, oldMemberConfig);
        }
        if (asyncChannelConfig != null) {
            newConfig.setChannelConfig(memberName, asyncChannelConfig);
        }
        return newConfig;
    }

    @Override
    protected SourceGroupConfig generateNewConfigWithoutMember(String memberName, BacklogConfig backlogConfig, Map<String, IReplicationChannelDataFilter> filters, Map<String, DynamicSourceGroupMemberLifeCycle> lifeCycles, SourceGroupConfig config) {
        AsyncSourceGroupConfig oldConfig = (AsyncSourceGroupConfig)config;
        ArrayList<String> newMembersList = new ArrayList<String>(Arrays.asList(config.getMembersLookupNames()));
        if (!newMembersList.remove(memberName)) {
            throw new UnsupportedOperationException("Only reliable asynchronous members can be removed from the group");
        }
        String[] newMembers = newMembersList.toArray(new String[newMembersList.size()]);
        Map<String, String[]> membersGrouping = oldConfig.getMembersGrouping();
        AsyncSourceGroupConfig newConfig = new AsyncSourceGroupConfig(config.getName(), backlogConfig, oldConfig.getGroupConsistencyLevelPolicy(), filters, lifeCycles, membersGrouping, oldConfig.isNetworkCompressionEnabled(), newMembers);
        for (String oldMemberName : newMembers) {
            AsyncChannelConfig oldMemberConfig = (AsyncChannelConfig)oldConfig.getChannelConfig(oldMemberName);
            if (oldMemberConfig == null) continue;
            newConfig.setChannelConfig(oldMemberName, oldMemberConfig);
        }
        return newConfig;
    }
}

