/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.config;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupMemberLifeCycle;
import com.gigaspaces.internal.cluster.node.impl.config.SourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.AsyncChannelConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncSourceGroupConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

@InternalApi
public class DynamicReliableAsyncSourceGroupConfigHolder
extends DynamicSourceGroupConfigHolder {
    public DynamicReliableAsyncSourceGroupConfigHolder(ReliableAsyncSourceGroupConfig config) {
        super(config);
    }

    @Override
    protected SourceGroupConfig generateUpdatedConfig(String memberName, SourceGroupConfig config, BacklogConfig backlogConfig, Map<String, IReplicationChannelDataFilter> filters, Map<String, DynamicSourceGroupMemberLifeCycle> lifeCycles, Object customMetadata) {
        ReliableAsyncSourceGroupConfig reliableAsyncSourceGroupConfig = (ReliableAsyncSourceGroupConfig)config;
        AsyncChannelConfig asyncChannelConfig = (AsyncChannelConfig)customMetadata;
        String[] newAsyncMembers = Arrays.copyOf(reliableAsyncSourceGroupConfig.getAsyncMembersLookupNames(), reliableAsyncSourceGroupConfig.getAsyncMembersLookupNames().length + 1);
        newAsyncMembers[newAsyncMembers.length - 1] = memberName;
        Map<String, String[]> membersGrouping = reliableAsyncSourceGroupConfig.getMembersGrouping();
        ReliableAsyncSourceGroupConfig newConfig = new ReliableAsyncSourceGroupConfig(config.getName(), backlogConfig, config.getGroupConsistencyLevelPolicy(), filters, lifeCycles, membersGrouping, reliableAsyncSourceGroupConfig.getSyncMembersLookupNames(), newAsyncMembers, reliableAsyncSourceGroupConfig.getBacklogCompletionBatchSize(), reliableAsyncSourceGroupConfig.getCompletionNotifierInterval(), reliableAsyncSourceGroupConfig.getCompletionNotifierPacketsThreshold(), reliableAsyncSourceGroupConfig.isNetworkCompressionEnabled());
        for (String oldMemberName : reliableAsyncSourceGroupConfig.getMembersLookupNames()) {
            AsyncChannelConfig oldMemberConfig = (AsyncChannelConfig)reliableAsyncSourceGroupConfig.getChannelConfig(oldMemberName);
            if (oldMemberConfig == null) continue;
            newConfig.setChannelConfig(oldMemberName, oldMemberConfig);
        }
        if (asyncChannelConfig != null) {
            newConfig.setChannelConfig(memberName, asyncChannelConfig);
        }
        return newConfig;
    }

    @Override
    protected SourceGroupConfig generateNewConfigWithoutMember(String memberName, BacklogConfig backlogConfig, Map<String, IReplicationChannelDataFilter> filters, Map<String, DynamicSourceGroupMemberLifeCycle> lifeCycles, SourceGroupConfig config) {
        ReliableAsyncSourceGroupConfig reliableAsyncSourceGroupConfig = (ReliableAsyncSourceGroupConfig)config;
        ArrayList<String> newAsyncMembersList = new ArrayList<String>(Arrays.asList(reliableAsyncSourceGroupConfig.getAsyncMembersLookupNames()));
        newAsyncMembersList.remove(memberName);
        String[] newAsyncMembers = newAsyncMembersList.toArray(new String[newAsyncMembersList.size()]);
        Map<String, String[]> membersGrouping = reliableAsyncSourceGroupConfig.getMembersGrouping();
        ReliableAsyncSourceGroupConfig newConfig = new ReliableAsyncSourceGroupConfig(config.getName(), backlogConfig, config.getGroupConsistencyLevelPolicy(), filters, lifeCycles, membersGrouping, reliableAsyncSourceGroupConfig.getSyncMembersLookupNames(), newAsyncMembers, reliableAsyncSourceGroupConfig.getBacklogCompletionBatchSize(), reliableAsyncSourceGroupConfig.getCompletionNotifierInterval(), reliableAsyncSourceGroupConfig.getCompletionNotifierPacketsThreshold(), reliableAsyncSourceGroupConfig.isNetworkCompressionEnabled());
        for (String oldMemberName : newAsyncMembers) {
            AsyncChannelConfig oldMemberConfig = (AsyncChannelConfig)reliableAsyncSourceGroupConfig.getChannelConfig(oldMemberName);
            if (oldMemberConfig == null) continue;
            newConfig.setChannelConfig(oldMemberName, oldMemberConfig);
        }
        return newConfig;
    }
}

