/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.config;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogMemberLimitationConfig;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupMemberLifeCycle;
import com.gigaspaces.internal.cluster.node.impl.config.MemberAddedEvent;
import com.gigaspaces.internal.cluster.node.impl.config.MemberRemovedEvent;
import com.gigaspaces.internal.cluster.node.impl.config.SourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@InternalApi
public class DynamicSourceGroupConfigHolder {
    private volatile SourceGroupConfig _config;
    private volatile SourceGroupConfig _configWithMemberBeingAdded;
    private final Set<IDynamicSourceGroupStateListener> _listeners = new HashSet<IDynamicSourceGroupStateListener>();

    public DynamicSourceGroupConfigHolder(SourceGroupConfig config) {
        this._config = config;
        this._configWithMemberBeingAdded = null;
    }

    public SourceGroupConfig getConfig() {
        return this._config;
    }

    public SourceGroupConfig getConfigWithMemberBeingAdded() {
        return this._configWithMemberBeingAdded;
    }

    public void addListener(IDynamicSourceGroupStateListener listener) {
        this._listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfigWithNewMember(SourceGroupConfig newConfig, String memberName, Object customData, BacklogMemberLimitationConfig memberBacklogLimitations, IReplicationChannelDataFilter filter, DynamicSourceGroupMemberLifeCycle lifeCycle) {
        MemberAddedEvent memberAddedEvent = new MemberAddedEvent(memberName, customData, memberBacklogLimitations, filter, lifeCycle);
        this.triggerBeforeMemberAdded(memberAddedEvent);
        this._configWithMemberBeingAdded = newConfig;
        try {
            for (IDynamicSourceGroupStateListener listener : this._listeners) {
                listener.memberAdded(memberAddedEvent, newConfig);
            }
            this._config = newConfig;
            this.triggerAfterMemberAdded(memberAddedEvent);
        }
        finally {
            this._configWithMemberBeingAdded = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfigWithRemovedMember(SourceGroupConfig newConfig, String memberName) {
        DynamicSourceGroupMemberLifeCycle lifeCycle = this._config.getLifeCycle(memberName);
        this._config = newConfig;
        try {
            for (IDynamicSourceGroupStateListener listener : this._listeners) {
                listener.memberRemoved(memberName, newConfig);
            }
        }
        finally {
            this.triggerAfterMemberRemoved(memberName, lifeCycle);
        }
    }

    private void triggerBeforeMemberAdded(MemberAddedEvent memberAddedEvent) {
        if (memberAddedEvent.getLifeCycle() != null) {
            memberAddedEvent.getLifeCycle().beforeMemberAdded(memberAddedEvent);
        }
    }

    private void triggerAfterMemberAdded(MemberAddedEvent memberAddedEvent) {
        if (memberAddedEvent.getLifeCycle() != null) {
            memberAddedEvent.getLifeCycle().afterMemberAdded(memberAddedEvent);
        }
    }

    private void triggerAfterMemberRemoved(String memberName, DynamicSourceGroupMemberLifeCycle lifeCycle) {
        if (lifeCycle != null) {
            lifeCycle.afterMemberRemoved(new MemberRemovedEvent(memberName));
        }
    }

    public synchronized void addMember(String memberName, IReplicationChannelDataFilter filter, BacklogMemberLimitationConfig memberBacklogLimitations, Object metadata, DynamicSourceGroupMemberLifeCycle lifeCycle) {
        SourceGroupConfig config = this.getConfig();
        if (Arrays.asList(config.getMembersLookupNames()).contains(memberName)) {
            throw new IllegalStateException("Cannot add an already existing member [" + memberName + "]");
        }
        BacklogConfig backlogConfig = this.copyAndApplyBacklogUpdate(memberName, memberBacklogLimitations, config);
        Map<String, IReplicationChannelDataFilter> filters = this.copyAndApplyFilterUpdate(memberName, filter, config);
        Map<String, DynamicSourceGroupMemberLifeCycle> lifeCycles = this.copyAndApplyLifeCycleUpdate(memberName, lifeCycle, config);
        SourceGroupConfig newConfig = this.generateUpdatedConfig(memberName, config, backlogConfig, filters, lifeCycles, metadata);
        this.copyAndApplyCommonProperties(config, newConfig);
        this.updateConfigWithNewMember(newConfig, memberName, metadata, memberBacklogLimitations, filter, lifeCycle);
    }

    public synchronized void removeMember(String memberName) {
        SourceGroupConfig config = this.getConfig();
        if (!Arrays.asList(config.getMembersLookupNames()).contains(memberName)) {
            return;
        }
        BacklogConfig backlogConfig = this.copyAndRemoveBacklogUpdate(memberName, config);
        Map<String, IReplicationChannelDataFilter> filters = this.copyAndRemoveFilterUpdate(memberName, config);
        Map<String, DynamicSourceGroupMemberLifeCycle> lifeCycles = this.copyAndRemoveLifeCycleUpdate(memberName, config);
        SourceGroupConfig newConfig = this.generateNewConfigWithoutMember(memberName, backlogConfig, filters, lifeCycles, config);
        this.copyAndApplyCommonProperties(config, newConfig);
        this.updateConfigWithRemovedMember(newConfig, memberName);
    }

    private Map<String, DynamicSourceGroupMemberLifeCycle> copyAndRemoveLifeCycleUpdate(String memberName, SourceGroupConfig config) {
        HashMap<String, DynamicSourceGroupMemberLifeCycle> lifeCycles = new HashMap<String, DynamicSourceGroupMemberLifeCycle>(config.getLifeCycles());
        lifeCycles.remove(memberName);
        return lifeCycles;
    }

    protected SourceGroupConfig generateNewConfigWithoutMember(String memberName, BacklogConfig backlogConfig, Map<String, IReplicationChannelDataFilter> filters, Map<String, DynamicSourceGroupMemberLifeCycle> lifeCycles, SourceGroupConfig config) {
        ArrayList<String> newMembersList = new ArrayList<String>(Arrays.asList(config.getMembersLookupNames()));
        if (!newMembersList.remove(memberName)) {
            throw new UnsupportedOperationException("Only reliable asynchronous members can be removed from the group");
        }
        String[] newMembers = newMembersList.toArray(new String[newMembersList.size()]);
        SourceGroupConfig newConfig = new SourceGroupConfig(config.getName(), backlogConfig, config.getGroupConsistencyLevelPolicy(), filters, lifeCycles, config.getMembersGrouping(), config.isNetworkCompressionEnabled(), newMembers);
        return newConfig;
    }

    protected SourceGroupConfig generateUpdatedConfig(String memberName, SourceGroupConfig config, BacklogConfig backlogConfig, Map<String, IReplicationChannelDataFilter> filters, Map<String, DynamicSourceGroupMemberLifeCycle> lifeCycles, Object customMetadata) {
        String[] newMembers = Arrays.copyOf(config.getMembersLookupNames(), config.getMembersLookupNames().length + 1);
        newMembers[newMembers.length - 1] = memberName;
        SourceGroupConfig newConfig = new SourceGroupConfig(config.getName(), backlogConfig, config.getGroupConsistencyLevelPolicy(), filters, lifeCycles, config.getMembersGrouping(), config.isNetworkCompressionEnabled(), newMembers);
        return newConfig;
    }

    private void copyAndApplyCommonProperties(SourceGroupConfig config, SourceGroupConfig newConfig) {
        newConfig.setHistoryLength(config.getHistoryLength());
        newConfig.setInconsistentStateDelay(config.getInconsistentStateDelay());
        newConfig.setInconsistentStateRetries(config.getInconsistentStateRetries());
    }

    private Map<String, IReplicationChannelDataFilter> copyAndApplyFilterUpdate(String memberName, IReplicationChannelDataFilter filter, SourceGroupConfig config) {
        HashMap<String, IReplicationChannelDataFilter> filters = new HashMap<String, IReplicationChannelDataFilter>(config.getFilters());
        if (filter != null) {
            filters.put(memberName, filter);
        }
        return filters;
    }

    private Map<String, DynamicSourceGroupMemberLifeCycle> copyAndApplyLifeCycleUpdate(String memberName, DynamicSourceGroupMemberLifeCycle lifeCycle, SourceGroupConfig config) {
        HashMap<String, DynamicSourceGroupMemberLifeCycle> lifeCycles = new HashMap<String, DynamicSourceGroupMemberLifeCycle>(config.getLifeCycles());
        if (lifeCycle != null) {
            lifeCycles.put(memberName, lifeCycle);
        }
        return lifeCycles;
    }

    private Map<String, IReplicationChannelDataFilter> copyAndRemoveFilterUpdate(String memberName, SourceGroupConfig config) {
        HashMap<String, IReplicationChannelDataFilter> filters = new HashMap<String, IReplicationChannelDataFilter>(config.getFilters());
        filters.remove(memberName);
        return filters;
    }

    private BacklogConfig copyAndApplyBacklogUpdate(String memberName, BacklogMemberLimitationConfig memberLimitationConfig, SourceGroupConfig config) {
        BacklogConfig backlogConfig = config.getBacklogConfig().clone();
        backlogConfig.setMemberBacklogLimitation(memberName, memberLimitationConfig);
        return backlogConfig;
    }

    private BacklogConfig copyAndRemoveBacklogUpdate(String memberName, SourceGroupConfig config) {
        BacklogConfig backlogConfig = config.getBacklogConfig().clone();
        backlogConfig.removeMemberConfig(memberName);
        return backlogConfig;
    }

    public String toString() {
        return this._config.toString();
    }

    public static interface IDynamicSourceGroupStateListener {
        public void memberAdded(MemberAddedEvent var1, SourceGroupConfig var2);

        public void memberRemoved(String var1, SourceGroupConfig var2);
    }
}

