/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.config;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.MirrorServiceConfig;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.config.IMirrorChannelReplicationSettings;
import com.gigaspaces.internal.cluster.node.impl.config.ISyncReplicationSettings;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilter;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationOutFilter;
import com.gigaspaces.internal.cluster.node.impl.filters.ISpaceCopyReplicaInFilter;
import com.gigaspaces.internal.cluster.node.impl.filters.ISpaceCopyReplicaOutFilter;
import com.j_spaces.core.cluster.RedoLogCapacityExceededPolicy;
import com.j_spaces.core.cluster.RedoLogCompaction;
import com.j_spaces.core.cluster.ReplicationProcessingType;
import com.j_spaces.core.cluster.SwapBacklogConfig;
import java.util.Set;

@InternalApi
public class MirrorReplicationSettingsAdapter
implements IMirrorChannelReplicationSettings {
    private final MirrorServiceConfig _policy;

    public MirrorReplicationSettingsAdapter(MirrorServiceConfig policy) {
        this._policy = policy;
    }

    @Override
    public String getMirrorMemberName() {
        return this._policy.memberName;
    }

    @Override
    public long getIdleDelay() {
        return this._policy.intervalMillis;
    }

    @Override
    public int getOperationsReplicationThreshold() {
        return this._policy.intervalOpers;
    }

    @Override
    public BacklogConfig.LimitReachedPolicy getLimitReachedPolicy() {
        BacklogConfig.LimitReachedPolicy limitReachedPolicy = this._policy.onRedoLogCapacityExceeded == RedoLogCapacityExceededPolicy.BLOCK_OPERATIONS ? BacklogConfig.LimitReachedPolicy.BLOCK_NEW : BacklogConfig.LimitReachedPolicy.DROP_OLDEST;
        return limitReachedPolicy;
    }

    @Override
    public long getMaxRedoLogCapacity() {
        return this._policy.maxRedoLogCapacity == null ? -1L : this._policy.maxRedoLogCapacity;
    }

    public boolean isReliableAsyncRepl() {
        return true;
    }

    public boolean isMirrorServiceEnabled() {
        return false;
    }

    public boolean isSync() {
        return false;
    }

    @Override
    public int getBatchSize() {
        return this._policy.bulkSize;
    }

    @Override
    public IReplicationOutFilter getOutFilter() {
        return null;
    }

    @Override
    public IReplicationInFilter getInFilter() {
        return null;
    }

    @Override
    public ISpaceCopyReplicaInFilter getSpaceCopyInFilter() {
        return null;
    }

    @Override
    public ISpaceCopyReplicaOutFilter getSpaceCopyOutFilter() {
        return null;
    }

    public boolean isOneWay() {
        return false;
    }

    @Override
    public ISyncReplicationSettings getSyncReplicationSettings() {
        return null;
    }

    @Override
    public ReplicationProcessingType getProcessingType() {
        return null;
    }

    @Override
    public short getBucketCount() {
        return 0;
    }

    @Override
    public int getBatchParallelFactor() {
        return 0;
    }

    @Override
    public int getBatchParallelThreshold() {
        return 0;
    }

    @Override
    public long getConsumeTimeout() {
        return 0L;
    }

    @Override
    public SwapBacklogConfig getSwapBacklogSettings() {
        return null;
    }

    @Override
    public String getBacklogWeightPolicy() {
        return null;
    }

    @Override
    public RedoLogCompaction getRedoLogCompaction() {
        return null;
    }

    @Override
    public boolean isNetworkCompressionEnabled() {
        return true;
    }

    @Override
    public boolean supportsChange() {
        return this._policy.supportedChangeOperations != null;
    }

    @Override
    public Set<String> getSupportedChangeOperations() {
        return this._policy.supportedChangeOperations;
    }
}

