/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.config;

import com.gigaspaces.api.InternalApi;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class MultiBucketReplicationPolicy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final short DEFAULT_BUCKETS_COUNT = 1024;
    public static final Integer DEFAULT_BATCH_PARALLEL_FACTOR = null;
    public static final int DEFAULT_BATCH_PARALLEL_THRESHOLD = 50;
    private short bucketsCount = (short)1024;
    private Integer batchParallelFactor = DEFAULT_BATCH_PARALLEL_FACTOR;
    private int batchParallelThreshold = 50;

    public short getBucketCount() {
        return this.bucketsCount;
    }

    public void setBucketsCount(short bucketsCount) {
        this.bucketsCount = bucketsCount;
    }

    public Integer getBatchParallelFactor() {
        return this.batchParallelFactor;
    }

    public void setBatchParallelFactor(Integer batchParallelFactor) {
        this.batchParallelFactor = batchParallelFactor;
    }

    public int getBatchParallelThreshold() {
        return this.batchParallelThreshold;
    }

    public void setBatchParallelThreshold(int batchParallelThreshold) {
        this.batchParallelThreshold = batchParallelThreshold;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int flags = 0;
        if (this.bucketsCount != 1024) {
            flags |= 1;
        }
        if (this.batchParallelFactor != DEFAULT_BATCH_PARALLEL_FACTOR) {
            flags |= 2;
        }
        if (this.batchParallelThreshold != 50) {
            flags |= 4;
        }
        out.writeInt(flags);
        if (this.bucketsCount != 1024) {
            out.writeShort(this.bucketsCount);
        }
        if (this.batchParallelFactor != DEFAULT_BATCH_PARALLEL_FACTOR) {
            out.writeInt(this.batchParallelFactor);
        }
        if (this.batchParallelThreshold != 50) {
            out.writeInt(this.batchParallelThreshold);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int flags = in.readInt();
        this.bucketsCount = (flags & 1) != 0 ? in.readShort() : (short)1024;
        this.batchParallelFactor = (flags & 2) != 0 ? Integer.valueOf(in.readInt()) : DEFAULT_BATCH_PARALLEL_FACTOR;
        this.batchParallelThreshold = (flags & 4) != 0 ? in.readInt() : 50;
    }

    private static interface BitMap {
        public static final int BUCKETS_COUNT = 1;
        public static final int BATCH_PARALLEL_FACTOR = 2;
        public static final int BATCH_PARALLEL_THRESHOLD = 4;
    }
}

