/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.config;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.GroupMapping;
import com.gigaspaces.internal.cluster.node.impl.IReplicationNodePluginFacade;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeMode;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilter;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationOutFilter;
import com.gigaspaces.internal.cluster.node.impl.filters.ISpaceCopyReplicaInFilter;
import com.gigaspaces.internal.cluster.node.impl.filters.ISpaceCopyReplicaOutFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationDynamicTargetGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationStaticTargetGroupBuilder;
import com.gigaspaces.internal.utils.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

@InternalApi
public class ReplicationNodeConfig {
    private final Map<String, GroupMapping> _sourceGroupsMapping = new HashMap<String, GroupMapping>();
    private final Collection<IReplicationSourceGroupBuilder> _activeSourceGroupsBuilders = new LinkedList<IReplicationSourceGroupBuilder>();
    private final Collection<IReplicationSourceGroupBuilder> _passiveSourceGroupsBuilders = new LinkedList<IReplicationSourceGroupBuilder>();
    private final Collection<IReplicationSourceGroupBuilder> _alwaysSourceGroupsBuilders = new LinkedList<IReplicationSourceGroupBuilder>();
    private final Collection<IReplicationStaticTargetGroupBuilder> _activeStaticTargetGroupsBuilders = new LinkedList<IReplicationStaticTargetGroupBuilder>();
    private final Collection<IReplicationStaticTargetGroupBuilder> _passiveStaticTargetGroupsBuilders = new LinkedList<IReplicationStaticTargetGroupBuilder>();
    private final Collection<IReplicationStaticTargetGroupBuilder> _alwaysStaticTargetGroupsBuilders = new LinkedList<IReplicationStaticTargetGroupBuilder>();
    private final Collection<IReplicationDynamicTargetGroupBuilder> _activeDynamicTargetGroupsBuilders = new LinkedList<IReplicationDynamicTargetGroupBuilder>();
    private final Collection<IReplicationDynamicTargetGroupBuilder> _passiveDynamicTargetGroupsBuilders = new LinkedList<IReplicationDynamicTargetGroupBuilder>();
    private final Collection<IReplicationDynamicTargetGroupBuilder> _alwaysDynamicTargetGroupsBuilders = new LinkedList<IReplicationDynamicTargetGroupBuilder>();
    private IReplicationInFilter _inFilter;
    private IReplicationOutFilter _outFilter;
    private ISpaceCopyReplicaOutFilter _spaceCopyReplicaOutFilter;
    private ISpaceCopyReplicaInFilter _spaceCopyReplicaInFilter;
    private IReplicationNodePluginFacade _pluginFacade;

    public void mapSourceGroups(String packetAddress, GroupMapping groupMapping) {
        this._sourceGroupsMapping.put(packetAddress, groupMapping);
    }

    public Map<String, GroupMapping> getSourceGroupsMapping() {
        return this._sourceGroupsMapping;
    }

    public void addSourceGroupBuilder(IReplicationSourceGroupBuilder groupBuilder, ReplicationNodeMode nodeMode) {
        switch (nodeMode) {
            case ACTIVE: {
                this._activeSourceGroupsBuilders.add(groupBuilder);
                break;
            }
            case PASSIVE: {
                this._passiveSourceGroupsBuilders.add(groupBuilder);
                break;
            }
            case ALWAYS: {
                this._alwaysSourceGroupsBuilders.add(groupBuilder);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void addTargetGroupBuilder(IReplicationStaticTargetGroupBuilder groupBuilder, ReplicationNodeMode nodeMode) {
        switch (nodeMode) {
            case ACTIVE: {
                this._activeStaticTargetGroupsBuilders.add(groupBuilder);
                break;
            }
            case PASSIVE: {
                this._passiveStaticTargetGroupsBuilders.add(groupBuilder);
                break;
            }
            case ALWAYS: {
                this._alwaysStaticTargetGroupsBuilders.add(groupBuilder);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public Collection<IReplicationSourceGroupBuilder> getSourceGroupBuilders(ReplicationNodeMode nodeMode) {
        switch (nodeMode) {
            case ACTIVE: {
                return this._activeSourceGroupsBuilders;
            }
            case PASSIVE: {
                return this._passiveSourceGroupsBuilders;
            }
            case ALWAYS: {
                return this._alwaysSourceGroupsBuilders;
            }
        }
        throw new IllegalArgumentException();
    }

    public Collection<IReplicationStaticTargetGroupBuilder> getTargetGroupBuilders(ReplicationNodeMode nodeMode) {
        switch (nodeMode) {
            case ACTIVE: {
                return this._activeStaticTargetGroupsBuilders;
            }
            case PASSIVE: {
                return this._passiveStaticTargetGroupsBuilders;
            }
            case ALWAYS: {
                return this._alwaysStaticTargetGroupsBuilders;
            }
        }
        throw new IllegalArgumentException();
    }

    public void addDynamicTargetGroupBuilder(IReplicationDynamicTargetGroupBuilder groupBuilder, ReplicationNodeMode nodeMode) {
        switch (nodeMode) {
            case ACTIVE: {
                this._activeDynamicTargetGroupsBuilders.add(groupBuilder);
                break;
            }
            case PASSIVE: {
                this._passiveDynamicTargetGroupsBuilders.add(groupBuilder);
                break;
            }
            case ALWAYS: {
                this._alwaysDynamicTargetGroupsBuilders.add(groupBuilder);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public IReplicationDynamicTargetGroupBuilder getMatchingTargetGroupBuilder(String groupName, ReplicationNodeMode nodeMode) {
        Collection<IReplicationDynamicTargetGroupBuilder> relevantDynList;
        switch (nodeMode) {
            case ACTIVE: {
                relevantDynList = this._activeDynamicTargetGroupsBuilders;
                break;
            }
            case PASSIVE: {
                relevantDynList = this._passiveDynamicTargetGroupsBuilders;
                break;
            }
            case ALWAYS: {
                relevantDynList = this._alwaysDynamicTargetGroupsBuilders;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        for (IReplicationDynamicTargetGroupBuilder builder : relevantDynList) {
            if (!groupName.matches(builder.getGroupNameTemplate())) continue;
            return builder;
        }
        return null;
    }

    public void setReplicationInFilter(IReplicationInFilter inFilter) {
        this._inFilter = inFilter;
    }

    public void setReplicationOutFilter(IReplicationOutFilter outFilter) {
        this._outFilter = outFilter;
    }

    public IReplicationInFilter getReplicationInFilter() {
        return this._inFilter;
    }

    public IReplicationOutFilter getReplicationOutFilter() {
        return this._outFilter;
    }

    public ISpaceCopyReplicaOutFilter getSpaceCopyReplicaOutFilter() {
        return this._spaceCopyReplicaOutFilter;
    }

    public void setSpaceCopyReplicaOutFilter(ISpaceCopyReplicaOutFilter spaceCopyReplicaOutFilter) {
        this._spaceCopyReplicaOutFilter = spaceCopyReplicaOutFilter;
    }

    public ISpaceCopyReplicaInFilter getSpaceCopyReplicaInFilter() {
        return this._spaceCopyReplicaInFilter;
    }

    public void setSpaceCopyReplicaInFilter(ISpaceCopyReplicaInFilter spaceCopyReplicaInFilter) {
        this._spaceCopyReplicaInFilter = spaceCopyReplicaInFilter;
    }

    public void setPluginFacade(IReplicationNodePluginFacade pluginFacade) {
        this._pluginFacade = pluginFacade;
    }

    public IReplicationNodePluginFacade getPluginFacade() {
        return this._pluginFacade;
    }

    public String toString() {
        return "ReplicationNodeConfig [" + StringUtils.NEW_LINE + "\t_sourceGroupsMapping=" + this._sourceGroupsMapping + StringUtils.NEW_LINE + "\t_activeSourceGroupsBuilders=" + ReplicationNodeConfig.printGroupCollection(this._activeSourceGroupsBuilders) + StringUtils.NEW_LINE + "\t_passiveSourceGroupsBuilders=" + ReplicationNodeConfig.printGroupCollection(this._passiveSourceGroupsBuilders) + StringUtils.NEW_LINE + "\t_alwaysSourceGroupsBuilders=" + ReplicationNodeConfig.printGroupCollection(this._alwaysSourceGroupsBuilders) + StringUtils.NEW_LINE + "\t_activeTargetGroupsBuilders=" + ReplicationNodeConfig.printGroupCollection(this._activeStaticTargetGroupsBuilders) + StringUtils.NEW_LINE + "\t_passiveTargetGroupsBuilders=" + ReplicationNodeConfig.printGroupCollection(this._passiveStaticTargetGroupsBuilders) + StringUtils.NEW_LINE + "\t_alwaysTargetGroupsBuilders=" + ReplicationNodeConfig.printGroupCollection(this._alwaysStaticTargetGroupsBuilders) + StringUtils.NEW_LINE + "\t_inFilter=" + this._inFilter + StringUtils.NEW_LINE + "\t_outFilter=" + this._outFilter + StringUtils.NEW_LINE + "\t_spaceCopyReplicaOutFilter=" + this._spaceCopyReplicaOutFilter + StringUtils.NEW_LINE + "\t_spaceCopyReplicaInFilter=" + this._spaceCopyReplicaInFilter + StringUtils.NEW_LINE + "]";
    }

    private static String printGroupCollection(Collection<?> collection) {
        StringBuilder result = new StringBuilder();
        if (collection.isEmpty()) {
            return "NONE";
        }
        for (Object object : collection) {
            result.append(StringUtils.NEW_LINE);
            result.append(object);
        }
        return result.toString();
    }
}

