/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.config;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.ConsistencyLevel;
import com.gigaspaces.cluster.replication.ReplicationFilterManager;
import com.gigaspaces.cluster.replication.ReplicationTransmissionPolicy;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.cluster.node.impl.GroupMapping;
import com.gigaspaces.internal.cluster.node.impl.IReplicationNodeBuilder;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNodeBuilder;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogMemberLimitationConfig;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderBacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileBacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.backlog.multisourcesinglefile.MultiSourceSingleFileBacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicAsyncSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicReliableAsyncSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.IMirrorChannelReplicationSettings;
import com.gigaspaces.internal.cluster.node.impl.config.IReliableAsyncReplicationSettings;
import com.gigaspaces.internal.cluster.node.impl.config.IReplicationComponentPolicy;
import com.gigaspaces.internal.cluster.node.impl.config.IReplicationSettings;
import com.gigaspaces.internal.cluster.node.impl.config.ISpaceReplicationSettings;
import com.gigaspaces.internal.cluster.node.impl.config.MirrorReplicationSettingsAdapter;
import com.gigaspaces.internal.cluster.node.impl.config.ReliableAsyncReplicationSettingsAdapter;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeConfig;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeMode;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationSettingsAdapter;
import com.gigaspaces.internal.cluster.node.impl.config.SourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.config.TargetGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.GeneralReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilterBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.ReliableAsyncKeeperLruCentralDataSourceReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.async.AsyncMultiOriginReplicationTargetGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.async.AsyncReplicationSourceGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.async.AsyncSingleOriginReplicationTargetGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.async.AsyncSourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.consistencylevel.GroupConsistencyLevelPolicy;
import com.gigaspaces.internal.cluster.node.impl.groups.consistencylevel.SyncMembersInSyncConsistencyLevelPolicy;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.AsyncChannelConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.IDynamicSourceGroupMemberLifeCycleBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.MirrorChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncKeeperReplicationTargetGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncReplicationSourceGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncSingleOriginReplicationTargetGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncSourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.BacklogAdjustedThrottleControllerBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.IReplicationThrottleControllerBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.SyncMultiOriginReplicationTargetGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.SyncReplicationSourceGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.SyncSingleOriginReplicationTargetGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.ProcessLogConfig;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderProcessLogConfig;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileProcessLogConfig;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.MultiSourceSingleFileProcessLogConfig;
import com.gigaspaces.internal.extension.XapExtensions;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.sync.mirror.MirrorConfig;
import com.gigaspaces.internal.utils.StringUtils;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.core.cluster.ReplicationProcessingType;
import com.j_spaces.core.filters.ReplicationStatistics;
import com.j_spaces.core.sadapter.IStorageAdapter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ReplicationNodeConfigBuilder {
    public static final String PRIMARY_BACKUP_RELIABLE_ASYNC = "primary-backup-reliable-async-mirror-";
    public static final String PRIMARY_BACKUP_RELIABLE_ASYNC_NO_MIRROR = "primary-backup-reliable-async-";
    public static final String ASYNC_MIRROR = "async-mirror-";
    public static final String ASYNC = "async";
    public static final String SYNC = "sync";
    public static final String PRIMARY_BACKUP_SYNC = "primary-backup-sync";
    public static final String PRIMARY_BACKUP_ASYNC = "primary-backup-async";
    public static final long UNLIMITED = -1L;
    public static final String PERSISTENCY_GROUPING_NAME = "persistency";
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.replication.node");

    public static ReplicationNodeConfigBuilder getInstance() {
        return XapExtensions.getInstance().getReplicationNodeConfigBuilder();
    }

    protected boolean requiresEvictionReplicationProtection(ClusterPolicy clusterPolicy, IStorageAdapter storageAdapter, SpaceConfigReader configReader) {
        return storageAdapter.supportsExternalDB() && clusterPolicy.getReplicationPolicy().isMirrorServiceEnabled() && this.isEvictableCachePolicy(configReader);
    }

    protected boolean reliableAsyncKeeperCannotRefillContent(ClusterPolicy clusterPolicy, IStorageAdapter storageAdapter, SpaceConfigReader configReader) {
        return storageAdapter.supportsExternalDB() && this.isCentralDB(storageAdapter, clusterPolicy) && this.isEvictableCachePolicy(configReader) && !this.dataSourceSupportsVersioning(configReader);
    }

    public ReplicationNodeConfig createConfig(SpaceClusterInfo clusterInfo, ClusterPolicy clusterPolicy, IReplicationNodeBuilder nodeBuilder, ReplicationFilterManager filterManager, int partitionId, IStorageAdapter storageAdapter, SpaceConfigReader configReader, IReplicationChannelDataFilterBuilder filterBuilder, IDynamicSourceGroupMemberLifeCycleBuilder lifeCycleBuilder) {
        boolean hasExistingReplicationMembers;
        this.validateSupportedConfig(clusterPolicy);
        boolean isReliableAsync = clusterPolicy.getReplicationPolicy().isReliableAsyncRepl();
        boolean syncReplication = clusterPolicy.getReplicationPolicy().m_IsSyncReplicationEnabled;
        boolean primaryBackupGroup = clusterPolicy.isPrimaryElectionAvailable();
        boolean hasMirror = clusterPolicy.getReplicationPolicy().isMirrorServiceEnabled();
        boolean bl = hasExistingReplicationMembers = clusterPolicy.getReplicationPolicy().getReplicationTargetsCount() > 0;
        if (hasMirror) {
            if (isReliableAsync && syncReplication && primaryBackupGroup) {
                ReliableAsyncReplicationSettingsAdapter reliableAsyncSettings = new ReliableAsyncReplicationSettingsAdapter(clusterPolicy.getReplicationPolicy(), filterManager, this.reliableAsyncKeeperCannotRefillContent(clusterPolicy, storageAdapter, configReader));
                return this.createReliableAsyncSourceWithMirrorConfig(reliableAsyncSettings, nodeBuilder, partitionId, filterBuilder, lifeCycleBuilder, this.requiresEvictionReplicationProtection(clusterPolicy, storageAdapter, configReader));
            }
            if (isReliableAsync && syncReplication) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.warning("Creating a reliable async mirrored topology without a backup is not considered reliable async");
                }
                MirrorReplicationSettingsAdapter mirrorSettings = new MirrorReplicationSettingsAdapter(clusterPolicy.getReplicationPolicy().getMirrorServiceConfig());
                ReplicationSettingsAdapter replicationPolicy = new ReplicationSettingsAdapter(clusterPolicy.getReplicationPolicy(), filterManager);
                return this.createSourceWithMirrorConfig(mirrorSettings, replicationPolicy, nodeBuilder, partitionId, this.requiresEvictionReplicationProtection(clusterPolicy, storageAdapter, configReader));
            }
            throw new UnsupportedOperationException("Mirror is supported only with primary-backup synchronous replication topology.");
        }
        ReplicationSettingsAdapter replicationPolicy = new ReplicationSettingsAdapter(clusterPolicy.getReplicationPolicy(), filterManager);
        if (primaryBackupGroup) {
            if (syncReplication) {
                ReliableAsyncReplicationSettingsAdapter reliableAsyncSettings = new ReliableAsyncReplicationSettingsAdapter(clusterPolicy.getReplicationPolicy(), filterManager, this.reliableAsyncKeeperCannotRefillContent(clusterPolicy, storageAdapter, configReader));
                return this.createReliableAsyncSourceConfig(reliableAsyncSettings, nodeBuilder, partitionId, filterBuilder, lifeCycleBuilder);
            }
            return this.createPrimaryBackupAsyncConfig(replicationPolicy, nodeBuilder);
        }
        if (hasExistingReplicationMembers) {
            if (storageAdapter.supportsExternalDB() && this.isCentralDB(storageAdapter, clusterPolicy)) {
                _logger.warning("Active active replication topology with central database is deprecated - use gateway replication instead.");
            }
            if (syncReplication) {
                return this.createSyncReplicationConfig(replicationPolicy, nodeBuilder);
            }
            return this.createAsyncReplicationConfig(replicationPolicy, nodeBuilder);
        }
        return this.createPrimaryNoBackupReplicationConfig(replicationPolicy, nodeBuilder, partitionId);
    }

    protected boolean dataSourceSupportsVersioning(SpaceConfigReader configReader) {
        return configReader.getBooleanSpaceProperty("external-data-source.supports-version", "false");
    }

    protected boolean isEvictableCachePolicy(SpaceConfigReader configReader) {
        return configReader.getIntSpaceProperty("engine.cache_policy", String.valueOf(0)) != 1 && configReader.getIntSpaceProperty("engine.cache_policy", String.valueOf(0)) != 3;
    }

    protected boolean isCentralDB(IStorageAdapter storageAdapter, ClusterPolicy clusterPolicy) {
        return storageAdapter.supportsExternalDB() && clusterPolicy.m_CacheLoaderConfig.centralDataSource;
    }

    protected void validateSupportedConfig(ClusterPolicy clusterPolicy) {
        ReplicationPolicy replicationPolicy = clusterPolicy.getReplicationPolicy();
        if (!replicationPolicy.isReplicateOriginalState() && _logger.isLoggable(Level.WARNING)) {
            _logger.warning("Replicate original state = false is not supported, using true instead. For more information refer to upgrading page");
        }
        if (replicationPolicy.m_ReplMemberPolicyDescTable == null) {
            return;
        }
        Set<Map.Entry<String, ReplicationPolicy.ReplicationPolicyDescription>> entrySet = replicationPolicy.m_ReplMemberPolicyDescTable.entrySet();
        for (Map.Entry<String, ReplicationPolicy.ReplicationPolicyDescription> entry : entrySet) {
            ReplicationPolicy.ReplicationPolicyDescription policyDescription = entry.getValue();
            List<ReplicationTransmissionPolicy> transmissionPolicies = policyDescription.replTransmissionPolicies;
            if (transmissionPolicies == null) continue;
            for (ReplicationTransmissionPolicy replicationTransmissionPolicy : transmissionPolicies) {
                if (replicationTransmissionPolicy.m_DisableTransmission) {
                    throw new UnsupportedOperationException("Transmission policies with disabled members is not supported. For more information refer to upgrading page");
                }
                if (replicationTransmissionPolicy.m_RepTransmissionOperations == null || replicationTransmissionPolicy.m_RepTransmissionOperations.indexOf(78) != -1 && replicationTransmissionPolicy.m_RepTransmissionOperations.indexOf(84) != -1 && replicationTransmissionPolicy.m_RepTransmissionOperations.indexOf(87) != -1) continue;
                throw new UnsupportedOperationException("Transmission policies with disabled operations is not supported. For more information refer to upgrading page");
            }
        }
        if (replicationPolicy.isOneWayReplication && _logger.isLoggable(Level.WARNING)) {
            _logger.warning("One way replication is not supported, regular replication will be used instead.");
        }
    }

    public ReplicationNodeConfig createAsyncReplicationConfig(ISpaceReplicationSettings replicationPolicy, IReplicationNodeBuilder nodeBuilder) {
        String groupName = ASYNC;
        this.validateConfig(replicationPolicy);
        ReplicationNodeConfig replicationNodeConfig = new ReplicationNodeConfig();
        replicationNodeConfig.mapSourceGroups("all", GroupMapping.getAllMapping());
        BacklogConfig backlogConfig = this.createBacklogConfig(replicationPolicy, null, false, false);
        List<String> groupMemberNames = this.createGroupMemberNames(replicationPolicy);
        this.configureBacklogLimitations(replicationPolicy, backlogConfig, groupMemberNames);
        HashMap<String, IReplicationChannelDataFilter> filters = new HashMap<String, IReplicationChannelDataFilter>();
        this.addGeneralReplicationFilter(groupMemberNames, filters);
        AsyncSourceGroupConfig sourceGroupConfig = new AsyncSourceGroupConfig(ASYNC, backlogConfig, null, filters, null, null, replicationPolicy.isNetworkCompressionEnabled(), groupMemberNames.toArray(new String[groupMemberNames.size()]));
        for (String memberName : groupMemberNames) {
            sourceGroupConfig.setChannelConfig(memberName, new AsyncChannelConfig(replicationPolicy.getBatchSize(), replicationPolicy.getIdleDelay(), replicationPolicy.getOperationsReplicationThreshold(), ReplicationStatistics.ReplicationMode.ACTIVE_SPACE));
        }
        DynamicAsyncSourceGroupConfigHolder configHolder = new DynamicAsyncSourceGroupConfigHolder(sourceGroupConfig);
        this.configureAsyncSourceGroup(replicationPolicy, nodeBuilder, replicationNodeConfig, configHolder);
        this.configureAsyncReplicatedTargetGroup(replicationPolicy, nodeBuilder, replicationNodeConfig, groupMemberNames, ASYNC);
        this.setReplicationFilters(replicationPolicy, replicationNodeConfig);
        return replicationNodeConfig;
    }

    public ReplicationNodeConfig createPrimaryNoBackupReplicationConfig(ISpaceReplicationSettings replicationPolicy, IReplicationNodeBuilder nodeBuilder, int partitionId) {
        String groupName = this.createReplicationGroupName(partitionId, true, true, false, false);
        this.validateConfig(replicationPolicy);
        ReplicationNodeConfig replicationNodeConfig = new ReplicationNodeConfig();
        replicationNodeConfig.mapSourceGroups("all", GroupMapping.getAllMapping());
        BacklogConfig backlogConfig = this.createBacklogConfig(replicationPolicy, null, false, false);
        List<String> groupMemberNames = this.createGroupMemberNames(replicationPolicy);
        this.configureBacklogLimitations(replicationPolicy, backlogConfig, groupMemberNames);
        HashMap<String, IReplicationChannelDataFilter> filters = new HashMap<String, IReplicationChannelDataFilter>();
        this.addGeneralReplicationFilter(groupMemberNames, filters);
        AsyncSourceGroupConfig sourceGroupConfig = new AsyncSourceGroupConfig(groupName, backlogConfig, null, filters, null, null, replicationPolicy.isNetworkCompressionEnabled(), groupMemberNames.toArray(new String[groupMemberNames.size()]));
        for (String memberName : groupMemberNames) {
            sourceGroupConfig.setChannelConfig(memberName, new AsyncChannelConfig(replicationPolicy.getBatchSize(), replicationPolicy.getIdleDelay(), replicationPolicy.getOperationsReplicationThreshold(), ReplicationStatistics.ReplicationMode.ACTIVE_SPACE));
        }
        DynamicAsyncSourceGroupConfigHolder configHolder = new DynamicAsyncSourceGroupConfigHolder(sourceGroupConfig);
        this.configureAsyncSourceGroup(replicationPolicy, nodeBuilder, replicationNodeConfig, configHolder);
        this.setReplicationFilters(replicationPolicy, replicationNodeConfig);
        return replicationNodeConfig;
    }

    public ReplicationNodeConfig createSyncReplicationConfig(ISpaceReplicationSettings replicationPolicy, IReplicationNodeBuilder nodeBuilder) {
        String groupName = SYNC;
        this.validateConfig(replicationPolicy);
        ReplicationNodeConfig replicationNodeConfig = new ReplicationNodeConfig();
        replicationNodeConfig.mapSourceGroups("all", GroupMapping.getAllMapping());
        BacklogConfig backlogConfig = this.createBacklogConfig(replicationPolicy, null, true, true);
        List<String> groupMemberNames = this.createGroupMemberNames(replicationPolicy);
        this.configureBacklogLimitations(replicationPolicy, backlogConfig, groupMemberNames);
        HashMap<String, IReplicationChannelDataFilter> filters = new HashMap<String, IReplicationChannelDataFilter>();
        this.addGeneralReplicationFilter(groupMemberNames, filters);
        SourceGroupConfig sourceGroupConfig = new SourceGroupConfig(SYNC, backlogConfig, null, filters, null, null, true, groupMemberNames.toArray(new String[groupMemberNames.size()]));
        DynamicSourceGroupConfigHolder configHolder = new DynamicSourceGroupConfigHolder(sourceGroupConfig);
        this.configureSyncSourceGroup(replicationPolicy, nodeBuilder, replicationNodeConfig, configHolder, ReplicationStatistics.ReplicationMode.ACTIVE_SPACE);
        this.configureSyncReplicatedTargetGroup(replicationPolicy, nodeBuilder, replicationNodeConfig, groupMemberNames, SYNC, true);
        this.setReplicationFilters(replicationPolicy, replicationNodeConfig);
        return replicationNodeConfig;
    }

    public ReplicationNodeConfig createPrimaryBackupSyncConfig(ISpaceReplicationSettings replicationPolicy, IReplicationNodeBuilder nodeBuilder, int partitionId) {
        String groupName = "primary-backup-sync-" + partitionId;
        this.validateConfig(replicationPolicy);
        ReplicationNodeConfig replicationNodeConfig = new ReplicationNodeConfig();
        replicationNodeConfig.mapSourceGroups("all", GroupMapping.getAllMapping());
        BacklogConfig backlogConfig = this.createBacklogConfig(replicationPolicy, null, true, false);
        List<String> groupMemberNames = this.createGroupMemberNames(replicationPolicy);
        this.configureBacklogLimitations(replicationPolicy, backlogConfig, groupMemberNames);
        HashMap<String, IReplicationChannelDataFilter> filters = new HashMap<String, IReplicationChannelDataFilter>();
        this.addGeneralReplicationFilter(groupMemberNames, filters);
        SourceGroupConfig sourceGroupConfig = new SourceGroupConfig(groupName, backlogConfig, null, filters, null, null, replicationPolicy.isNetworkCompressionEnabled(), groupMemberNames.toArray(new String[groupMemberNames.size()]));
        DynamicSourceGroupConfigHolder configHolder = new DynamicSourceGroupConfigHolder(sourceGroupConfig);
        this.configureSyncSourceGroup(replicationPolicy, nodeBuilder, replicationNodeConfig, configHolder, ReplicationStatistics.ReplicationMode.BACKUP_SPACE);
        this.configureSyncPrimaryBackupTargetGroup(replicationPolicy, nodeBuilder, replicationNodeConfig, groupMemberNames, groupName, true, false);
        this.setReplicationFilters(replicationPolicy, replicationNodeConfig);
        return replicationNodeConfig;
    }

    public ReplicationNodeConfig createPrimaryBackupAsyncConfig(ISpaceReplicationSettings replicationPolicy, IReplicationNodeBuilder nodeBuilder) {
        String groupName = PRIMARY_BACKUP_ASYNC;
        this.validateConfig(replicationPolicy);
        ReplicationNodeConfig replicationNodeConfig = new ReplicationNodeConfig();
        replicationNodeConfig.mapSourceGroups("all", GroupMapping.getAllMapping());
        BacklogConfig backlogConfig = this.createBacklogConfig(replicationPolicy, null, false, false);
        List<String> groupMemberNames = this.createGroupMemberNames(replicationPolicy);
        this.configureBacklogLimitations(replicationPolicy, backlogConfig, groupMemberNames);
        HashMap<String, IReplicationChannelDataFilter> filters = new HashMap<String, IReplicationChannelDataFilter>();
        this.addGeneralReplicationFilter(groupMemberNames, filters);
        AsyncSourceGroupConfig sourceGroupConfig = new AsyncSourceGroupConfig(PRIMARY_BACKUP_ASYNC, backlogConfig, null, filters, null, null, replicationPolicy.isNetworkCompressionEnabled(), groupMemberNames.toArray(new String[groupMemberNames.size()]));
        DynamicAsyncSourceGroupConfigHolder configHolder = new DynamicAsyncSourceGroupConfigHolder(sourceGroupConfig);
        this.configureAsyncSourceGroup(replicationPolicy, nodeBuilder, replicationNodeConfig, configHolder);
        this.configureAsyncPrimaryBackupTargetGroup(replicationPolicy, nodeBuilder, replicationNodeConfig, groupMemberNames, PRIMARY_BACKUP_ASYNC);
        this.setReplicationFilters(replicationPolicy, replicationNodeConfig);
        return replicationNodeConfig;
    }

    public BacklogConfig createBacklogConfig(ISpaceReplicationSettings replicationPolicy, IMirrorChannelReplicationSettings mirrorPolicy, boolean supportsConcurrentReplication, boolean supportsMultiSourceReplication) {
        return this.createBacklogConfig(replicationPolicy, mirrorPolicy, null, supportsConcurrentReplication, supportsMultiSourceReplication);
    }

    public BacklogConfig createBacklogConfig(ISpaceReplicationSettings replicationPolicy, IMirrorChannelReplicationSettings mirrorPolicy, IReplicationComponentPolicy replicationComponentPolicy, boolean supportsConcurrentReplication, boolean supportsMultiSourceReplication) {
        BacklogConfig config;
        if (replicationPolicy.getProcessingType() == ReplicationProcessingType.MULTIPLE_BUCKETS && supportsConcurrentReplication) {
            MultiBucketSingleFileBacklogConfig multiBucketConfig = new MultiBucketSingleFileBacklogConfig();
            multiBucketConfig.setBucketCount(replicationPolicy.getBucketCount());
            config = multiBucketConfig;
        } else {
            config = replicationPolicy.getProcessingType() == ReplicationProcessingType.MULTIPLE_SOURCES && supportsMultiSourceReplication ? new MultiSourceSingleFileBacklogConfig() : new GlobalOrderBacklogConfig();
        }
        config.setBackLogWeightPolicy(replicationPolicy.getBacklogWeightPolicy());
        long maxRedoLogMemoryCapacity = replicationPolicy.getMaxRedoLogMemoryCapacity();
        if (maxRedoLogMemoryCapacity == -1L) {
            config.setUnlimitedMemoryCapacity();
        } else {
            long maxReplicationComponentRedoLogCapacity;
            long l = maxReplicationComponentRedoLogCapacity = replicationComponentPolicy != null ? replicationComponentPolicy.getMaxRedoLogCapacity() : 0L;
            if (!(replicationPolicy.getMaxRedoLogCapacity() == -1L || replicationPolicy.getMaxRedoLogCapacityDuringRecovery() == -1L || mirrorPolicy != null && mirrorPolicy.getMaxRedoLogCapacity() == -1L || replicationComponentPolicy != null && maxReplicationComponentRedoLogCapacity == -1L)) {
                long maxCapacity = Math.max(replicationPolicy.getMaxRedoLogCapacity(), replicationPolicy.getMaxRedoLogCapacityDuringRecovery());
                if (mirrorPolicy != null) {
                    maxCapacity = Math.max(maxCapacity, mirrorPolicy.getMaxRedoLogCapacity());
                }
                if (replicationComponentPolicy != null) {
                    maxCapacity = Math.max(maxCapacity, maxReplicationComponentRedoLogCapacity);
                }
                if (maxCapacity == maxRedoLogMemoryCapacity) {
                    config.setUnlimitedMemoryCapacity();
                } else {
                    if (maxCapacity < maxRedoLogMemoryCapacity) {
                        throw new IllegalArgumentException("the maximum between 'cluster-config.groups.group.repl-policy.redo-log-capacity=" + replicationPolicy.getMaxRedoLogCapacity() + " 'cluster-config.groups.group.repl-policy.redo-log-recovery-capacity=" + replicationPolicy.getMaxRedoLogCapacityDuringRecovery() + (mirrorPolicy != null ? " and 'cluster-config.mirror-service.redo-log-capacity=" + mirrorPolicy.getMaxRedoLogCapacity() : "") + (replicationComponentPolicy != null ? " and replication gateways=" + maxReplicationComponentRedoLogCapacity : "") + " cannot be less than the 'cluster-config.groups.group.repl-policy.redo-log-memory-capacity=" + replicationPolicy.getMaxRedoLogMemoryCapacity() + "'");
                    }
                    config.setLimitedMemoryCapacity((int)maxRedoLogMemoryCapacity);
                }
            } else {
                config.setLimitedMemoryCapacity((int)maxRedoLogMemoryCapacity);
            }
        }
        config.setSwapBacklogConfig(replicationPolicy.getSwapBacklogSettings());
        if (mirrorPolicy != null) {
            config.setMirrorMemberName(mirrorPolicy.getMirrorMemberName());
        }
        config.setRedoLogCompaction(replicationPolicy.getRedoLogCompaction());
        return config;
    }

    private String getCapacityDisplayStr(long capacity) {
        return capacity == -1L ? "unlimited(-1)" : "" + capacity;
    }

    private void configureAsyncSourceGroup(IReplicationSettings replicationPolicy, IReplicationNodeBuilder nodeBuilder, ReplicationNodeConfig replicationNodeConfig, DynamicAsyncSourceGroupConfigHolder configHolder) {
        AsyncReplicationSourceGroupBuilder sourceAsync = new AsyncReplicationSourceGroupBuilder(configHolder);
        sourceAsync.setBatchSize(replicationPolicy.getBatchSize());
        sourceAsync.setIntervalMilis(replicationPolicy.getIdleDelay());
        sourceAsync.setIntervalOperations(replicationPolicy.getOperationsReplicationThreshold());
        sourceAsync.setAsyncHandlerProvider(nodeBuilder.getAsyncHandlerProvider());
        sourceAsync.setBacklogBuilder(nodeBuilder.getReplicationBacklogBuilder());
        replicationNodeConfig.addSourceGroupBuilder(sourceAsync, ReplicationNodeMode.ACTIVE);
    }

    private void configureSyncSourceGroup(IReplicationSettings replicationPolicy, IReplicationNodeBuilder nodeBuilder, ReplicationNodeConfig replicationNodeConfig, DynamicSourceGroupConfigHolder configHolder, ReplicationStatistics.ReplicationMode channelType) {
        SyncReplicationSourceGroupBuilder sourceSync = new SyncReplicationSourceGroupBuilder(configHolder);
        sourceSync.setAsyncStateBatchSize(replicationPolicy.getBatchSize());
        sourceSync.setAsyncHandlerProvider(nodeBuilder.getAsyncHandlerProvider());
        sourceSync.setAsyncStateIdleDelay(replicationPolicy.getIdleDelay());
        sourceSync.setThrottleController(this.createSyncGroupThrottleController(replicationPolicy));
        sourceSync.setBacklogBuilder(nodeBuilder.getReplicationBacklogBuilder());
        sourceSync.setChannelType(channelType);
        replicationNodeConfig.addSourceGroupBuilder(sourceSync, ReplicationNodeMode.ACTIVE);
    }

    public IReplicationThrottleControllerBuilder createSyncGroupThrottleController(IReplicationSettings replicationPolicy) {
        int maxTPWhenInactive = replicationPolicy.getSyncReplicationSettings().getMaxThrottleTPWhenInactive();
        int minTPWhenActive = replicationPolicy.getSyncReplicationSettings().getMinThrottleTPWhenActive();
        int threshold = replicationPolicy.getBatchSize();
        boolean throttleWhenInactive = replicationPolicy.getSyncReplicationSettings().isThrottleWhenInactive();
        return new BacklogAdjustedThrottleControllerBuilder(maxTPWhenInactive, minTPWhenActive, threshold, throttleWhenInactive);
    }

    public List<String> createGroupMemberNames(ISpaceReplicationSettings settings) {
        LinkedList<String> groupMemberNames = new LinkedList<String>(settings.getGroupMemberNames());
        Iterator iterator = groupMemberNames.iterator();
        while (iterator.hasNext()) {
            String memberName = (String)iterator.next();
            if (!memberName.equals(settings.getSpaceMemberName())) continue;
            iterator.remove();
        }
        return groupMemberNames;
    }

    public ReplicationNodeConfig createReliableAsyncSourceConfig(IReliableAsyncReplicationSettings reliableAsyncSettings, IReplicationNodeBuilder nodeBuilder, int partitionId, IReplicationChannelDataFilterBuilder filterBuilder, IDynamicSourceGroupMemberLifeCycleBuilder lifeCycleBuilder) {
        ISpaceReplicationSettings replicationPolicy = reliableAsyncSettings.getSpaceReplicationSettings();
        this.validateConfig(replicationPolicy);
        String groupName = this.createReplicationGroupName(partitionId, true, true, false, true);
        ReplicationNodeConfig replicationNodeConfig = new ReplicationNodeConfig();
        replicationNodeConfig.mapSourceGroups("all", GroupMapping.getAllMapping());
        BacklogConfig backlogConfig = this.createBacklogConfig(replicationPolicy, null, true, true);
        List<String> syncGroupMemberNames = this.createGroupMemberNames(replicationPolicy);
        this.configureBacklogLimitations(replicationPolicy, backlogConfig, syncGroupMemberNames);
        LinkedList reliableAsyncMemberNames = new LinkedList();
        HashMap<String, IReplicationChannelDataFilter> filters = new HashMap<String, IReplicationChannelDataFilter>();
        this.addKeepersFilters(reliableAsyncSettings, groupName, syncGroupMemberNames, filters, false);
        GroupConsistencyLevelPolicy groupConsistencyLevelPolicy = this.getGroupConsistencyLevel(replicationPolicy, syncGroupMemberNames);
        ReliableAsyncSourceGroupConfig sourceGroupConfig = new ReliableAsyncSourceGroupConfig(groupName, backlogConfig, groupConsistencyLevelPolicy, filters, null, null, syncGroupMemberNames.toArray(new String[syncGroupMemberNames.size()]), reliableAsyncMemberNames.toArray(new String[reliableAsyncMemberNames.size()]), replicationPolicy.getBatchSize(), reliableAsyncSettings.getReliableAsyncCompletionNotifierInterval(), reliableAsyncSettings.getReliableAsyncCompletionNotifierPacketsThreshold(), reliableAsyncSettings.getSpaceReplicationSettings().isNetworkCompressionEnabled());
        DynamicReliableAsyncSourceGroupConfigHolder configHolder = new DynamicReliableAsyncSourceGroupConfigHolder(sourceGroupConfig);
        this.addKeepersListeners(filters, configHolder);
        ReliableAsyncReplicationSourceGroupBuilder sourceSync = new ReliableAsyncReplicationSourceGroupBuilder(configHolder);
        sourceSync.setAsyncHandlerProvider(nodeBuilder.getAsyncHandlerProvider());
        sourceSync.setAsyncChannelBatchSize(replicationPolicy.getBatchSize());
        sourceSync.setAsyncChannelIntervalMilis(replicationPolicy.getIdleDelay());
        sourceSync.setAsyncChannelIntervalOperations(replicationPolicy.getOperationsReplicationThreshold());
        sourceSync.setSyncChannelAsyncStateBatchSize(replicationPolicy.getBatchSize());
        sourceSync.setSyncChannelIdleDelayMilis(replicationPolicy.getIdleDelay());
        sourceSync.setThrottleController(this.createSyncGroupThrottleController(replicationPolicy));
        sourceSync.setBacklogBuilder(nodeBuilder.getReplicationBacklogBuilder());
        replicationNodeConfig.addSourceGroupBuilder(sourceSync, ReplicationNodeMode.ALWAYS);
        ReliableAsyncKeeperReplicationTargetGroupBuilder targetSyncBackup = new ReliableAsyncKeeperReplicationTargetGroupBuilder();
        TargetGroupConfig targetGroupConfig = new TargetGroupConfig(groupName, this.createProcessLogConfig(replicationPolicy, true, true), ReplicationStatistics.ReplicationMode.BACKUP_SPACE, syncGroupMemberNames.toArray(new String[syncGroupMemberNames.size()]));
        targetSyncBackup.setGroupConfig(targetGroupConfig);
        targetSyncBackup.setProcessLogBuilder(nodeBuilder.getReplicationProcessLogBuilder());
        targetSyncBackup.setFilterBuilder(filterBuilder);
        targetSyncBackup.setLifeCycleBuilder(lifeCycleBuilder);
        replicationNodeConfig.addTargetGroupBuilder(targetSyncBackup, ReplicationNodeMode.PASSIVE);
        this.setReplicationFilters(replicationPolicy, replicationNodeConfig);
        return replicationNodeConfig;
    }

    public GroupConsistencyLevelPolicy getGroupConsistencyLevel(ISpaceReplicationSettings replicationPolicy, List<String> syncGroupMemberNames) {
        ConsistencyLevel consistencyLevel = replicationPolicy.getSyncReplicationSettings().getConsistencyLevel();
        switch (consistencyLevel) {
            case ANY: {
                return GroupConsistencyLevelPolicy.getEmptyPolicy();
            }
            case QUORUM: {
                int groupSize = syncGroupMemberNames.size() + 1;
                int quoromSize = groupSize / 2 + 1;
                if (quoromSize == 1) {
                    return GroupConsistencyLevelPolicy.getEmptyPolicy();
                }
                if (quoromSize == groupSize) {
                    return new SyncMembersInSyncConsistencyLevelPolicy();
                }
                return new SyncMembersInSyncConsistencyLevelPolicy().minNumberOfSyncMembers(quoromSize);
            }
            case ALL: {
                return new SyncMembersInSyncConsistencyLevelPolicy();
            }
        }
        throw new IllegalStateException("unknown consistency level " + (Object)((Object)consistencyLevel));
    }

    public void addKeepersListeners(Map<String, IReplicationChannelDataFilter> filters, DynamicReliableAsyncSourceGroupConfigHolder configHolder) {
        for (IReplicationChannelDataFilter filter : filters.values()) {
            if (!(filter instanceof DynamicSourceGroupConfigHolder.IDynamicSourceGroupStateListener)) continue;
            configHolder.addListener((DynamicSourceGroupConfigHolder.IDynamicSourceGroupStateListener)((Object)filter));
        }
    }

    public void addKeepersFilters(IReliableAsyncReplicationSettings reliableAsyncSettings, String groupName, List<String> groupMemberNames, Map<String, IReplicationChannelDataFilter> filters, boolean requiresEvictionReplicationProtection) {
        if (reliableAsyncSettings.keeperCannotRefillMissingContent()) {
            for (String groupMemberName : groupMemberNames) {
                filters.put(groupMemberName, new ReliableAsyncKeeperLruCentralDataSourceReplicationChannelDataFilter(requiresEvictionReplicationProtection));
            }
        } else {
            this.addGeneralReplicationFilter(groupMemberNames, filters);
        }
    }

    public ReplicationNodeConfig createReliableAsyncSourceWithMirrorConfig(IReliableAsyncReplicationSettings reliableAsyncSettings, IReplicationNodeBuilder nodeBuilder, int partitionId, IReplicationChannelDataFilterBuilder filterBuilder, IDynamicSourceGroupMemberLifeCycleBuilder lifeCycleBuilder, boolean requiresEvictionReplicationProtection) {
        ISpaceReplicationSettings replicationPolicy = reliableAsyncSettings.getSpaceReplicationSettings();
        IMirrorChannelReplicationSettings mirrorPolicy = reliableAsyncSettings.getMirrorReplicationSettings();
        this.validateConfig(replicationPolicy);
        String groupName = this.createReplicationGroupName(partitionId, true, true, true, true);
        ReplicationNodeConfig replicationNodeConfig = new ReplicationNodeConfig();
        replicationNodeConfig.mapSourceGroups("all", GroupMapping.getAllMapping());
        BacklogConfig backlogConfig = this.createBacklogConfig(replicationPolicy, mirrorPolicy, true, true);
        List<String> syncGroupMemberNames = this.createGroupMemberNames(replicationPolicy);
        syncGroupMemberNames.remove(mirrorPolicy.getMirrorMemberName());
        this.configureBacklogLimitations(replicationPolicy, backlogConfig, syncGroupMemberNames);
        LinkedList<String> reliableAsyncMemberNames = new LinkedList<String>();
        reliableAsyncMemberNames.add(mirrorPolicy.getMirrorMemberName());
        this.configureMirrorBacklogLimitations(mirrorPolicy, backlogConfig, reliableAsyncMemberNames);
        HashMap<String, IReplicationChannelDataFilter> filters = new HashMap<String, IReplicationChannelDataFilter>();
        filters.put(mirrorPolicy.getMirrorMemberName(), new MirrorChannelDataFilter(mirrorPolicy));
        Map<String, String[]> membersGrouping = requiresEvictionReplicationProtection ? this.createMembersGroupingForMirror(mirrorPolicy.getMirrorMemberName()) : null;
        this.addKeepersFilters(reliableAsyncSettings, groupName, syncGroupMemberNames, filters, requiresEvictionReplicationProtection);
        GroupConsistencyLevelPolicy groupConsistencyLevelPolicy = this.getGroupConsistencyLevel(replicationPolicy, syncGroupMemberNames);
        ReliableAsyncSourceGroupConfig sourceGroupConfig = new ReliableAsyncSourceGroupConfig(groupName, backlogConfig, groupConsistencyLevelPolicy, filters, null, membersGrouping, syncGroupMemberNames.toArray(new String[syncGroupMemberNames.size()]), reliableAsyncMemberNames.toArray(new String[reliableAsyncMemberNames.size()]), mirrorPolicy.getBatchSize(), reliableAsyncSettings.getReliableAsyncCompletionNotifierInterval(), reliableAsyncSettings.getReliableAsyncCompletionNotifierPacketsThreshold(), reliableAsyncSettings.getSpaceReplicationSettings().isNetworkCompressionEnabled());
        sourceGroupConfig.setChannelConfig(mirrorPolicy.getMirrorMemberName(), new AsyncChannelConfig(mirrorPolicy.getBatchSize(), mirrorPolicy.getIdleDelay(), mirrorPolicy.getOperationsReplicationThreshold(), ReplicationStatistics.ReplicationMode.MIRROR));
        DynamicReliableAsyncSourceGroupConfigHolder configHolder = new DynamicReliableAsyncSourceGroupConfigHolder(sourceGroupConfig);
        this.addKeepersListeners(filters, configHolder);
        ReliableAsyncReplicationSourceGroupBuilder sourceSync = new ReliableAsyncReplicationSourceGroupBuilder(configHolder);
        sourceSync.setAsyncHandlerProvider(nodeBuilder.getAsyncHandlerProvider());
        sourceSync.setAsyncChannelBatchSize(mirrorPolicy.getBatchSize());
        sourceSync.setAsyncChannelIntervalMilis(mirrorPolicy.getIdleDelay());
        sourceSync.setAsyncChannelIntervalOperations(mirrorPolicy.getOperationsReplicationThreshold());
        sourceSync.setSyncChannelAsyncStateBatchSize(replicationPolicy.getBatchSize());
        sourceSync.setSyncChannelIdleDelayMilis(replicationPolicy.getIdleDelay());
        sourceSync.setThrottleController(this.createSyncGroupThrottleController(replicationPolicy));
        sourceSync.setBacklogBuilder(nodeBuilder.getReplicationBacklogBuilder());
        replicationNodeConfig.addSourceGroupBuilder(sourceSync, ReplicationNodeMode.ALWAYS);
        ReliableAsyncKeeperReplicationTargetGroupBuilder targetSyncBackup = new ReliableAsyncKeeperReplicationTargetGroupBuilder();
        TargetGroupConfig targetGroupConfig = new TargetGroupConfig(groupName, this.createProcessLogConfig(replicationPolicy, true, true), ReplicationStatistics.ReplicationMode.BACKUP_SPACE, syncGroupMemberNames.toArray(new String[syncGroupMemberNames.size()]));
        targetSyncBackup.setGroupConfig(targetGroupConfig);
        targetSyncBackup.setProcessLogBuilder(nodeBuilder.getReplicationProcessLogBuilder());
        targetSyncBackup.setLifeCycleBuilder(lifeCycleBuilder);
        targetSyncBackup.setFilterBuilder(filterBuilder);
        replicationNodeConfig.addTargetGroupBuilder(targetSyncBackup, ReplicationNodeMode.PASSIVE);
        this.setReplicationFilters(replicationPolicy, replicationNodeConfig);
        return replicationNodeConfig;
    }

    public Map<String, String[]> createMembersGroupingForMirror(String mirrorMemberName) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put(PERSISTENCY_GROUPING_NAME, new String[]{mirrorMemberName});
        return map;
    }

    private void addGeneralReplicationFilter(List<String> groupMemberNames, Map<String, IReplicationChannelDataFilter> filters) {
        for (String groupMemberName : groupMemberNames) {
            filters.put(groupMemberName, GeneralReplicationChannelDataFilter.getInstance());
        }
    }

    public void validateConfig(ISpaceReplicationSettings replicationPolicy) {
        if (replicationPolicy.getMaxRedoLogCapacityDuringRecovery() != -1L && (replicationPolicy.getMaxRedoLogCapacityDuringRecovery() < replicationPolicy.getMaxRedoLogCapacity() || replicationPolicy.getMaxRedoLogCapacity() == -1L)) {
            throw new IllegalArgumentException("'cluster-config.groups.group.repl-policy.redo-log-recovery-capacity=" + this.getCapacityDisplayStr(replicationPolicy.getMaxRedoLogCapacityDuringRecovery()) + "' cannot be less than the 'cluster-config.groups.group.repl-policy.redo-log-capacity=" + this.getCapacityDisplayStr(replicationPolicy.getMaxRedoLogCapacity()) + "'");
        }
    }

    public ReplicationNodeConfig createSourceWithMirrorConfig(MirrorReplicationSettingsAdapter mirrorPolicy, ISpaceReplicationSettings replicationPolicy, IReplicationNodeBuilder nodeBuilder, int partitionId, boolean requiresEvictionReplicationProtection) {
        String groupName = this.createReplicationGroupName(partitionId, false, true, true, true);
        this.validateConfig(replicationPolicy);
        ReplicationNodeConfig replicationNodeConfig = new ReplicationNodeConfig();
        replicationNodeConfig.mapSourceGroups("all", GroupMapping.getAllMapping());
        BacklogConfig backlogConfig = this.createBacklogConfig(replicationPolicy, mirrorPolicy, false, false);
        LinkedList<String> mirrorMembersNames = new LinkedList<String>();
        mirrorMembersNames.add(mirrorPolicy.getMirrorMemberName());
        this.configureMirrorBacklogLimitations(mirrorPolicy, backlogConfig, mirrorMembersNames);
        Map<String, String[]> membersGrouping = requiresEvictionReplicationProtection ? this.createMembersGroupingForMirror(mirrorPolicy.getMirrorMemberName()) : null;
        HashMap<String, IReplicationChannelDataFilter> filters = new HashMap<String, IReplicationChannelDataFilter>();
        filters.put(mirrorPolicy.getMirrorMemberName(), new MirrorChannelDataFilter(mirrorPolicy));
        AsyncSourceGroupConfig sourceGroupConfig = new AsyncSourceGroupConfig(groupName, backlogConfig, null, filters, null, membersGrouping, replicationPolicy.isNetworkCompressionEnabled(), mirrorMembersNames.toArray(new String[mirrorMembersNames.size()]));
        DynamicAsyncSourceGroupConfigHolder configHolder = new DynamicAsyncSourceGroupConfigHolder(sourceGroupConfig);
        AsyncReplicationSourceGroupBuilder sourceBuilder = new AsyncReplicationSourceGroupBuilder(configHolder);
        sourceGroupConfig.setChannelConfig(mirrorPolicy.getMirrorMemberName(), new AsyncChannelConfig(mirrorPolicy.getBatchSize(), mirrorPolicy.getIdleDelay(), mirrorPolicy.getOperationsReplicationThreshold(), ReplicationStatistics.ReplicationMode.MIRROR));
        sourceBuilder.setAsyncHandlerProvider(nodeBuilder.getAsyncHandlerProvider());
        sourceBuilder.setBatchSize(mirrorPolicy.getBatchSize());
        sourceBuilder.setIntervalMilis(mirrorPolicy.getIdleDelay());
        sourceBuilder.setIntervalOperations(mirrorPolicy.getOperationsReplicationThreshold());
        sourceBuilder.setBacklogBuilder(nodeBuilder.getReplicationBacklogBuilder());
        replicationNodeConfig.addSourceGroupBuilder(sourceBuilder, ReplicationNodeMode.ACTIVE);
        this.setReplicationFilters(replicationPolicy, replicationNodeConfig);
        return replicationNodeConfig;
    }

    public ReplicationNodeConfig createMirrorConfig(MirrorConfig mirrorConfig, ReplicationNodeBuilder nodeBuilder) {
        return this.createMirrorConfig(mirrorConfig.getClusterName(), nodeBuilder, mirrorConfig.getPartitionsCount(), mirrorConfig.getBackupsPerPartition());
    }

    public ReplicationNodeConfig createMirrorConfig(String spaceName, ReplicationNodeBuilder nodeBuilder, int partitions, int backups) {
        ReplicationNodeConfig replicationNodeConfig = new ReplicationNodeConfig();
        for (int i = 0; i < partitions; ++i) {
            String groupNameTemplate;
            String withGatewaysMatchingTemplate;
            String withoutGatewayMatchinTemplate;
            int partitionId = i + 1;
            if (backups > 0) {
                withoutGatewayMatchinTemplate = PRIMARY_BACKUP_RELIABLE_ASYNC + partitionId;
                withGatewaysMatchingTemplate = "(.*):" + spaceName + ":" + PRIMARY_BACKUP_RELIABLE_ASYNC + partitionId;
                groupNameTemplate = "(" + withoutGatewayMatchinTemplate + ")|(" + withGatewaysMatchingTemplate + ")";
            } else {
                withoutGatewayMatchinTemplate = ASYNC_MIRROR + partitionId;
                withGatewaysMatchingTemplate = "(.*):" + spaceName + ":" + ASYNC_MIRROR + partitionId;
                groupNameTemplate = "(" + withoutGatewayMatchinTemplate + ")|(" + withGatewaysMatchingTemplate + ")";
            }
            LinkedList<String> groupMemberNames = new LinkedList<String>();
            boolean hasSourceClusterName = StringUtils.hasLength(spaceName);
            if (hasSourceClusterName) {
                String primaryMemberName = spaceName + "_container" + partitionId + ":" + spaceName;
                groupMemberNames.add(primaryMemberName);
                for (int j = 0; j < backups; ++j) {
                    int backupId = j + 1;
                    String backupMemberName = spaceName + "_container" + partitionId + "_" + backupId + ":" + spaceName;
                    groupMemberNames.add(backupMemberName);
                }
            }
            TargetGroupConfig targetGroupConfig = new TargetGroupConfig("NOT SET", null, ReplicationStatistics.ReplicationMode.MIRROR, groupMemberNames.toArray(new String[groupMemberNames.size()]));
            if (!hasSourceClusterName) {
                targetGroupConfig.setUnbounded(true);
            }
            ReliableAsyncSingleOriginReplicationTargetGroupBuilder mirrorGroupBuilder = new ReliableAsyncSingleOriginReplicationTargetGroupBuilder(targetGroupConfig);
            mirrorGroupBuilder.setGroupNameTemplate(groupNameTemplate);
            mirrorGroupBuilder.setProcessLogBuilder(nodeBuilder.getReplicationProcessLogBuilder());
            replicationNodeConfig.addDynamicTargetGroupBuilder(mirrorGroupBuilder, ReplicationNodeMode.ACTIVE);
        }
        return replicationNodeConfig;
    }

    public ReplicationNodeConfig createLocalViewConfig(String spaceName, SpaceClusterInfo clusterInfo, ReplicationNodeBuilder nodeBuilder, int partitions) {
        if (!clusterInfo.isReplicated()) {
            throw new UnsupportedOperationException("LocalView on a non-replicated space is currently not supported.");
        }
        ReplicationNodeConfig replicationNodeConfig = new ReplicationNodeConfig();
        for (int i = 0; i < partitions; ++i) {
            this.createClientSideReplicationTargetGroupConfig(spaceName, clusterInfo, nodeBuilder, replicationNodeConfig, i, ReplicationStatistics.ReplicationMode.LOCAL_VIEW);
        }
        return replicationNodeConfig;
    }

    public ReplicationNodeConfig createNotificationConfig(String spaceName, SpaceClusterInfo clusterInfo, ReplicationNodeBuilder nodeBuilder, int partitionIndex, int numOfPartitions) {
        int startIndex = partitionIndex == -1 ? 0 : partitionIndex;
        int endIndex = partitionIndex == -1 ? numOfPartitions : partitionIndex + 1;
        ReplicationNodeConfig replicationNodeConfig = new ReplicationNodeConfig();
        for (int i = startIndex; i < endIndex; ++i) {
            this.createClientSideReplicationTargetGroupConfig(spaceName, clusterInfo, nodeBuilder, replicationNodeConfig, i, ReplicationStatistics.ReplicationMode.DURABLE_NOTIFICATION);
        }
        return replicationNodeConfig;
    }

    private void createClientSideReplicationTargetGroupConfig(String spaceName, SpaceClusterInfo clusterInfo, ReplicationNodeBuilder nodeBuilder, ReplicationNodeConfig replicationNodeConfig, int partitionIndex, ReplicationStatistics.ReplicationMode groupChannelType) {
        int partitionId = partitionIndex + 1;
        String groupName = this.createReplicationGroupName(partitionId, spaceName, clusterInfo, clusterInfo.getNumberOfBackups() > 0);
        LinkedList<String> groupMemberNames = new LinkedList<String>();
        String primaryMemberName = spaceName + "_container" + partitionId + ":" + spaceName;
        groupMemberNames.add(primaryMemberName);
        for (int j = 0; j < clusterInfo.getNumberOfBackups(); ++j) {
            int backupId = j + 1;
            String backupMemberName = spaceName + "_container" + partitionId + "_" + backupId + ":" + spaceName;
            groupMemberNames.add(backupMemberName);
        }
        TargetGroupConfig targetGroupConfig = new TargetGroupConfig(groupName, null, groupChannelType, groupMemberNames.toArray(new String[groupMemberNames.size()]));
        ReliableAsyncSingleOriginReplicationTargetGroupBuilder groupBuilder = new ReliableAsyncSingleOriginReplicationTargetGroupBuilder(targetGroupConfig);
        groupBuilder.setProcessLogBuilder(nodeBuilder.getReplicationProcessLogBuilder());
        replicationNodeConfig.addTargetGroupBuilder(groupBuilder, ReplicationNodeMode.ACTIVE);
    }

    public String getSynchronizeGroupName(SpaceClusterInfo clusterInfo, int partitionId, String spaceMemberName) {
        return this.createReplicationGroupName(partitionId, spaceMemberName, clusterInfo, clusterInfo.isPrimaryElectionAvailable());
    }

    public String createReplicationGroupName(int partitionId, boolean primaryBackupGroup, boolean syncReplication, boolean hasMirror, boolean hasExistingReplicationMembers) {
        if (hasMirror) {
            return primaryBackupGroup ? PRIMARY_BACKUP_RELIABLE_ASYNC + partitionId : ASYNC_MIRROR + partitionId;
        }
        if (primaryBackupGroup || !hasExistingReplicationMembers) {
            return (syncReplication ? PRIMARY_BACKUP_SYNC : PRIMARY_BACKUP_ASYNC) + "-" + partitionId;
        }
        return syncReplication ? SYNC : ASYNC;
    }

    public String createReplicationGroupName(int partitionId, String spaceMemberName, SpaceClusterInfo clusterInfo, boolean primaryBackupGroup) {
        return this.createReplicationGroupName(partitionId, primaryBackupGroup, clusterInfo.isSyncReplicationEnabled(), clusterInfo.isMirrorServiceEnabled(), clusterInfo.hasReplicationTargets());
    }

    public void configureBacklogLimitations(ISpaceReplicationSettings replicationPolicy, BacklogConfig backlogConfig, List<String> groupMemberNames) {
        long nonMirrorMaxRedoLogCapacity = replicationPolicy.getMaxRedoLogCapacity();
        for (String memberName : groupMemberNames) {
            BacklogMemberLimitationConfig memberLimitationConfig = new BacklogMemberLimitationConfig();
            if (nonMirrorMaxRedoLogCapacity == -1L) {
                memberLimitationConfig.setUnlimited();
            } else {
                BacklogConfig.LimitReachedPolicy limitReachedPolicy = replicationPolicy.getLimitReachedPolicy();
                memberLimitationConfig.setLimit(nonMirrorMaxRedoLogCapacity, limitReachedPolicy);
                long maxRedoLogCapacityDuringRecovery = replicationPolicy.getMaxRedoLogCapacityDuringRecovery();
                if (maxRedoLogCapacityDuringRecovery == -1L) {
                    memberLimitationConfig.setUnlimitedDuringSynchronization();
                } else {
                    memberLimitationConfig.setLimitDuringSynchronization(maxRedoLogCapacityDuringRecovery, BacklogConfig.LimitReachedPolicy.BLOCK_NEW);
                }
            }
            backlogConfig.setMemberBacklogLimitation(memberName, memberLimitationConfig);
        }
    }

    public void configureMirrorBacklogLimitations(IReplicationSettings mirrorSettings, BacklogConfig backlogConfig, List<String> mirrorMembersNames) {
        long mirrorMaxRedoLogCapacity = mirrorSettings.getMaxRedoLogCapacity();
        for (String memberName : mirrorMembersNames) {
            BacklogMemberLimitationConfig memberLimitationConfig = new BacklogMemberLimitationConfig();
            if (mirrorMaxRedoLogCapacity == -1L) {
                memberLimitationConfig.setUnlimited();
            } else {
                memberLimitationConfig.setLimit(mirrorMaxRedoLogCapacity, mirrorSettings.getLimitReachedPolicy());
            }
            backlogConfig.setMemberBacklogLimitation(memberName, memberLimitationConfig);
        }
    }

    private void configureAsyncReplicatedTargetGroup(ISpaceReplicationSettings replicationPolicy, IReplicationNodeBuilder nodeBuilder, ReplicationNodeConfig replicationNodeConfig, List<String> groupMemberNames, String groupName) {
        AsyncMultiOriginReplicationTargetGroupBuilder targetAsyncGroup = new AsyncMultiOriginReplicationTargetGroupBuilder();
        TargetGroupConfig targetGroupConfig = new TargetGroupConfig(groupName, this.createProcessLogConfig(replicationPolicy, false, false), ReplicationStatistics.ReplicationMode.ACTIVE_SPACE, groupMemberNames.toArray(new String[groupMemberNames.size()]));
        targetAsyncGroup.setGroupConfig(targetGroupConfig);
        targetAsyncGroup.setProcessLogBuilder(nodeBuilder.getReplicationProcessLogBuilder());
        replicationNodeConfig.addTargetGroupBuilder(targetAsyncGroup, ReplicationNodeMode.ACTIVE);
    }

    private void configureSyncReplicatedTargetGroup(ISpaceReplicationSettings replicationPolicy, IReplicationNodeBuilder nodeBuilder, ReplicationNodeConfig replicationNodeConfig, List<String> groupMemberNames, String groupName, boolean supportConcurrent) {
        SyncMultiOriginReplicationTargetGroupBuilder targetSync = new SyncMultiOriginReplicationTargetGroupBuilder();
        TargetGroupConfig targetGroupConfig = new TargetGroupConfig(groupName, this.createProcessLogConfig(replicationPolicy, supportConcurrent, false), ReplicationStatistics.ReplicationMode.ACTIVE_SPACE, groupMemberNames.toArray(new String[groupMemberNames.size()]));
        targetSync.setGroupConfig(targetGroupConfig);
        targetSync.setProcessLogBuilder(nodeBuilder.getReplicationProcessLogBuilder());
        replicationNodeConfig.addTargetGroupBuilder(targetSync, ReplicationNodeMode.ACTIVE);
    }

    private void configureSyncPrimaryBackupTargetGroup(ISpaceReplicationSettings replicationPolicy, IReplicationNodeBuilder nodeBuilder, ReplicationNodeConfig replicationNodeConfig, List<String> groupMemberNames, String groupName, boolean supportConcurrent, boolean supportsMultiSource) {
        SyncSingleOriginReplicationTargetGroupBuilder targetSyncBackup = new SyncSingleOriginReplicationTargetGroupBuilder();
        TargetGroupConfig targetGroupConfig = new TargetGroupConfig(groupName, this.createProcessLogConfig(replicationPolicy, supportConcurrent, supportsMultiSource), ReplicationStatistics.ReplicationMode.BACKUP_SPACE, groupMemberNames.toArray(new String[groupMemberNames.size()]));
        targetSyncBackup.setGroupConfig(targetGroupConfig);
        targetSyncBackup.setProcessLogBuilder(nodeBuilder.getReplicationProcessLogBuilder());
        replicationNodeConfig.addTargetGroupBuilder(targetSyncBackup, ReplicationNodeMode.PASSIVE);
    }

    private void configureAsyncPrimaryBackupTargetGroup(ISpaceReplicationSettings replicationPolicy, IReplicationNodeBuilder nodeBuilder, ReplicationNodeConfig replicationNodeConfig, List<String> groupMemberNames, String groupName) {
        TargetGroupConfig targetGroupConfig = new TargetGroupConfig(groupName, this.createProcessLogConfig(replicationPolicy, false, false), ReplicationStatistics.ReplicationMode.BACKUP_SPACE, groupMemberNames.toArray(new String[groupMemberNames.size()]));
        AsyncSingleOriginReplicationTargetGroupBuilder targetAsyncBackup = new AsyncSingleOriginReplicationTargetGroupBuilder(targetGroupConfig);
        targetAsyncBackup.setProcessLogBuilder(nodeBuilder.getReplicationProcessLogBuilder());
        replicationNodeConfig.addTargetGroupBuilder(targetAsyncBackup, ReplicationNodeMode.PASSIVE);
    }

    public ProcessLogConfig createProcessLogConfig(ISpaceReplicationSettings replicationPolicy, boolean supportsConcurrentReplication, boolean supportsMultiSource) {
        if (replicationPolicy.getProcessingType() == ReplicationProcessingType.MULTIPLE_BUCKETS && supportsConcurrentReplication) {
            MultiBucketSingleFileProcessLogConfig config = new MultiBucketSingleFileProcessLogConfig();
            config.setBucketsCount(replicationPolicy.getBucketCount());
            config.setBatchProcessingThreshold(replicationPolicy.getBatchParallelThreshold());
            config.setBatchParallelFactor(replicationPolicy.getBatchParallelFactor());
            config.setConsumeTimeout(replicationPolicy.getConsumeTimeout());
            return config;
        }
        if (replicationPolicy.getProcessingType() == ReplicationProcessingType.MULTIPLE_SOURCES && supportsMultiSource) {
            MultiSourceSingleFileProcessLogConfig config = new MultiSourceSingleFileProcessLogConfig();
            config.setConsumeTimeout(replicationPolicy.getConsumeTimeout());
            return config;
        }
        GlobalOrderProcessLogConfig config = new GlobalOrderProcessLogConfig();
        config.setConsumeTimeout(replicationPolicy.getConsumeTimeout());
        return config;
    }

    public void setReplicationFilters(IReplicationSettings replicationPolicy, ReplicationNodeConfig replicationNodeConfig) {
        replicationNodeConfig.setReplicationInFilter(replicationPolicy.getInFilter());
        replicationNodeConfig.setSpaceCopyReplicaInFilter(replicationPolicy.getSpaceCopyInFilter());
        replicationNodeConfig.setReplicationOutFilter(replicationPolicy.getOutFilter());
        replicationNodeConfig.setSpaceCopyReplicaOutFilter(replicationPolicy.getSpaceCopyOutFilter());
    }

    public String supportsMultiSourceReplication(SpaceClusterInfo clusterInfo) {
        boolean primaryBackupGroup = clusterInfo.isPrimaryElectionAvailable();
        boolean hasMirror = clusterInfo.isMirrorServiceEnabled();
        boolean hasExistingReplicationMembers = clusterInfo.hasReplicationTargets();
        if (!hasMirror && !primaryBackupGroup && hasExistingReplicationMembers) {
            boolean syncReplication = clusterInfo.isSyncReplicationEnabled();
            return (syncReplication ? "Sync" : "Async") + " replication is not supported in Multiple sources replication processing";
        }
        return null;
    }
}

