/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.config;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.ConsistencyLevel;
import com.gigaspaces.cluster.replication.sync.SyncReplPolicy;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.config.IReplicationSettings;
import com.gigaspaces.internal.cluster.node.impl.config.ISyncReplicationSettings;
import com.gigaspaces.internal.cluster.node.impl.config.MultiBucketReplicationPolicy;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilter;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationOutFilter;
import com.gigaspaces.internal.cluster.node.impl.filters.ISpaceCopyReplicaInFilter;
import com.gigaspaces.internal.cluster.node.impl.filters.ISpaceCopyReplicaOutFilter;
import com.j_spaces.core.cluster.RedoLogCompaction;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.core.cluster.ReplicationProcessingType;
import com.j_spaces.core.cluster.SwapBacklogConfig;

@InternalApi
public class ReplicationSettings
implements IReplicationSettings,
ISyncReplicationSettings {
    private int operationsReplicationThreshold = 500;
    private int batchSize = 500;
    private long idleDelay = 3000L;
    private BacklogConfig.LimitReachedPolicy limitReachedPolicy = BacklogConfig.LimitReachedPolicy.BLOCK_NEW;
    private long maxRedoLogCapacity = -1L;
    private long maxRedoLogCapacityDuringRecovery = -1L;
    private long maxRedoLogMemoryCapacity = -1L;
    private boolean isNetworkCompressionEnabled = true;
    private IReplicationInFilter inFilter;
    private IReplicationOutFilter outFilter;
    private ISpaceCopyReplicaInFilter spaceCopyInFilter;
    private ISpaceCopyReplicaOutFilter spaceCopyOutFilter;
    private boolean isOneWay;
    private boolean throttleWhenInactive = true;
    private int maxThrottleTPWhenInactive = 50000;
    private int minThrottleTPWhenActive = 1000;
    private ReplicationProcessingType processingType = ReplicationPolicy.DEFAULT_PROCESSING_TYPE;
    private short bucketCount = (short)1024;
    private Integer batchParallelFactor = MultiBucketReplicationPolicy.DEFAULT_BATCH_PARALLEL_FACTOR;
    private int batchParallelThreshold = 50;
    private long consumeTimeout = 10000L;
    private SwapBacklogConfig swapBacklogSettings = new SwapBacklogConfig();
    private ConsistencyLevel consistencyLevel = SyncReplPolicy.DEFAULT_CONSISTENCY_LEVEL;
    private String backlogWeightPolicy = "accumulated";
    private RedoLogCompaction redoLogCompaction = ReplicationPolicy.DEFAULT_REDO_LOG_COMPACTION;

    @Override
    public int getOperationsReplicationThreshold() {
        return this.operationsReplicationThreshold;
    }

    public void setOperationsReplicationThreshold(int operationsReplicationThreshold) {
        this.operationsReplicationThreshold = operationsReplicationThreshold;
    }

    @Override
    public long getIdleDelay() {
        return this.idleDelay;
    }

    public void setIdleDelay(long replicationInterval) {
        this.idleDelay = replicationInterval;
    }

    @Override
    public BacklogConfig.LimitReachedPolicy getLimitReachedPolicy() {
        return this.limitReachedPolicy;
    }

    public void setLimitReachedPolicy(BacklogConfig.LimitReachedPolicy limitReachedPloicy) {
        this.limitReachedPolicy = limitReachedPloicy;
    }

    @Override
    public long getMaxRedoLogCapacity() {
        return this.maxRedoLogCapacity;
    }

    public void setMaxRedoLogCapacity(long maxRedoLogCapacity) {
        this.maxRedoLogCapacity = maxRedoLogCapacity;
    }

    public long getMaxRedoLogCapacityDuringRecovery() {
        return this.maxRedoLogCapacityDuringRecovery;
    }

    public void setMaxRedoLogCapacityDuringRecovery(long maxRedoLogCapacityDuringRecovery) {
        this.maxRedoLogCapacityDuringRecovery = maxRedoLogCapacityDuringRecovery;
    }

    public long getMaxRedoLogMemoryCapacity() {
        return this.maxRedoLogMemoryCapacity;
    }

    public void setMaxRedoLogMemoryCapacity(long maxRedoLogMemoryCapacity) {
        this.maxRedoLogMemoryCapacity = maxRedoLogMemoryCapacity;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isOneWay() {
        return this.isOneWay;
    }

    public void setOneWay(boolean isOneWay) {
        this.isOneWay = isOneWay;
    }

    @Override
    public IReplicationInFilter getInFilter() {
        return this.inFilter;
    }

    @Override
    public IReplicationOutFilter getOutFilter() {
        return this.outFilter;
    }

    @Override
    public ISpaceCopyReplicaInFilter getSpaceCopyInFilter() {
        return this.spaceCopyInFilter;
    }

    @Override
    public ISpaceCopyReplicaOutFilter getSpaceCopyOutFilter() {
        return this.spaceCopyOutFilter;
    }

    @Override
    public ISyncReplicationSettings getSyncReplicationSettings() {
        return this;
    }

    @Override
    public boolean isThrottleWhenInactive() {
        return this.throttleWhenInactive;
    }

    public void setThrottleWhenInactive(boolean throttleWhenInactive) {
        this.throttleWhenInactive = throttleWhenInactive;
    }

    @Override
    public int getMaxThrottleTPWhenInactive() {
        return this.maxThrottleTPWhenInactive;
    }

    public void setMaxThrottleTPWhenInactive(int maxThrottleTPWhenInactive) {
        this.maxThrottleTPWhenInactive = maxThrottleTPWhenInactive;
    }

    @Override
    public int getMinThrottleTPWhenActive() {
        return this.minThrottleTPWhenActive;
    }

    public void setMinThrottleTPWhenActive(int minThrottleTPWhenActive) {
        this.minThrottleTPWhenActive = minThrottleTPWhenActive;
    }

    public void setProcessindType(ReplicationProcessingType processindType) {
        this.processingType = processindType;
    }

    @Override
    public ReplicationProcessingType getProcessingType() {
        return this.processingType;
    }

    public void setBucketCount(short bucketCount) {
        this.bucketCount = bucketCount;
    }

    @Override
    public short getBucketCount() {
        return this.bucketCount;
    }

    public void setBatchParallelFactor(int batchParallelFactor) {
        this.batchParallelFactor = batchParallelFactor;
    }

    @Override
    public int getBatchParallelFactor() {
        if (this.batchParallelFactor == null) {
            return Runtime.getRuntime().availableProcessors();
        }
        return this.batchParallelFactor;
    }

    public void setBatchParallelThreshold(int batchParallelThreshold) {
        this.batchParallelThreshold = batchParallelThreshold;
    }

    @Override
    public int getBatchParallelThreshold() {
        return this.batchParallelThreshold;
    }

    @Override
    public long getConsumeTimeout() {
        return this.consumeTimeout;
    }

    public void setConsumeTimeout(long consumeTimeout) {
        this.consumeTimeout = consumeTimeout;
    }

    @Override
    public SwapBacklogConfig getSwapBacklogSettings() {
        return this.swapBacklogSettings;
    }

    @Override
    public String getBacklogWeightPolicy() {
        return this.backlogWeightPolicy;
    }

    @Override
    public RedoLogCompaction getRedoLogCompaction() {
        return this.redoLogCompaction;
    }

    @Override
    public boolean isNetworkCompressionEnabled() {
        return this.isNetworkCompressionEnabled;
    }

    public void setRedoLogCompaction(RedoLogCompaction redoLogCompaction) {
        this.redoLogCompaction = redoLogCompaction;
    }

    public void setBacklogWeightPolicy(String backlogWeightPolicy) {
        this.backlogWeightPolicy = backlogWeightPolicy;
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }
}

