/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.config;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.ConsistencyLevel;
import com.gigaspaces.cluster.replication.ReplicationFilterManager;
import com.gigaspaces.cluster.replication.sync.SyncReplPolicy;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.config.ISpaceReplicationSettings;
import com.gigaspaces.internal.cluster.node.impl.config.ISyncReplicationSettings;
import com.gigaspaces.internal.cluster.node.impl.config.MultiBucketReplicationPolicy;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilter;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationOutFilter;
import com.gigaspaces.internal.cluster.node.impl.filters.ISpaceCopyReplicaInFilter;
import com.gigaspaces.internal.cluster.node.impl.filters.ISpaceCopyReplicaOutFilter;
import com.gigaspaces.internal.cluster.node.impl.filters.ReplicationInFilterAdapter;
import com.gigaspaces.internal.cluster.node.impl.filters.ReplicationOutFilterAdapter;
import com.j_spaces.core.cluster.MissingPacketsPolicy;
import com.j_spaces.core.cluster.RedoLogCapacityExceededPolicy;
import com.j_spaces.core.cluster.RedoLogCompaction;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.core.cluster.ReplicationProcessingType;
import com.j_spaces.core.cluster.SwapBacklogConfig;
import java.util.List;

@InternalApi
public class ReplicationSettingsAdapter
implements ISpaceReplicationSettings,
ISyncReplicationSettings {
    private final ReplicationPolicy _policy;
    private final ReplicationFilterManager _filterManager;

    public ReplicationSettingsAdapter(ReplicationPolicy policy, ReplicationFilterManager filterManager) {
        this._policy = policy;
        this._filterManager = filterManager;
    }

    @Override
    public String getSpaceMemberName() {
        return this._policy.m_OwnMemberName;
    }

    @Override
    public List<String> getGroupMemberNames() {
        return this._policy.m_ReplicationGroupMembersNames;
    }

    @Override
    public long getIdleDelay() {
        return this._policy.m_ReplicationIntervalMillis;
    }

    @Override
    public int getOperationsReplicationThreshold() {
        return this._policy.m_ReplicationChunkSize;
    }

    @Override
    public BacklogConfig.LimitReachedPolicy getLimitReachedPolicy() {
        BacklogConfig.LimitReachedPolicy limitReachedPolicy = this._policy.getOnRedoLogCapacityExceeded() == RedoLogCapacityExceededPolicy.BLOCK_OPERATIONS ? BacklogConfig.LimitReachedPolicy.BLOCK_NEW : (this._policy.getOnMissingPackets() == MissingPacketsPolicy.RECOVER ? BacklogConfig.LimitReachedPolicy.DROP_UNTIL_RESYNC : BacklogConfig.LimitReachedPolicy.DROP_OLDEST);
        return limitReachedPolicy;
    }

    @Override
    public long getMaxRedoLogCapacity() {
        return this._policy.getMaxRedoLogCapacity();
    }

    @Override
    public long getMaxRedoLogCapacityDuringRecovery() {
        return this._policy.getMaxRedoLogRecoveryCapacity();
    }

    @Override
    public long getMaxRedoLogMemoryCapacity() {
        return this._policy.getMaxRedoLogMemoryCapacity();
    }

    @Override
    public RedoLogCompaction getRedoLogCompaction() {
        return this._policy.getRedoLogCompaction();
    }

    @Override
    public boolean isNetworkCompressionEnabled() {
        return this._policy.isNetworkCompressionEnabled();
    }

    @Override
    public String getBacklogWeightPolicy() {
        return this._policy.getBacklogWeightPolicy();
    }

    public boolean isReliableAsyncRepl() {
        return this._policy.isReliableAsyncRepl();
    }

    public boolean isMirrorServiceEnabled() {
        return this._policy.isMirrorServiceEnabled();
    }

    public boolean isSync() {
        return this._policy.m_IsSyncReplicationEnabled;
    }

    @Override
    public int getBatchSize() {
        return this._policy.m_ReplicationChunkSize;
    }

    public boolean isOneWay() {
        return this._policy.isOneWayReplication;
    }

    @Override
    public IReplicationOutFilter getOutFilter() {
        return this._filterManager.getOutputFilter() != null ? new ReplicationOutFilterAdapter(this._filterManager) : null;
    }

    @Override
    public IReplicationInFilter getInFilter() {
        return this._filterManager.getInputFilter() != null ? new ReplicationInFilterAdapter(this._filterManager) : null;
    }

    @Override
    public ISpaceCopyReplicaOutFilter getSpaceCopyOutFilter() {
        return this._filterManager.getOutputFilter() != null ? new ReplicationOutFilterAdapter(this._filterManager) : null;
    }

    @Override
    public ISpaceCopyReplicaInFilter getSpaceCopyInFilter() {
        return this._filterManager.getInputFilter() != null ? new ReplicationInFilterAdapter(this._filterManager) : null;
    }

    @Override
    public ISyncReplicationSettings getSyncReplicationSettings() {
        return this;
    }

    @Override
    public boolean isThrottleWhenInactive() {
        SyncReplPolicy syncReplPolicy = this._policy.m_SyncReplPolicy;
        if (syncReplPolicy != null) {
            return syncReplPolicy.isThrottleWhenInactive();
        }
        return true;
    }

    @Override
    public int getMaxThrottleTPWhenInactive() {
        SyncReplPolicy syncReplPolicy = this._policy.m_SyncReplPolicy;
        if (syncReplPolicy != null) {
            return syncReplPolicy.getMaxThrottleTPWhenInactive();
        }
        return 50000;
    }

    @Override
    public int getMinThrottleTPWhenActive() {
        SyncReplPolicy syncReplPolicy = this._policy.m_SyncReplPolicy;
        if (syncReplPolicy != null) {
            return syncReplPolicy.getMinThrottleTPWhenActive();
        }
        return 1000;
    }

    @Override
    public ReplicationProcessingType getProcessingType() {
        return this._policy.getProcessingType();
    }

    @Override
    public short getBucketCount() {
        MultiBucketReplicationPolicy multiBucketReplicationPolicy = this._policy.getMultiBucketReplicationPolicy();
        if (multiBucketReplicationPolicy != null) {
            return multiBucketReplicationPolicy.getBucketCount();
        }
        return 1024;
    }

    @Override
    public int getBatchParallelFactor() {
        MultiBucketReplicationPolicy multiBucketReplicationPolicy = this._policy.getMultiBucketReplicationPolicy();
        if (multiBucketReplicationPolicy != null && multiBucketReplicationPolicy.getBatchParallelFactor() != null) {
            return multiBucketReplicationPolicy.getBatchParallelFactor();
        }
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int getBatchParallelThreshold() {
        MultiBucketReplicationPolicy multiBucketReplicationPolicy = this._policy.getMultiBucketReplicationPolicy();
        if (multiBucketReplicationPolicy != null) {
            return multiBucketReplicationPolicy.getBucketCount();
        }
        return 1024;
    }

    @Override
    public long getConsumeTimeout() {
        if (this._policy.m_SyncReplPolicy == null) {
            return 10000L;
        }
        return this._policy.m_SyncReplPolicy.getTargetConsumeTimeout();
    }

    @Override
    public SwapBacklogConfig getSwapBacklogSettings() {
        return this._policy.getSwapRedologPolicy();
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        if (this._policy.m_SyncReplPolicy == null) {
            return SyncReplPolicy.DEFAULT_CONSISTENCY_LEVEL;
        }
        return this._policy.m_SyncReplPolicy.getConsistencyLevel();
    }
}

