/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.config;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupMemberLifeCycle;
import com.gigaspaces.internal.cluster.node.impl.config.GroupConfig;
import com.gigaspaces.internal.cluster.node.impl.config.SourceChannelConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.consistencylevel.GroupConsistencyLevelPolicy;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class SourceGroupConfig<T extends SourceChannelConfig>
extends GroupConfig {
    private final BacklogConfig _backlogConfig;
    private final Map<String, IReplicationChannelDataFilter> _filters;
    private final Map<String, T> _channelsConfig;
    private final Map<String, DynamicSourceGroupMemberLifeCycle> _lifeCycles;
    private final Map<String, String[]> _membersGrouping;
    private final GroupConsistencyLevelPolicy _groupConsistencyLevelPolicy;
    private long _inconsistentStateDelay = 5000L;
    private int _inconsistentStateRetries = 1;

    public SourceGroupConfig(String groupName, BacklogConfig backlogConfig, String ... membersLookupNames) {
        this(groupName, backlogConfig, null, new HashMap<String, IReplicationChannelDataFilter>(), new HashMap<String, DynamicSourceGroupMemberLifeCycle>(), new HashMap<String, String[]>(), true, membersLookupNames);
    }

    public SourceGroupConfig(String groupName, BacklogConfig backlogConfig, boolean enableNetworkCompression, String ... membersLookupNames) {
        this(groupName, backlogConfig, null, new HashMap<String, IReplicationChannelDataFilter>(), new HashMap<String, DynamicSourceGroupMemberLifeCycle>(), new HashMap<String, String[]>(), enableNetworkCompression, membersLookupNames);
    }

    public SourceGroupConfig(String groupName, BacklogConfig backlogConfig, GroupConsistencyLevelPolicy groupConsistencyLevelPolicy, Map<String, IReplicationChannelDataFilter> filters, Map<String, DynamicSourceGroupMemberLifeCycle> lifeCycles, Map<String, String[]> membersGrouping, boolean enableNetworkCompression, String ... membersLookupNames) {
        super(groupName, enableNetworkCompression, membersLookupNames);
        this._backlogConfig = backlogConfig;
        this._groupConsistencyLevelPolicy = groupConsistencyLevelPolicy;
        this._lifeCycles = lifeCycles == null ? new HashMap() : lifeCycles;
        this._filters = filters == null ? new HashMap() : filters;
        this._membersGrouping = membersGrouping == null ? new HashMap() : membersGrouping;
        this._channelsConfig = new HashMap<String, T>();
    }

    public BacklogConfig getBacklogConfig() {
        return this._backlogConfig;
    }

    public IReplicationChannelDataFilter getFilter(String memberLookupName) {
        if (this._filters == null || !this._filters.containsKey(memberLookupName)) {
            return null;
        }
        return this._filters.get(memberLookupName);
    }

    public Map<String, IReplicationChannelDataFilter> getFilters() {
        return this._filters;
    }

    public long getInconsistentStateDelay() {
        return this._inconsistentStateDelay;
    }

    public void setInconsistentStateDelay(long inconsistentStateDelay) {
        this._inconsistentStateDelay = inconsistentStateDelay;
    }

    public int getInconsistentStateRetries() {
        return this._inconsistentStateRetries;
    }

    public void setInconsistentStateRetries(int inconsistentStateRetries) {
        this._inconsistentStateRetries = inconsistentStateRetries;
    }

    public void setChannelConfig(String memberName, T config) {
        this._channelsConfig.put(memberName, config);
    }

    public T getChannelConfig(String memberName) {
        return (T)((SourceChannelConfig)this._channelsConfig.get(memberName));
    }

    public void addMembersGrouping(String groupName, String ... memberNames) {
        this._membersGrouping.put(groupName, memberNames);
    }

    public Map<String, String[]> getMembersGrouping() {
        return this._membersGrouping;
    }

    public DynamicSourceGroupMemberLifeCycle getLifeCycle(String memberName) {
        return this._lifeCycles.get(memberName);
    }

    public Map<String, DynamicSourceGroupMemberLifeCycle> getLifeCycles() {
        return this._lifeCycles;
    }

    public GroupConsistencyLevelPolicy getGroupConsistencyLevelPolicy() {
        return this._groupConsistencyLevelPolicy;
    }

    @Override
    public String toString() {
        return "SourceGroupConfig [_backlogConfig=" + this._backlogConfig + ", _groupConsistencyLevelPolicy=" + this._groupConsistencyLevelPolicy + ", _filters=" + this._filters + ", _lifeCycles=" + this._lifeCycles + ", _membersGrouping=" + this._membersGrouping + ", _channelsConfig=" + this._channelsConfig + ", _inconsistentStateDelay=" + this._inconsistentStateDelay + ", _inconsistentStateRetries=" + this._inconsistentStateRetries + ", " + super.toString() + "]";
    }
}

