/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.config;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.config.GroupConfig;
import com.gigaspaces.internal.cluster.node.impl.processlog.ProcessLogConfig;
import com.j_spaces.core.filters.ReplicationStatistics;

@InternalApi
public class TargetGroupConfig
extends GroupConfig {
    private final ProcessLogConfig _processLogConfig;
    private final ReplicationStatistics.ReplicationMode _groupChannelType;
    private int _channelCloseTimeout = 3;
    private boolean _unbounded;
    private boolean _supportDynamicMembers;

    public TargetGroupConfig(String groupName, ProcessLogConfig processLogConfig, ReplicationStatistics.ReplicationMode groupChannelType, String ... membersLookupNames) {
        super(groupName, membersLookupNames);
        this._processLogConfig = processLogConfig;
        this._groupChannelType = groupChannelType;
    }

    public ProcessLogConfig getProcessLogConfig() {
        return this._processLogConfig;
    }

    public int getChannelCloseTimeout() {
        return this._channelCloseTimeout;
    }

    public void setChannelCloseTimeout(int channelCloseTimeout) {
        this._channelCloseTimeout = channelCloseTimeout;
    }

    public void setUnbounded(boolean unbounded) {
        this._unbounded = unbounded;
    }

    public boolean isUnbounded() {
        return this._unbounded;
    }

    public void setSupportDynamicMembers(boolean dynamicMembers) {
        this._supportDynamicMembers = dynamicMembers;
    }

    public boolean isSupportDynamicMembers() {
        return this._supportDynamicMembers;
    }

    public ReplicationStatistics.ReplicationMode getGroupChannelType() {
        return this._groupChannelType;
    }

    public TargetGroupConfig duplicate(String groupName) {
        TargetGroupConfig duplicate = new TargetGroupConfig(groupName, this.getProcessLogConfig(), this.getGroupChannelType(), this.getMembersLookupNames());
        duplicate.setChannelCloseTimeout(this.getChannelCloseTimeout());
        duplicate.setHistoryLength(this.getHistoryLength());
        duplicate.setUnbounded(this.isUnbounded());
        duplicate.setSupportDynamicMembers(this.isSupportDynamicMembers());
        return duplicate;
    }

    @Override
    public String toString() {
        return "TargetGroupConfig [_processLogConfig=" + this._processLogConfig + ", _channelCloseTimeout=" + this._channelCloseTimeout + ", _unbounded=" + this._unbounded + ", , _supportDynamicMembers=" + this._supportDynamicMembers + ", , _groupChannelType=" + (Object)((Object)this._groupChannelType) + super.toString() + "]";
    }
}

