/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency;

import com.gigaspaces.internal.cluster.node.impl.directPersistency.IDirectPersistencyOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.IDirectPersistencySyncHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.admin.DirectPersistencySyncListAdmin;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.IEmbeddedSyncOpInfo;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public abstract class AbstractDirectPersistencyOpInfo
implements IDirectPersistencyOpInfo {
    private static final long serialVersionUID = 1L;
    private long _generationId;
    private long _seq;
    private long _redoKey;
    private boolean _inMainList;
    private boolean _persisted;
    private volatile transient IEmbeddedSyncOpInfo _embeddedSyncOpInfo;
    private static final byte FLAG_BACKUP = 1;

    public AbstractDirectPersistencyOpInfo(long generationId, int seq1, int seq2) {
        this._generationId = generationId;
        this._seq = seq1;
        this._seq = (this._seq << 32) + (long)seq2;
        this._redoKey = -1L;
    }

    public AbstractDirectPersistencyOpInfo(long generationId, long seq) {
        this._generationId = generationId;
        this._seq = seq;
        this._redoKey = -1L;
    }

    public AbstractDirectPersistencyOpInfo() {
    }

    @Override
    public long getGenerationId() {
        return this._generationId;
    }

    @Override
    public abstract boolean isMultiUids();

    @Override
    public abstract String getUid();

    @Override
    public abstract List<String> getUids();

    @Override
    public Long getRedoKey() {
        return this._redoKey;
    }

    @Override
    public boolean hasRedoKey() {
        return this._redoKey != -1L;
    }

    @Override
    public void setRedoKey(long redokey) {
        this._redoKey = redokey;
    }

    @Override
    public boolean isInMainList() {
        return this._inMainList;
    }

    @Override
    public void setInMainList() {
        this._inMainList = true;
    }

    @Override
    public boolean isPersisted() {
        return this._persisted;
    }

    @Override
    public void setPersisted() {
        this._persisted = true;
    }

    @Override
    public long getSequenceNumber() {
        return this._seq;
    }

    @Override
    public int getSegmentNumber() {
        return AbstractDirectPersistencyOpInfo.getSegmentNumber(this._seq);
    }

    public static int getSegmentNumber(long seq) {
        return (int)(seq >>> 32);
    }

    @Override
    public int getOrderWithinSegment() {
        return AbstractDirectPersistencyOpInfo.getOrderWithinSegment(this._seq);
    }

    public static int getOrderWithinSegment(long seq) {
        return (int)(seq << 32 >>> 32);
    }

    @Override
    public boolean isConfirmedByRemote(IDirectPersistencySyncHandler handler) {
        return this.hasRedoKey() && this.getRedoKey() <= handler.getLastConfirmed();
    }

    @Override
    public void setEmbeddedSyncOpInfo(IEmbeddedSyncOpInfo embeddedSyncOpInfo) {
        this._embeddedSyncOpInfo = embeddedSyncOpInfo;
    }

    @Override
    public IEmbeddedSyncOpInfo getEmbeddedSyncOpInfo() {
        return this._embeddedSyncOpInfo;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this._generationId);
        out.writeLong(this._seq);
        if (this._redoKey > -1L) {
            out.writeBoolean(true);
            out.writeLong(this._redoKey);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._generationId = in.readLong();
        this._seq = in.readLong();
        PlatformLogicalVersion curversion = PlatformLogicalVersion.getLogicalVersion();
        PlatformLogicalVersion myversion = DirectPersistencySyncListAdmin.getVersions().get(this._generationId);
        if (myversion == null) {
            throw new RuntimeException("platform version not found for generationid=" + this._generationId);
        }
        this._redoKey = in.readBoolean() ? in.readLong() : -1L;
        this._persisted = true;
    }

    public String toString() {
        return "AbstractDirectPersistencyOpInfo{_generationId=" + this._generationId + ", _seq=" + this._seq + ", _redoKey=" + this._redoKey + ", _inMainList=" + this._inMainList + ", _persisted=" + this._persisted + ", _embeddedSyncOpInfo=" + this._embeddedSyncOpInfo + '}';
    }
}

