/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencySyncListBatch;
import java.util.Iterator;

@InternalApi
public class DirectPersistencyBackupSyncIteratorHandler {
    private Iterator<String> entriesForRecover;
    private final int batchSize = Integer.getInteger("com.gs.replication.blobstore.sync_list_batch_size", 15000);

    public DirectPersistencyBackupSyncIteratorHandler(Iterator<String> entriesForRecover) {
        this.entriesForRecover = entriesForRecover;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public DirectPersistencySyncListBatch getNextBatch() {
        DirectPersistencySyncListBatch batch = new DirectPersistencySyncListBatch();
        for (int currentBatchSize = this.getBatchSize(); currentBatchSize > 0 && this.entriesForRecover.hasNext(); --currentBatchSize) {
            batch.addEntryToBatch(this.entriesForRecover.next());
        }
        return batch;
    }
}

