/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencyMultipleUidsOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencyOverflowList;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencyOverflowListSegment;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencySingleUidOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.IDirectPersistencyOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.IDirectPersistencySyncHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.ioImpl.IDirectPersistencyIoHandler;
import com.gigaspaces.internal.server.space.SpaceEngine;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class DirectPersistencyListHandler {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.direct_persistency");
    private static final int NUM_MEM_SEGMENTS = 8;
    final int MAX_ENTRIES_IN_MEMORY;
    private final IDirectPersistencySyncHandler _handler;
    private IDirectPersistencyIoHandler _ioHandler;
    private final MemorySegment[] _memSegments;
    private final DirectPersistencyOverflowList _overFlow;

    DirectPersistencyListHandler(IDirectPersistencySyncHandler handler, SpaceEngine spaceEngine) {
        this._handler = handler;
        this._memSegments = new MemorySegment[8];
        for (int i = 0; i < 8; ++i) {
            this._memSegments[i] = new MemorySegment(this);
        }
        this.MAX_ENTRIES_IN_MEMORY = spaceEngine.getConfigReader().getIntSpaceProperty("engine.sync_list_max_size_in_memory", String.valueOf(100000));
        this._overFlow = new DirectPersistencyOverflowList(this._handler);
    }

    void setDirectPersistencyIoHandler(IDirectPersistencyIoHandler ioHandler) {
        this._ioHandler = ioHandler;
    }

    public int getNumSegments() {
        return 8;
    }

    DirectPersistencySingleUidOpInfo onDirectPersistencyOpStart(String uid) {
        int seg = this.getSegmentNumberForUid(uid);
        DirectPersistencySingleUidOpInfo e = new DirectPersistencySingleUidOpInfo(this._handler.getCurrentGenerationId(), uid, seg, this.getNextSeqNumber(seg));
        if (!this._handler.isEmbeddedListUsed()) {
            this._ioHandler.insert(e);
        }
        return e;
    }

    DirectPersistencyMultipleUidsOpInfo onDirectPersistencyOpStart(List<String> uids) {
        int seg = this.getSegmentNumberForUid(uids.get(0));
        DirectPersistencyMultipleUidsOpInfo e = new DirectPersistencyMultipleUidsOpInfo(this._handler.getCurrentGenerationId(), uids, seg, this.getNextSeqNumber(seg));
        if (!this._handler.isEmbeddedListUsed()) {
            this._ioHandler.insert(e);
        }
        return e;
    }

    DirectPersistencySingleUidOpInfo onEmbeddedOpFromInitialLoad(String uid, long gen, long seq) {
        DirectPersistencySingleUidOpInfo e = new DirectPersistencySingleUidOpInfo(gen, uid, seq);
        return e;
    }

    DirectPersistencyMultipleUidsOpInfo onEmbeddedOpFromInitialLoad(List<String> uids, long gen, long seq) {
        DirectPersistencyMultipleUidsOpInfo e = new DirectPersistencyMultipleUidsOpInfo(gen, uids, seq);
        return e;
    }

    private int getSegmentNumberForUid(String uid) {
        return Math.abs(uid.hashCode()) % 8;
    }

    int getNextSeqNumber(int segmentNumber) {
        return this._memSegments[segmentNumber].getNextSeqNumber();
    }

    void onEmbeddedListRecordTransferStart(IDirectPersistencyOpInfo o, boolean onlyIfNotExists) {
        this.insertToPersistentSyncListFromEmbeddedList(o, onlyIfNotExists);
    }

    public void insertToPersistentSyncListFromEmbeddedList(IDirectPersistencyOpInfo o, boolean onlyIfNotExists) {
        if (onlyIfNotExists && this._ioHandler.get(o.getGenerationId(), o.getSequenceNumber()) != null) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("[" + this._handler.getSpaceEngine().getFullSpaceName() + "] DirectPersistencyListHandler will not move " + o + " from embedded sync list to persistent sync list because it is already there");
            }
            return;
        }
        this._ioHandler.insert(o);
    }

    void onEmbeddedListRecordTransferEnd(IDirectPersistencyOpInfo e) {
        this.addToSyncListSegment(e);
    }

    public void checkDirectPersistencyOpCompleletion(IDirectPersistencyOpInfo e) {
        if (e.getGenerationId() != this._handler.getCurrentGenerationId()) {
            return;
        }
        if (!e.isInMainList() && e.hasRedoKey() && e.isPersisted()) {
            if (this._handler.isEmbeddedListUsed()) {
                if (e.isMultiUids()) {
                    this._handler.getEmbeddedSyncHandler().onEmbeddedSyncOp((DirectPersistencyMultipleUidsOpInfo)e);
                } else {
                    this._handler.getEmbeddedSyncHandler().onEmbeddedSyncOp((DirectPersistencySingleUidOpInfo)e);
                }
                return;
            }
            this.addToSyncListSegment(e);
        }
    }

    private void addToSyncListSegment(IDirectPersistencyOpInfo e) {
        e.setInMainList();
        if (!this._handler.isEmbeddedListUsed() || e.getGenerationId() == this._handler.getCurrentGenerationId()) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("[" + this._handler.getSpaceEngine().getFullSpaceName() + "] DirectPersistencyListHandler adding to SyncList: uid= " + e.getUid() + " ,redokey= " + e.getRedoKey());
            }
            this._memSegments[MemorySegment.getMemSegmentNumber(e)].add(e);
        }
    }

    int syncToRedologConfirmation(long confirmed) {
        int res = 0;
        res = this.syncToRedologConfirmationMemory(confirmed);
        return res += this._overFlow.syncToRedologConfirmation(confirmed);
    }

    int moveTooverflowIfNeeded() {
        int ovf = 0;
        int max_per_segment = this.MAX_ENTRIES_IN_MEMORY / 8;
        for (int i = 0; i < 8; ++i) {
            ovf += this._memSegments[i].overflowIfNeeded(max_per_segment);
        }
        return ovf;
    }

    boolean isOverflow() {
        return !this._overFlow.isEmpty();
    }

    private int syncToRedologConfirmationMemory(long confirmed) {
        int removed = 0;
        for (int i = 0; i < 8; ++i) {
            removed += this._memSegments[i].syncToRedologConfirmationMemory(confirmed);
        }
        return removed;
    }

    int getNumMemoryOps() {
        int memOps = 0;
        for (int i = 0; i < 8; ++i) {
            memOps += this._memSegments[i].getNumOps();
        }
        return memOps;
    }

    Iterator<String> getRecoveryIterator() {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("[" + this._handler.getSpaceEngine().getFullSpaceName() + "] DirectPersistencyListHandler getting entries to recover");
        }
        return new DirectPersistencyRecoveryIterator(this);
    }

    void cleanPreviousGenerationsOps() {
        LinkedList<IDirectPersistencyOpInfo> toRemove = new LinkedList<IDirectPersistencyOpInfo>();
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("[" + this._handler.getSpaceEngine().getFullSpaceName() + "] DirectPersistencyListHandler cleanPreviousGenerationsOps");
        }
        Iterator<IDirectPersistencyOpInfo> prevGenIter = this._ioHandler.iterateOps(false);
        while (prevGenIter.hasNext()) {
            toRemove.add(prevGenIter.next());
            if (toRemove.size() < 1000) continue;
            this._ioHandler.removeOpsBulk(toRemove);
            toRemove.clear();
        }
        if (!toRemove.isEmpty()) {
            this._ioHandler.removeOpsBulk(toRemove);
        }
    }

    public IDirectPersistencyIoHandler getIoHandler() {
        return this._ioHandler;
    }

    void removeAllOverflow() {
        LinkedList<DirectPersistencyOverflowListSegment> toRemove = new LinkedList<DirectPersistencyOverflowListSegment>();
        Iterator<DirectPersistencyOverflowListSegment> iter = this._ioHandler.iterateOverflow(false);
        while (iter.hasNext()) {
            toRemove.add(iter.next());
            if (toRemove.size() < 1000) continue;
            this._ioHandler.removeOvfBulk(toRemove);
            toRemove.clear();
        }
        if (!toRemove.isEmpty()) {
            this._ioHandler.removeOvfBulk(toRemove);
        }
    }

    public IDirectPersistencySyncHandler getSyncHandler() {
        return this._handler;
    }

    static class MemorySegment {
        private final ConcurrentLinkedDeque<IDirectPersistencyOpInfo> _ops = new ConcurrentLinkedDeque();
        private final DirectPersistencyListHandler _listHandler;
        private final AtomicInteger _seq;

        public MemorySegment(DirectPersistencyListHandler listHandler) {
            this._listHandler = listHandler;
            this._seq = new AtomicInteger(-1);
        }

        static int getMemSegmentNumber(IDirectPersistencyOpInfo e) {
            return Math.abs((int)(e.getSequenceNumber() % 8L));
        }

        int getNextSeqNumber() {
            return this._seq.incrementAndGet();
        }

        ConcurrentLinkedDeque<IDirectPersistencyOpInfo> getOps() {
            return this._ops;
        }

        void add(IDirectPersistencyOpInfo e) {
            this._ops.add(e);
        }

        int getNumOps() {
            return this._ops.size();
        }

        int syncToRedologConfirmationMemory(long confirmed) {
            IDirectPersistencyOpInfo e;
            int removed = 0;
            if (this._ops.isEmpty()) {
                return removed;
            }
            IDirectPersistencyOpInfo peeked = this._ops.peek();
            if (peeked.getRedoKey() > confirmed) {
                return removed;
            }
            DirectPersistencyCurrentGenerationMemoryIterator iter = new DirectPersistencyCurrentGenerationMemoryIterator(this._listHandler, this);
            while (iter.hasNext() && (e = iter.next()).getRedoKey() <= confirmed) {
                this._listHandler.getIoHandler().remove(e);
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.finer("[" + this._listHandler._handler.getSpaceEngine().getFullSpaceName() + "] DirectPersistencyListHandler received redo log confirmation on uid= " + e.getUid() + " ,redokey= " + e.getRedoKey());
                }
                iter.remove();
                ++removed;
            }
            return removed;
        }

        int overflowIfNeeded(int max_to_allow) {
            if (this._ops.size() <= max_to_allow) {
                return 0;
            }
            return this._listHandler._overFlow.moveToOverflow(this._ops.iterator(), this._ops.size() - max_to_allow);
        }
    }

    public static class DirectPersistencyRecoveryIterator
    implements Iterator<String> {
        private final HashSet<String> _usedUids;
        private Iterator<String> _multiUidsIter;
        private final DirectPersistencyListHandler _listHandler;
        private final Iterator<IDirectPersistencyOpInfo> _prevGenIter;
        private Iterator<String> _embeddedListForRecovery;
        private boolean _closed;
        private String _cur;

        public DirectPersistencyRecoveryIterator(DirectPersistencyListHandler listHandler) {
            this._listHandler = listHandler;
            this._usedUids = new HashSet();
            this._prevGenIter = this._listHandler._ioHandler.iterateOps(false);
            this._embeddedListForRecovery = this._listHandler.getSyncHandler().isEmbeddedListUsed() ? listHandler.getSyncHandler().getEmbeddedSyncHandler().getEmbeddedListForRecovery() : null;
        }

        @Override
        public String next() {
            if (this._closed || this._cur == null) {
                throw new UnsupportedOperationException("next but iter terminated");
            }
            String cur = this._cur;
            this._cur = null;
            return cur;
        }

        @Override
        public boolean hasNext() {
            this._cur = null;
            String cur = null;
            while (!this._closed) {
                if (this._embeddedListForRecovery != null) {
                    if (this._embeddedListForRecovery.hasNext()) {
                        String nextEmbedded = this._embeddedListForRecovery.next();
                        if (!this._usedUids.add(nextEmbedded)) continue;
                        this._cur = nextEmbedded;
                        return true;
                    }
                    this._embeddedListForRecovery = null;
                }
                if (this._multiUidsIter != null) {
                    if (this._multiUidsIter.hasNext()) {
                        cur = this._multiUidsIter.next();
                        if (!this._usedUids.add(cur)) continue;
                        this._cur = cur;
                        return true;
                    }
                    this._multiUidsIter = null;
                    continue;
                }
                if (!this._prevGenIter.hasNext()) {
                    this._closed = true;
                    return false;
                }
                IDirectPersistencyOpInfo e = this._prevGenIter.next();
                if (!e.isMultiUids()) {
                    if (!this._usedUids.add(e.getUid())) continue;
                    this._cur = e.getUid();
                    return true;
                }
                this._multiUidsIter = e.getUids().iterator();
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove-irrelevant");
        }
    }

    public static class DirectPersistencyCurrentGenerationMemoryIterator
    implements Iterator<IDirectPersistencyOpInfo> {
        private final DirectPersistencyListHandler _listHandler;
        private final Iterator<IDirectPersistencyOpInfo> _entriesMemoryIter;
        private boolean _closed;

        public DirectPersistencyCurrentGenerationMemoryIterator(DirectPersistencyListHandler listHandler, MemorySegment memSegment) {
            this._listHandler = listHandler;
            this._entriesMemoryIter = memSegment.getOps().iterator();
        }

        @Override
        public IDirectPersistencyOpInfo next() {
            return this._entriesMemoryIter.next();
        }

        @Override
        public boolean hasNext() {
            if (this._closed) {
                return false;
            }
            if (!this._entriesMemoryIter.hasNext()) {
                this._closed = true;
                return false;
            }
            return true;
        }

        @Override
        public void remove() {
            if (this._closed) {
                throw new UnsupportedOperationException("remove-irrelevant");
            }
            this._entriesMemoryIter.remove();
        }

        public void close() {
            this._closed = true;
        }
    }
}

