/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencyOverflowListSegment;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.IDirectPersistencyOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.IDirectPersistencySyncHandler;
import java.util.Iterator;

@InternalApi
public class DirectPersistencyOverflowList {
    private final IDirectPersistencySyncHandler _main;
    private int _numOverFlowen;
    private DirectPersistencyOverflowListSegment _oldest;
    private long _oldestSeq;
    private long _currentSeq;
    private DirectPersistencyOverflowListSegment _current;

    DirectPersistencyOverflowList(IDirectPersistencySyncHandler main) {
        this._main = main;
        this.reset();
    }

    public boolean isEmpty() {
        return this._numOverFlowen == 0;
    }

    public int moveToOverflow(Iterator<IDirectPersistencyOpInfo> iter, int numberToOverflow) {
        int res = 0;
        for (int i = 0; i < numberToOverflow && iter.hasNext(); ++i) {
            IDirectPersistencyOpInfo cur;
            if (this._current.isFull()) {
                this.setNewCurrent();
            }
            if ((cur = iter.next()).getRedoKey() <= this._main.getLastConfirmed()) {
                this._main.getListHandler().getIoHandler().remove(cur);
                iter.remove();
                continue;
            }
            this._main.getListHandler().getIoHandler().update(cur);
            this._current.add(this._main, cur);
            ++this._numOverFlowen;
            ++res;
            iter.remove();
        }
        return res;
    }

    private void setNewCurrent() {
        if (this._current != null) {
            this._current.persist(this._main);
        }
        this._current = new DirectPersistencyOverflowListSegment(this._main.getCurrentGenerationId(), ++this._currentSeq);
        if (this._oldest == null) {
            this._oldest = this._current;
            this._oldestSeq = this._currentSeq;
        }
    }

    public int syncToRedologConfirmation(long confirmed) {
        int res = 0;
        while (!this.isEmpty()) {
            DirectPersistencyOverflowListSegment workingSegment = this._oldest;
            int cur = workingSegment.syncToRedologConfirmation(this._main, confirmed);
            res += cur;
            this._numOverFlowen -= cur;
            if (!workingSegment.isEmpty()) {
                return res;
            }
            workingSegment.remove(this._main);
            if (this.isEmpty()) {
                this.reset();
                return res;
            }
            ++this._oldestSeq;
            if (this._oldestSeq == this._currentSeq) {
                this._oldest = this._current;
                continue;
            }
            this._oldest = this._main.getListHandler().getIoHandler().getOverflowSegment(this._main.getCurrentGenerationId(), this._oldestSeq);
        }
        return res;
    }

    private void reset() {
        this._current = null;
        this._oldest = null;
        this._oldestSeq = -1L;
        this._currentSeq = -1L;
        this._numOverFlowen = 0;
        this.setNewCurrent();
    }
}

