/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.IDirectPersistencyOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.IDirectPersistencySyncHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.admin.DirectPersistencySyncListAdmin;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedList;

@InternalApi
public class DirectPersistencyOverflowListSegment
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final int OVERFLOW_ELEMENT_MAX_SIZE = 10000;
    private long _generationId;
    private long _seq;
    private long _minRedoKey;
    private LinkedList<Long> _elements;
    private transient boolean _persisted;
    private transient boolean _dirty;

    public DirectPersistencyOverflowListSegment(long generationId, long seq) {
        this._generationId = generationId;
        this._seq = seq;
        this._elements = new LinkedList();
        this._minRedoKey = Long.MAX_VALUE;
    }

    public DirectPersistencyOverflowListSegment() {
    }

    public boolean isEmpty() {
        return this._elements.isEmpty();
    }

    public boolean isFull() {
        return this._elements.size() >= 10000;
    }

    public void add(IDirectPersistencySyncHandler main, IDirectPersistencyOpInfo oi) {
        if (oi.getRedoKey() == -1L) {
            throw new UnsupportedOperationException("invalid element");
        }
        this._dirty = true;
        main.getListHandler().getIoHandler().update(oi);
        this._elements.addLast(oi.getSequenceNumber());
        if (oi.getRedoKey() < this._minRedoKey) {
            this._minRedoKey = oi.getRedoKey();
        }
    }

    void persist(IDirectPersistencySyncHandler main) {
        if (!this._dirty) {
            return;
        }
        if (this._persisted) {
            main.getListHandler().getIoHandler().update(this);
        } else {
            main.getListHandler().getIoHandler().insert(this);
            this._persisted = true;
        }
        this._dirty = false;
    }

    public void remove(IDirectPersistencySyncHandler main) {
        if (!this._persisted) {
            return;
        }
        main.getListHandler().getIoHandler().remove(this);
        this._dirty = true;
        this._persisted = false;
    }

    public int getNumElements() {
        return this._elements.size();
    }

    public int syncToRedologConfirmation(IDirectPersistencySyncHandler main, long confirmed) {
        IDirectPersistencyOpInfo e;
        int res = 0;
        if (confirmed < this._minRedoKey) {
            return res;
        }
        OverflowElementIterator iter = new OverflowElementIterator(main, this._elements);
        while (iter.hasNext() && (e = (IDirectPersistencyOpInfo)iter.next()).getRedoKey() <= confirmed) {
            iter.remove();
            ++res;
        }
        return res;
    }

    public long getGenerationId() {
        return this._generationId;
    }

    public long getSequenceNumber() {
        return this._seq;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this._generationId);
        out.writeLong(this._seq);
        out.writeLong(this._minRedoKey);
        out.writeInt(this._elements.size());
        Iterator iter = this._elements.iterator();
        while (iter.hasNext()) {
            out.writeLong((Long)iter.next());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._persisted = true;
        this._generationId = in.readLong();
        this._seq = in.readLong();
        PlatformLogicalVersion curversion = PlatformLogicalVersion.getLogicalVersion();
        PlatformLogicalVersion myversion = DirectPersistencySyncListAdmin.getVersions().get(this._generationId);
        if (myversion == null) {
            throw new RuntimeException("platform version not found for generationid=" + this._generationId);
        }
        this._minRedoKey = in.readLong();
        int size = in.readInt();
        this._elements = new LinkedList();
        for (int i = 0; i < size; ++i) {
            this._elements.add(in.readLong());
        }
    }

    public static class OverflowElementIterator
    implements Iterator<IDirectPersistencyOpInfo> {
        private final IDirectPersistencySyncHandler _main;
        private final Iterator<Long> _iter;
        private IDirectPersistencyOpInfo _cur;

        public OverflowElementIterator(IDirectPersistencySyncHandler main, LinkedList<Long> elements) {
            this._main = main;
            this._iter = elements.iterator();
        }

        @Override
        public IDirectPersistencyOpInfo next() {
            this._cur = this._main.getListHandler().getIoHandler().get(this._main.getCurrentGenerationId(), this._iter.next());
            return this._cur;
        }

        @Override
        public boolean hasNext() {
            return this._iter.hasNext();
        }

        @Override
        public void remove() {
            this._main.getListHandler().getIoHandler().remove(this._cur);
            this._iter.remove();
        }
    }
}

