/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationOutContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencyListHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencyMultipleUidsOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencySingleUidOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.IDirectPersistencyOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.IDirectPersistencySyncHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.admin.DirectPersistencySyncListAdmin;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.EmbeddedSyncHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.ioImpl.IDirectPersistencyIoHandler;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.j_spaces.core.cache.blobStore.BlobStoreEntryHolder;
import com.j_spaces.core.cluster.ClusterPolicy;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class DirectPersistencySyncHandler
implements IDirectPersistencySyncHandler {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.direct_persistency");
    private final long _currentGenerationId;
    private final DirectPersistencyListHandler _directPersistencyListHandler;
    private final DirectPersistencySyncListAdmin _admin;
    private IReplicationGroupBacklog _backlog;
    private final String _peerSpace;
    private final String _currentSpace;
    private final Syncer _syncer;
    private long _confirmed;
    private final SpaceEngine _spaceEngine;
    private final EmbeddedSyncHandler _embeddedSyncHandler;
    private final ReadWriteLock _readWriteLock = new ReentrantReadWriteLock();
    private final Lock _readLock = this._readWriteLock.readLock();
    private final Lock _writeLock = this._readWriteLock.writeLock();
    private volatile boolean _afterRecoveryStarted;
    private final int SYNC_THREAD_INTERVAL_TIME;
    private final int SYNC_THREAD_INTERVAL_TIME_IF_OVERFLOW;

    public DirectPersistencySyncHandler(SpaceEngine engine) {
        ClusterPolicy clusterPolicy = engine.getClusterPolicy();
        if (!clusterPolicy.isReplicated() || clusterPolicy.isActiveActive() || !clusterPolicy.isPrimaryElectionAvailable() || clusterPolicy.m_FailOverPolicy == null) {
            throw new UnsupportedOperationException("DirectPersistencySyncHandler cannot be created-cluster policy dont suit");
        }
        if (clusterPolicy.m_FailOverPolicy.failOverGroupMembersNames.size() == 1) {
            throw new UnsupportedOperationException("DirectPersistencySyncHandler cannot be created-cluster policy dont suit");
        }
        this._spaceEngine = engine;
        String peerSpace = null;
        for (String name : clusterPolicy.m_FailOverPolicy.failOverGroupMembersNames) {
            if (name.equals(clusterPolicy.m_ClusterGroupMember)) continue;
            peerSpace = name;
            break;
        }
        this._peerSpace = peerSpace;
        this._currentSpace = clusterPolicy.m_ClusterGroupMember;
        this._currentGenerationId = System.currentTimeMillis();
        this._directPersistencyListHandler = new DirectPersistencyListHandler(this, engine);
        this._syncer = new Syncer("DirectPersistencySyncerThread", this);
        this._confirmed = -1L;
        boolean embeddedSyncListEnabled = Boolean.parseBoolean(System.getProperty("com.gs.blobstore.use_embedded_sync_list", "true"));
        this._embeddedSyncHandler = embeddedSyncListEnabled ? new EmbeddedSyncHandler(this) : null;
        this._admin = new DirectPersistencySyncListAdmin(this);
        this.SYNC_THREAD_INTERVAL_TIME = this._spaceEngine.getConfigReader().getIntSpaceProperty("engine.sync_list_thread_interval_time", String.valueOf(500));
        this.SYNC_THREAD_INTERVAL_TIME_IF_OVERFLOW = this.SYNC_THREAD_INTERVAL_TIME / 10;
        _logger.info("created direct-persistency handler peerSpace=" + this._peerSpace + " thread-interval =" + this.SYNC_THREAD_INTERVAL_TIME + " max-in-memory=" + this._directPersistencyListHandler.MAX_ENTRIES_IN_MEMORY + " embedded sync list is used? [" + this.isEmbeddedListUsed() + "]");
    }

    @Override
    public void initialize() {
        this._directPersistencyListHandler.removeAllOverflow();
        this._syncer.start();
        if (this.isEmbeddedListUsed()) {
            this._embeddedSyncHandler.initialize();
        }
    }

    @Override
    public void afterInitializedBlobStoreIO(IDirectPersistencyIoHandler ioHandler) {
        this._directPersistencyListHandler.setDirectPersistencyIoHandler(ioHandler);
        this._admin.initialize(this._currentGenerationId);
        if (this.isEmbeddedListUsed()) {
            this._embeddedSyncHandler.afterInitializedBlobStoreIO();
        }
    }

    @Override
    public long getCurrentGenerationId() {
        return this._currentGenerationId;
    }

    @Override
    public boolean isOverflow() {
        return this._directPersistencyListHandler.isOverflow();
    }

    @Override
    public void beforeDirectPersistencyOp(IReplicationOutContext replContext, IEntryHolder entryHolder, boolean phantom) {
        DirectPersistencySingleUidOpInfo e = this._directPersistencyListHandler.onDirectPersistencyOpStart(entryHolder.getUID());
        if (this.isEmbeddedListUsed()) {
            this._embeddedSyncHandler.beforeEmbeddedSyncOp(e, phantom);
            ((BlobStoreEntryHolder)entryHolder).setEmbeddedSyncOpInfo(e.getGenerationId(), e.getSequenceNumber(), phantom, false);
        }
        replContext.setDirectPersistencyPendingEntry(e);
        replContext.setDirectPesistencySyncHandler(this);
    }

    @Override
    public void beforeDirectPersistencyOp(IReplicationOutContext replContext, List<String> uids, Set<String> phantoms, Map<String, IEntryHolder> entryHolderMap) {
        DirectPersistencyMultipleUidsOpInfo e = this._directPersistencyListHandler.onDirectPersistencyOpStart(uids);
        if (this.isEmbeddedListUsed()) {
            this._embeddedSyncHandler.beforeEmbeddedSyncOp(e, phantoms);
            for (IEntryHolder iEntryHolder : entryHolderMap.values()) {
                ((BlobStoreEntryHolder)iEntryHolder).setEmbeddedSyncOpInfo(e.getGenerationId(), e.getSequenceNumber(), phantoms != null && phantoms.contains(iEntryHolder.getUID()), true);
            }
        }
        replContext.setDirectPersistencyPendingEntry(e);
        replContext.setDirectPesistencySyncHandler(this);
    }

    @Override
    public void onEmbeddedOpFromInitialLoad(String uid, long gen, long seq, boolean phantom) {
        this._embeddedSyncHandler.onEmbeddedOpFromInitialLoad(this._directPersistencyListHandler.onEmbeddedOpFromInitialLoad(uid, gen, seq), phantom);
    }

    @Override
    public void onEmbeddedOpFromInitialLoad(List<String> uids, long gen, long seq, Set<String> phantoms) {
        this._embeddedSyncHandler.onEmbeddedOpFromInitialLoad(this._directPersistencyListHandler.onEmbeddedOpFromInitialLoad(uids, gen, seq), phantoms);
    }

    @Override
    public void onEmbeddedListRecordTransferStart(IDirectPersistencyOpInfo o, boolean onlyIfNotExists) {
        this._directPersistencyListHandler.onEmbeddedListRecordTransferStart(o, onlyIfNotExists);
    }

    @Override
    public void onEmbeddedListRecordTransferEnd(IDirectPersistencyOpInfo o) {
        this._directPersistencyListHandler.onEmbeddedListRecordTransferEnd(o);
    }

    @Override
    public Iterator<String> getEntriesForRecovery() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "space " + this._currentSpace + " DirectPersistencySyncHandler: getEntriesForRecovery called");
        }
        return this._directPersistencyListHandler.getRecoveryIterator();
    }

    @Override
    public void afterRecovery() {
        this._writeLock.lock();
        try {
            this._afterRecoveryStarted = true;
        }
        finally {
            this._writeLock.unlock();
        }
        if (this.isEmbeddedListUsed()) {
            this._embeddedSyncHandler.afterRecovery();
        }
        this._directPersistencyListHandler.cleanPreviousGenerationsOps();
        this._admin.cleanOlderGens(this._currentGenerationId);
    }

    @Override
    public void afterInsertingToRedolog(IReplicationOutContext context, long redoKey) {
        if (context.getDirectPersistencyPendingEntry() != null) {
            context.getDirectPersistencyPendingEntry().setRedoKey(redoKey);
            this._directPersistencyListHandler.checkDirectPersistencyOpCompleletion(context.getDirectPersistencyPendingEntry());
            context.setDirectPersistencyPendingEntry(null);
        }
    }

    @Override
    public void afterOperationPersisted(IDirectPersistencyOpInfo e) {
        e.setPersisted();
        this._directPersistencyListHandler.checkDirectPersistencyOpCompleletion(e);
    }

    @Override
    public void setBackLog(IReplicationGroupBacklog backlog) {
        this._backlog = backlog;
    }

    @Override
    public IReplicationGroupBacklog getBackLog() {
        return this._backlog;
    }

    public Logger getLogger() {
        return _logger;
    }

    @Override
    public DirectPersistencyListHandler getListHandler() {
        return this._directPersistencyListHandler;
    }

    @Override
    public long getLastConfirmed() {
        return this._confirmed;
    }

    @Override
    public void setLastConfirmed(long confirmed) {
        this._confirmed = confirmed;
    }

    public Lock getReadLock() {
        return this._readLock;
    }

    public boolean afterRecoveryStarted() {
        return this._afterRecoveryStarted;
    }

    @Override
    public void close() {
        if (this.isEmbeddedListUsed()) {
            this._embeddedSyncHandler.close();
        }
        this._syncer.close();
    }

    @Override
    public SpaceEngine getSpaceEngine() {
        return this._spaceEngine;
    }

    @Override
    public boolean isEmbeddedListUsed() {
        return this._embeddedSyncHandler != null;
    }

    @Override
    public EmbeddedSyncHandler getEmbeddedSyncHandler() {
        return this._embeddedSyncHandler;
    }

    private class Syncer
    extends GSThread {
        private volatile boolean _closed;
        private final DirectPersistencySyncHandler _handler;

        public Syncer(String threadName, DirectPersistencySyncHandler handler) {
            super(threadName);
            this._handler = handler;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int synced = 0;
            try {
                while (!this._closed) {
                    try {
                        block17: {
                            long timeToSleep = this._handler.isOverflow() ? (long)this._handler.SYNC_THREAD_INTERVAL_TIME_IF_OVERFLOW : (long)this._handler.SYNC_THREAD_INTERVAL_TIME;
                            try {
                                if (synced != 0 && this._handler.isOverflow()) break block17;
                                Thread.sleep(timeToSleep);
                            }
                            catch (InterruptedException ex) {
                                if (this._handler.getLogger().isLoggable(Level.FINE)) {
                                    this._handler.getLogger().warning("[" + this._handler._currentSpace + "] DirectPersistencySyncHandler Syncer thread interrupted");
                                }
                                if (!this._closed) continue;
                                break;
                            }
                        }
                        if (this._closed) {
                            break;
                        }
                        synced = this.handelListIfConfirmationsOccured();
                        this.moveToOverflowIfNeeded();
                    }
                    catch (Throwable ex) {
                        if (this._handler.getLogger().isLoggable(Level.SEVERE)) {
                            this._handler.getLogger().severe("[" + this._handler._currentSpace + "] DirectPersistencySyncHandler Syncer thread got unexpected exception " + ex);
                        }
                        if (!this._closed) continue;
                        break;
                    }
                }
            }
            finally {
                Syncer syncer = this;
                synchronized (syncer) {
                    ((Object)((Object)this)).notifyAll();
                }
            }
        }

        private int handelListIfConfirmationsOccured() {
            int synced;
            if (DirectPersistencySyncHandler.this._backlog == null) {
                if (_logger.isLoggable(Level.FINE) && DirectPersistencySyncHandler.this._spaceEngine.getSpaceImpl().isPrimary()) {
                    _logger.log(Level.FINE, "[" + this._handler._currentSpace + "] DirectPersistencySyncHandler:Syncer backlog not set yet");
                }
                return 0;
            }
            long confirmed = DirectPersistencySyncHandler.this._backlog.getConfirmed(DirectPersistencySyncHandler.this._peerSpace);
            if (confirmed > this._handler.getLastConfirmed()) {
                this._handler.setLastConfirmed(confirmed);
            }
            if ((synced = DirectPersistencySyncHandler.this._directPersistencyListHandler.syncToRedologConfirmation(this._handler.getLastConfirmed())) > 0 && _logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[" + this._handler._currentSpace + "] DirectPersistencySyncHandler ripped " + synced + " confirmed=" + this._handler.getLastConfirmed() + " confirmed ops, remained in memory=" + this._handler._directPersistencyListHandler.getNumMemoryOps() + " overflow=" + this._handler.isOverflow());
            }
            return synced;
        }

        private void moveToOverflowIfNeeded() {
            int overf = DirectPersistencySyncHandler.this._directPersistencyListHandler.moveTooverflowIfNeeded();
            if (overf > 0 && _logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[" + this._handler._currentSpace + "] DirectPersistencySyncHandler " + overf + " moved to overflow");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Syncer syncer = this;
            synchronized (syncer) {
                if (this._closed) {
                    return;
                }
                this._closed = true;
                this.interrupt();
                try {
                    ((Object)((Object)this)).wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

