/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency.admin;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class DirectPersistencySyncAdminInfo
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private Map<Long, PlatformLogicalVersion> _versions;

    public DirectPersistencySyncAdminInfo(Map<Long, PlatformLogicalVersion> versions) {
        this._versions = new HashMap<Long, PlatformLogicalVersion>(versions);
    }

    public DirectPersistencySyncAdminInfo() {
    }

    public Map<Long, PlatformLogicalVersion> getVersions() {
        return this._versions;
    }

    public static String getStorageKey() {
        return "SYNC_ADMIN";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._versions = new HashMap<Long, PlatformLogicalVersion>();
        PlatformLogicalVersion myversion = (PlatformLogicalVersion)in.readObject();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            long generation = in.readLong();
            PlatformLogicalVersion l = (PlatformLogicalVersion)in.readObject();
            this._versions.put(generation, l);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        PlatformLogicalVersion curversion = PlatformLogicalVersion.getLogicalVersion();
        out.writeObject(curversion);
        out.writeInt(this._versions.size());
        for (Map.Entry<Long, PlatformLogicalVersion> e : this._versions.entrySet()) {
            out.writeLong(e.getKey());
            out.writeObject(e.getValue());
        }
    }
}

