/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency.admin;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencySyncHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.admin.DirectPersistencySyncAdminInfo;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

@InternalApi
public class DirectPersistencySyncListAdmin {
    private static final Object _lock = new Object();
    private static volatile Map<Long, PlatformLogicalVersion> _versions = new HashMap<Long, PlatformLogicalVersion>();
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.direct_persistency");
    private final DirectPersistencySyncHandler _main;
    private DirectPersistencySyncAdminInfo _info;

    public DirectPersistencySyncListAdmin(DirectPersistencySyncHandler mainlist) {
        this._main = mainlist;
    }

    public void initialize(long currentGeneration) {
        PlatformLogicalVersion curversion = PlatformLogicalVersion.getLogicalVersion();
        this._info = this._main.getListHandler().getIoHandler().getSyncAdminIfExists();
        if (this._info != null) {
            DirectPersistencySyncListAdmin.integrate(this._info, currentGeneration, curversion);
            this._info = new DirectPersistencySyncAdminInfo(_versions);
            this._main.getListHandler().getIoHandler().update(this._info);
        } else {
            DirectPersistencySyncListAdmin.integrate(currentGeneration, curversion);
            this._info = new DirectPersistencySyncAdminInfo(_versions);
            this._main.getListHandler().getIoHandler().insert(this._info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void integrate(DirectPersistencySyncAdminInfo info, long curGeneration, PlatformLogicalVersion curversion) {
        Object object = _lock;
        synchronized (object) {
            HashMap<Long, PlatformLogicalVersion> newmap = new HashMap<Long, PlatformLogicalVersion>(_versions);
            newmap.putAll(info.getVersions());
            newmap.put(curGeneration, curversion);
            _versions = newmap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void integrate(long curGeneration, PlatformLogicalVersion curversion) {
        Object object = _lock;
        synchronized (object) {
            HashMap<Long, PlatformLogicalVersion> newmap = new HashMap<Long, PlatformLogicalVersion>(_versions);
            newmap.put(curGeneration, curversion);
            _versions = newmap;
        }
    }

    public void cleanOlderGens(long curGeneration) {
        PlatformLogicalVersion curversion = PlatformLogicalVersion.getLogicalVersion();
        HashMap<Long, PlatformLogicalVersion> newmap = new HashMap<Long, PlatformLogicalVersion>();
        newmap.put(curGeneration, curversion);
        this._info = new DirectPersistencySyncAdminInfo(newmap);
        this._main.getListHandler().getIoHandler().update(this._info);
    }

    public static Map<Long, PlatformLogicalVersion> getVersions() {
        return _versions;
    }
}

