/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList;

import com.gigaspaces.internal.cluster.node.impl.directPersistency.IDirectPersistencyOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.IEmbeddedSyncOpInfo;

public abstract class AbstratEmbeddedSyncOpInfo
implements IEmbeddedSyncOpInfo {
    private final IDirectPersistencyOpInfo _originalOpInfo;
    private boolean _transferred;
    private volatile boolean _persistedToMainList;

    public AbstratEmbeddedSyncOpInfo(IDirectPersistencyOpInfo originalOpInfo) {
        this._originalOpInfo = originalOpInfo;
    }

    @Override
    public IDirectPersistencyOpInfo getOriginalOpInfo() {
        return this._originalOpInfo;
    }

    @Override
    public int getEmbeddedSegmentNumber() {
        return this._originalOpInfo.getSegmentNumber();
    }

    @Override
    public int getSeqInEmbeddedSegment() {
        return this._originalOpInfo.getOrderWithinSegment();
    }

    @Override
    public boolean isPersistedToMainList() {
        return this._persistedToMainList;
    }

    @Override
    public void setPersistedToMainList() {
        this._persistedToMainList = true;
    }

    @Override
    public boolean canTransferToMainList(long currentGenId) {
        return this.getOriginalOpInfo().isPersisted() && (this._originalOpInfo.hasRedoKey() || this._originalOpInfo.getGenerationId() != currentGenId);
    }

    @Override
    public abstract boolean containsAnyPhantom();

    @Override
    public abstract void resetPhantom(String var1);

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" generation=").append(this._originalOpInfo.getGenerationId()).append(" seq=").append(this._originalOpInfo.getSequenceNumber());
        return sb.toString();
    }

    @Override
    public abstract boolean isMultiUids();

    public int hashCode() {
        return Long.valueOf(this._originalOpInfo.getSequenceNumber()).hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        AbstratEmbeddedSyncOpInfo other = (AbstratEmbeddedSyncOpInfo)o;
        return other.getOriginalOpInfo().getSequenceNumber() == this.getOriginalOpInfo().getSequenceNumber() && other.getOriginalOpInfo().getGenerationId() == this.getOriginalOpInfo().getGenerationId();
    }
}

