/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencyMultipleUidsOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencySingleUidOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencySyncHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.EmbeddedMultiUidsSyncOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.EmbeddedSingeUidSyncOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.EmbeddedSyncSegment;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.IEmbeddedSyncOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.InitialLoadHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.PhantomsHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.embeddedAdmin.EmbeddedRelevantGenerationIdsHandler;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class EmbeddedSyncHandler {
    private final DirectPersistencySyncHandler _mainSyncHandler;
    private final EmbeddedSyncSegment[] _segments;
    private final EmbeddedRelevantGenerationIdsHandler _gensHandler;
    private final PhantomsHandler _phantomsHandler;
    private final InitialLoadHandler _initialLoadHandler;
    private final AtomicInteger _allCurrentGensRecordsInSegment;

    public EmbeddedSyncHandler(DirectPersistencySyncHandler mainSyncHandler) {
        this._mainSyncHandler = mainSyncHandler;
        int numSegments = mainSyncHandler.getListHandler().getNumSegments();
        this._allCurrentGensRecordsInSegment = new AtomicInteger();
        this._segments = new EmbeddedSyncSegment[numSegments];
        for (int i = 0; i < numSegments; ++i) {
            this._segments[i] = new EmbeddedSyncSegment(this, i);
        }
        this._gensHandler = new EmbeddedRelevantGenerationIdsHandler(this);
        this._phantomsHandler = new PhantomsHandler(this);
        this._initialLoadHandler = new InitialLoadHandler(this);
    }

    private Logger getLogger() {
        return this._mainSyncHandler.getLogger();
    }

    public void afterInitializedBlobStoreIO() {
        this._gensHandler.afterInitializedBlobStoreIO();
        for (EmbeddedSyncSegment seg : this._segments) {
            seg.afterInitializedBlobStoreIO();
        }
    }

    public void initialize() {
        for (EmbeddedSyncSegment seg : this._segments) {
            seg.initialize();
        }
        this._gensHandler.initialize();
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().log(Level.FINE, "[" + this._mainSyncHandler.getSpaceEngine().getFullSpaceName() + "] Embedded sync list handler was initialized with " + this.getNumSegments() + " segments");
        }
    }

    public static Serializable getStorageKeyForPhantom(String uid) {
        return uid;
    }

    public void beforeEmbeddedSyncOp(DirectPersistencySingleUidOpInfo originalOpInfo, boolean phantom) {
        EmbeddedSingeUidSyncOpInfo oi = new EmbeddedSingeUidSyncOpInfo(originalOpInfo, phantom);
        originalOpInfo.setEmbeddedSyncOpInfo(oi);
    }

    public void beforeEmbeddedSyncOp(DirectPersistencyMultipleUidsOpInfo originalOpInfo, Set<String> phantoms) {
        EmbeddedMultiUidsSyncOpInfo oi = new EmbeddedMultiUidsSyncOpInfo(originalOpInfo, phantoms);
        originalOpInfo.setEmbeddedSyncOpInfo(oi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEmbeddedSyncOp(DirectPersistencySingleUidOpInfo originalOpInfo) {
        IEmbeddedSyncOpInfo oi = originalOpInfo.getEmbeddedSyncOpInfo();
        int segmentNumber = originalOpInfo.getSegmentNumber();
        IEmbeddedSyncOpInfo iEmbeddedSyncOpInfo = oi;
        synchronized (iEmbeddedSyncOpInfo) {
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, "[" + this._mainSyncHandler.getSpaceEngine().getFullSpaceName() + "] Adding " + originalOpInfo + " to embedded sync list handler segment [" + segmentNumber + "] , phantom? [" + oi.containsPhantom(originalOpInfo.getUid()) + "]");
            }
            if (oi.containsPhantom(originalOpInfo.getUid())) {
                this._phantomsHandler.add(oi, originalOpInfo.getUid());
            }
            this._segments[segmentNumber].add(oi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEmbeddedSyncOp(DirectPersistencyMultipleUidsOpInfo originalOpInfo) {
        EmbeddedMultiUidsSyncOpInfo oi;
        int segmentNumber = originalOpInfo.getSegmentNumber();
        EmbeddedMultiUidsSyncOpInfo embeddedMultiUidsSyncOpInfo = oi = (EmbeddedMultiUidsSyncOpInfo)originalOpInfo.getEmbeddedSyncOpInfo();
        synchronized (embeddedMultiUidsSyncOpInfo) {
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, "[" + this._mainSyncHandler.getSpaceEngine().getFullSpaceName() + "] Adding " + originalOpInfo + " to embedded sync list handler segment [" + segmentNumber + "] , has phantoms? [" + oi.containsAnyPhantom() + "]");
            }
            if (oi.containsAnyPhantom()) {
                EmbeddedMultiUidsSyncOpInfo embeddedMultiUidsSyncOpInfo2 = oi;
                synchronized (embeddedMultiUidsSyncOpInfo2) {
                    for (String uid : oi.getPhantoms()) {
                        this._phantomsHandler.add(oi, uid);
                    }
                }
            }
            this._segments[segmentNumber].add(oi);
        }
    }

    public void onEmbeddedOpFromInitialLoad(DirectPersistencySingleUidOpInfo originalOpInfo, boolean phantom) {
        this.beforeEmbeddedSyncOp(originalOpInfo, phantom);
        originalOpInfo.setPersisted();
        this.onEmbeddedSyncOp(originalOpInfo);
    }

    public void onEmbeddedOpFromInitialLoad(DirectPersistencyMultipleUidsOpInfo originalOpInfo, Set<String> phantoms) {
        this.beforeEmbeddedSyncOp(originalOpInfo, phantoms);
        originalOpInfo.setPersisted();
        this.onEmbeddedSyncOp(originalOpInfo);
    }

    public DirectPersistencySyncHandler getMainSyncHandler() {
        return this._mainSyncHandler;
    }

    public int getNumSegments() {
        return this._segments.length;
    }

    public EmbeddedSyncSegment getSegment(int num) {
        return num < this.getNumSegments() ? this._segments[num] : null;
    }

    public EmbeddedRelevantGenerationIdsHandler getGensHandler() {
        return this._gensHandler;
    }

    public void onSpaceOpRemovePhantomIfExists(String uid) {
        this._phantomsHandler.onSpaceOpRemovePhantomIfExists(uid);
    }

    public PhantomsHandler getPhantomsHandler() {
        return this._phantomsHandler;
    }

    public InitialLoadHandler getInitialLoadHandler() {
        return this._initialLoadHandler;
    }

    public void afterRecovery() {
        this._gensHandler.removeOldGens();
    }

    void onAllCurrentGensRecordsInSegment(int segmentNumber) {
        if (this._allCurrentGensRecordsInSegment.incrementAndGet() == this.getNumSegments()) {
            this._gensHandler.removeOldGens();
        }
    }

    public Iterator<String> getEmbeddedListForRecovery() {
        return new RecoveryEmbeddedIter(this);
    }

    public void close() {
        for (EmbeddedSyncSegment seg : this._segments) {
            seg.close();
        }
    }

    private class RecoveryEmbeddedIter
    implements Iterator<String> {
        private final EmbeddedSyncHandler _sh;
        private int _curSeg;
        private Iterator<IEmbeddedSyncOpInfo> _segIter;
        private String _cur;
        private final HashSet<String> _usedUids = new HashSet();
        private Iterator<String> _multiUidsIter;

        RecoveryEmbeddedIter(EmbeddedSyncHandler sh) {
            this._sh = sh;
            this._curSeg = -1;
        }

        @Override
        public boolean hasNext() {
            String cur = null;
            while (true) {
                this._cur = null;
                if (this._segIter == null && this._curSeg >= this._sh.getNumSegments()) {
                    return false;
                }
                if (this._segIter != null) {
                    if (this._multiUidsIter != null) {
                        if (this._multiUidsIter.hasNext()) {
                            cur = this._multiUidsIter.next();
                            if (!this._usedUids.add(cur)) continue;
                            this._cur = cur;
                            return true;
                        }
                        this._multiUidsIter = null;
                        continue;
                    }
                    if (!this._segIter.hasNext()) {
                        this._segIter = null;
                        continue;
                    }
                    IEmbeddedSyncOpInfo ei = this._segIter.next();
                    if (!this.isValidForRecovery(ei)) continue;
                    if (!ei.isMultiUids()) {
                        if (!this._usedUids.add(ei.getOriginalOpInfo().getUid())) continue;
                        this._cur = ei.getOriginalOpInfo().getUid();
                        return true;
                    }
                    this._multiUidsIter = ei.getOriginalOpInfo().getUids().iterator();
                    continue;
                }
                ++this._curSeg;
                if (this._curSeg >= this._sh.getNumSegments()) {
                    return false;
                }
                this._segIter = this._sh.getSegment(this._curSeg).getEmbeddedRecordsIterator();
            }
        }

        private boolean isValidForRecovery(IEmbeddedSyncOpInfo ei) {
            if (!this._sh.getGensHandler().isRelevant(ei.getOriginalOpInfo().getGenerationId())) {
                return false;
            }
            return ei.getOriginalOpInfo().getGenerationId() != this._sh.getMainSyncHandler().getCurrentGenerationId();
        }

        @Override
        public String next() {
            return this._cur;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

