/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencySyncHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.EmbeddedMultiUidsSyncOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.EmbeddedSingeUidSyncOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.EmbeddedSyncHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.IEmbeddedSyncOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.embeddedAdmin.EmbeddedSyncListTransferredInfoHandler;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class EmbeddedSyncSegment {
    public static final long EMBEDDED_SYNC_SLEEP_TIME = 300L;
    public static final int SHORT_SLEEP_QUEUE_SIZE = 1000;
    public static final int MIN_SIZE_TO_ITER = 1000;
    private final EmbeddedSyncHandler _embeddedHandler;
    private final ConcurrentLinkedQueue<IEmbeddedSyncOpInfo> _inputRecords;
    private final int _segmentNumber;
    private final EmbeddedSyncListTransferredInfoHandler _infoHandler;
    private final long _currentGenerationId;
    private final EmbeddedSyncer _syncer;
    private final AtomicInteger _size;
    private final Lock _readLock;

    EmbeddedSyncSegment(EmbeddedSyncHandler embeddedHandler, int segmentNumber) {
        this._embeddedHandler = embeddedHandler;
        this._segmentNumber = segmentNumber;
        this._inputRecords = new ConcurrentLinkedQueue();
        this._currentGenerationId = this._embeddedHandler.getMainSyncHandler().getCurrentGenerationId();
        this._infoHandler = new EmbeddedSyncListTransferredInfoHandler(this);
        this._syncer = new EmbeddedSyncer("EMBEDDED SYNCER SEGMENT " + segmentNumber, embeddedHandler.getMainSyncHandler(), this);
        this._size = new AtomicInteger();
        this._readLock = this._embeddedHandler.getMainSyncHandler().getReadLock();
    }

    public void initialize() {
        this._syncer.start();
        this._infoHandler.initialize();
    }

    int size() {
        return this._size.get();
    }

    private Logger getLogger() {
        return this._embeddedHandler.getMainSyncHandler().getLogger();
    }

    public void afterInitializedBlobStoreIO() {
        this._infoHandler.afterInitializedBlobStoreIO(this._embeddedHandler.getGensHandler().getRelevantGenerations());
    }

    public void add(IEmbeddedSyncOpInfo op) {
        this._size.incrementAndGet();
        this._inputRecords.add(op);
    }

    public EmbeddedSyncHandler getEmbeddedHandler() {
        return this._embeddedHandler;
    }

    public boolean transferIfPossible(IEmbeddedSyncOpInfo oi) {
        if (!oi.getOriginalOpInfo().isMultiUids()) {
            return this.transferIfPossibleImpl((EmbeddedSingeUidSyncOpInfo)oi);
        }
        return this.transferIfPossibleImpl((EmbeddedMultiUidsSyncOpInfo)oi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transferIfPossibleImpl(EmbeddedSingeUidSyncOpInfo oi) {
        if (!oi.canTransferToMainList(this._currentGenerationId)) {
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().fine("[" + this.getEmbeddedHandler().getMainSyncHandler().getSpaceEngine().getFullSpaceName() + "] EmbeddedSyncSegment will not transfer " + oi.getOriginalOpInfo() + " current generation [" + this._currentGenerationId + "]");
            }
            return false;
        }
        EmbeddedSingeUidSyncOpInfo embeddedSingeUidSyncOpInfo = oi;
        synchronized (embeddedSingeUidSyncOpInfo) {
            boolean relevant = this._embeddedHandler.getGensHandler().isRelevant(oi.getOriginalOpInfo().getGenerationId());
            boolean lockAcquired = false;
            try {
                boolean addToMainList;
                if (relevant && oi.getOriginalOpInfo().getGenerationId() != this._embeddedHandler.getMainSyncHandler().getCurrentGenerationId()) {
                    this._readLock.lock();
                    lockAcquired = true;
                    if (this._embeddedHandler.getMainSyncHandler().afterRecoveryStarted()) {
                        if (this.getLogger().isLoggable(Level.FINER)) {
                            this.getLogger().finer("[" + this.getEmbeddedHandler().getMainSyncHandler().getSpaceEngine().getFullSpaceName() + "] EmbeddedSyncSegment will not transfer " + oi.getOriginalOpInfo() + " current generation [" + this._currentGenerationId + "] because afterRecovery already cleared it");
                        }
                        relevant = false;
                    }
                }
                boolean persist = relevant && !oi.isPersistedToMainList() && !oi.getOriginalOpInfo().isConfirmedByRemote(this._embeddedHandler.getMainSyncHandler());
                boolean updateTransferredInfo = relevant && !oi.isPersistedToMainList() && oi.getOriginalOpInfo().getGenerationId() == this._currentGenerationId;
                boolean bl = addToMainList = persist && oi.getOriginalOpInfo().getGenerationId() == this._currentGenerationId;
                if (oi.containsAnyPhantom() && oi.isPersistedToMainList()) {
                    throw new RuntimeException("inconsistent state in EmbeddedSegment:transferIfPossibleImpl contains phantom && persisted to main list SINGLE-uid=" + oi.getOriginalOpInfo().getUid());
                }
                if (!(relevant && addToMainList || !this.getLogger().isLoggable(Level.FINE))) {
                    this.getLogger().fine("[" + this.getEmbeddedHandler().getMainSyncHandler().getSpaceEngine().getFullSpaceName() + "] EmbeddedSyncSegment will not transfer " + oi.getOriginalOpInfo() + " current generation [" + this._currentGenerationId + "], relevant? [" + relevant + "], should add to main sync list? [" + addToMainList + "]");
                }
                if (persist) {
                    this._embeddedHandler.getMainSyncHandler().onEmbeddedListRecordTransferStart(oi.getOriginalOpInfo(), oi.getOriginalOpInfo().getGenerationId() != this._currentGenerationId);
                    oi.setPersistedToMainList();
                }
                if (oi.containsAnyPhantom()) {
                    this._embeddedHandler.getPhantomsHandler().removePhantom(oi, oi.getOriginalOpInfo().getUid());
                }
                if (addToMainList) {
                    this._embeddedHandler.getMainSyncHandler().onEmbeddedListRecordTransferEnd(oi.getOriginalOpInfo());
                }
                if (updateTransferredInfo) {
                    this._infoHandler.updateTranferredInfo(oi);
                }
            }
            finally {
                if (lockAcquired) {
                    this._readLock.unlock();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transferIfPossibleImpl(EmbeddedMultiUidsSyncOpInfo oi) {
        if (!oi.canTransferToMainList(this._currentGenerationId)) {
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().fine("[" + this.getEmbeddedHandler().getMainSyncHandler().getSpaceEngine().getFullSpaceName() + "] EmbeddedSyncSegment will not transfer " + oi.getOriginalOpInfo() + " current generation [" + this._currentGenerationId + "]");
            }
            return false;
        }
        EmbeddedMultiUidsSyncOpInfo embeddedMultiUidsSyncOpInfo = oi;
        synchronized (embeddedMultiUidsSyncOpInfo) {
            boolean relevant = this._embeddedHandler.getGensHandler().isRelevant(oi.getOriginalOpInfo().getGenerationId());
            boolean lockAcquired = false;
            try {
                boolean addToMainList;
                if (relevant && oi.getOriginalOpInfo().getGenerationId() != this._embeddedHandler.getMainSyncHandler().getCurrentGenerationId()) {
                    this._readLock.lock();
                    lockAcquired = true;
                    if (this._embeddedHandler.getMainSyncHandler().afterRecoveryStarted()) {
                        if (this.getLogger().isLoggable(Level.FINER)) {
                            this.getLogger().finer("[" + this.getEmbeddedHandler().getMainSyncHandler().getSpaceEngine().getFullSpaceName() + "] EmbeddedSyncSegment will not transfer " + oi.getOriginalOpInfo() + " current generation [" + this._currentGenerationId + "] because afterRecovery already cleared it");
                        }
                        relevant = false;
                    }
                }
                boolean persist = relevant && !oi.isPersistedToMainList() && !oi.getOriginalOpInfo().isConfirmedByRemote(this._embeddedHandler.getMainSyncHandler());
                boolean updateTransferredInfo = relevant && !oi.isPersistedToMainList() && oi.getOriginalOpInfo().getGenerationId() == this._currentGenerationId;
                boolean bl = addToMainList = persist && oi.getOriginalOpInfo().getGenerationId() == this._currentGenerationId;
                if (!(relevant && addToMainList || !this.getLogger().isLoggable(Level.FINE))) {
                    this.getLogger().fine("[" + this.getEmbeddedHandler().getMainSyncHandler().getSpaceEngine().getFullSpaceName() + "] EmbeddedSyncSegment will not transfer " + oi.getOriginalOpInfo() + " current generation [" + this._currentGenerationId + "], relevant? [" + relevant + "], should add to main sync list? [" + addToMainList + "]");
                }
                if (persist) {
                    this._embeddedHandler.getMainSyncHandler().onEmbeddedListRecordTransferStart(oi.getOriginalOpInfo(), oi.getOriginalOpInfo().getGenerationId() != this._currentGenerationId);
                    oi.setPersistedToMainList();
                }
                if (oi.containsAnyPhantom()) {
                    for (String uid : oi.getPhantoms()) {
                        this._embeddedHandler.getPhantomsHandler().removePhantom(oi, uid);
                    }
                }
                if (addToMainList) {
                    this._embeddedHandler.getMainSyncHandler().onEmbeddedListRecordTransferEnd(oi.getOriginalOpInfo());
                }
                if (updateTransferredInfo) {
                    this._infoHandler.updateTranferredInfo(oi);
                }
            }
            finally {
                if (lockAcquired) {
                    this._readLock.unlock();
                }
            }
        }
        return true;
    }

    public int getSegmentNumber() {
        return this._segmentNumber;
    }

    public EmbeddedSyncListTransferredInfoHandler getInfoHandlerOfSegment() {
        return this._infoHandler;
    }

    public Iterator<IEmbeddedSyncOpInfo> getEmbeddedRecordsIterator() {
        return this._inputRecords.iterator();
    }

    public void close() {
        if (this._syncer != null) {
            this._syncer.close();
        }
    }

    private class EmbeddedSyncer
    extends GSThread {
        private volatile boolean _closed;
        private final DirectPersistencySyncHandler _mainHandler;
        private final EmbeddedSyncSegment _segment;
        private boolean _allCurrentGensRecordsInSegment;

        public EmbeddedSyncer(String threadName, DirectPersistencySyncHandler handler, EmbeddedSyncSegment segment) {
            super(threadName);
            this._mainHandler = handler;
            this._segment = segment;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int synced = 0;
            try {
                while (!this._closed) {
                    try {
                        long timeToSleep = EmbeddedSyncSegment.this.size() < 1000 ? 300L : 30L;
                        try {
                            Thread.sleep(timeToSleep);
                        }
                        catch (InterruptedException ex) {
                            if (this._mainHandler.getLogger().isLoggable(Level.FINE)) {
                                this._mainHandler.getLogger().warning("[" + this._mainHandler.getSpaceEngine().getFullSpaceName() + "] EmbeddedSyncSegment EmbeddedSyncer thread interrupted");
                            }
                            if (!this._closed) continue;
                            break;
                        }
                        if (this._closed) {
                            break;
                        }
                        synced = this.handeRecordsRipeForTransfer();
                    }
                    catch (Throwable ex) {
                        if (this._mainHandler.getLogger().isLoggable(Level.SEVERE)) {
                            this._mainHandler.getLogger().severe("[" + this._mainHandler.getSpaceEngine().getFullSpaceName() + "] EmbeddedSyncSegment EmbeddedSyncer thread got unexpected exception " + ex);
                        }
                        if (!this._closed) continue;
                        break;
                    }
                }
            }
            finally {
                EmbeddedSyncer embeddedSyncer = this;
                synchronized (embeddedSyncer) {
                    ((Object)((Object)this)).notifyAll();
                }
            }
        }

        private int handeRecordsRipeForTransfer() {
            IEmbeddedSyncOpInfo f;
            int reaped = 0;
            if (!this._allCurrentGensRecordsInSegment && !EmbeddedSyncSegment.this._inputRecords.isEmpty() && (f = (IEmbeddedSyncOpInfo)EmbeddedSyncSegment.this._inputRecords.peek()).getOriginalOpInfo().getGenerationId() == EmbeddedSyncSegment.this._embeddedHandler.getMainSyncHandler().getCurrentGenerationId()) {
                this._allCurrentGensRecordsInSegment = true;
                EmbeddedSyncSegment.this._infoHandler.removeOldGenerationsTransferredInfo();
                EmbeddedSyncSegment.this._embeddedHandler.onAllCurrentGensRecordsInSegment(EmbeddedSyncSegment.this._segmentNumber);
            }
            Iterator iter = EmbeddedSyncSegment.this._inputRecords.iterator();
            int limit = EmbeddedSyncSegment.this.size() + 1000;
            int scanned = 0;
            while (iter.hasNext()) {
                IEmbeddedSyncOpInfo oi = (IEmbeddedSyncOpInfo)iter.next();
                ++scanned;
                if (this._segment.transferIfPossible(oi)) {
                    iter.remove();
                    ++reaped;
                    EmbeddedSyncSegment.this._size.decrementAndGet();
                }
                if (scanned <= limit) continue;
                break;
            }
            if (reaped > 0 && this._mainHandler.getLogger().isLoggable(Level.FINER)) {
                this._mainHandler.getLogger().log(Level.FINER, "[" + this._mainHandler.getSpaceEngine().getFullSpaceName() + "] EmbeddedSyncSegment:handeRecordsRipeForTransfer moved=" + reaped + " left=" + this._segment.size());
            }
            return reaped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            EmbeddedSyncer embeddedSyncer = this;
            synchronized (embeddedSyncer) {
                if (this._closed) {
                    return;
                }
                this._closed = true;
                this.interrupt();
                try {
                    ((Object)((Object)this)).wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

