/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.AbstractDirectPersistencyOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.EmbeddedSyncHandler;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.j_spaces.core.cache.blobStore.BlobStoreEntryHolder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class InitialLoadHandler {
    private final EmbeddedSyncHandler _embeddedHandler;
    private final ConcurrentHashMap<InitialLoadBasicInfo, InitialLoadBasicInfo> _initialLoaded = new ConcurrentHashMap();

    public InitialLoadHandler(EmbeddedSyncHandler embeddedHandler) {
        this._embeddedHandler = embeddedHandler;
    }

    public boolean onLoadingEntry(IEntryHolder eh) {
        if (!eh.isBlobStoreEntry()) {
            return true;
        }
        BlobStoreEntryHolder oheh = (BlobStoreEntryHolder)eh;
        if (oheh.getEmbeddedSyncOpInfo() == null || oheh.getEmbeddedSyncOpInfo().getGenerationId() == 0L) {
            return true;
        }
        long genId = oheh.getEmbeddedSyncOpInfo().getGenerationId();
        long seq = oheh.getEmbeddedSyncOpInfo().getSequenceId();
        boolean phantom = oheh.getEmbeddedSyncOpInfo().isPhantom();
        boolean multiuids = oheh.getEmbeddedSyncOpInfo().isPartOfMultipleUidsInfo();
        if (!phantom && !this._embeddedHandler.getGensHandler().isRelevant(genId)) {
            return true;
        }
        int segmentNum = AbstractDirectPersistencyOpInfo.getSegmentNumber(seq) % this._embeddedHandler.getNumSegments();
        int seqInSegment = AbstractDirectPersistencyOpInfo.getOrderWithinSegment(seq);
        if (!phantom && this._embeddedHandler.getSegment(segmentNum).getInfoHandlerOfSegment().isSeqNumberTransferredForSure(genId, seqInSegment)) {
            return true;
        }
        if (multiuids) {
            this.createMultiUidsInitialLoadInfo(eh, genId, seq, phantom);
        } else {
            this.createSingleUidInitialLoadInfo(eh, genId, seq, phantom);
        }
        return !phantom;
    }

    private void createMultiUidsInitialLoadInfo(IEntryHolder eh, long genId, long seq, boolean phantom) {
        MultiUidsInitialLoadBasicInfo li = new MultiUidsInitialLoadBasicInfo(genId, seq, eh.getUID(), phantom);
        MultiUidsInitialLoadBasicInfo cur = null;
        cur = (MultiUidsInitialLoadBasicInfo)this._initialLoaded.putIfAbsent(li, li);
        if (cur != null) {
            cur.add(eh.getUID(), phantom);
        }
    }

    private void createSingleUidInitialLoadInfo(IEntryHolder eh, long genId, long seq, boolean phantom) {
        SingleUidInitialLoadBasicInfo li = new SingleUidInitialLoadBasicInfo(genId, seq, eh.getUID(), phantom);
        InitialLoadBasicInfo cur = null;
        cur = this._initialLoaded.putIfAbsent(li, li);
        if (cur != null) {
            if (this.getLogger().isLoggable(Level.WARNING)) {
                this.getLogger().warning("[" + this._embeddedHandler.getMainSyncHandler().getSpaceEngine().getFullSpaceName() + "] internal error- EmbeddedSyncInitialLoadHandler mixed single & multiuids gen=" + genId + " seq=" + seq);
            }
            throw new RuntimeException("space " + this._embeddedHandler.getMainSyncHandler().getSpaceEngine().getFullSpaceName() + "internal error- EmbeddedSyncInitialLoadHandler mixed single & multiuids gen=" + genId + " seq=" + seq + " segment=" + AbstractDirectPersistencyOpInfo.getSegmentNumber(seq) + " order=" + AbstractDirectPersistencyOpInfo.getOrderWithinSegment(seq));
        }
    }

    public void onInitialLoadEnd() {
        this.moveToEmbeddedList();
        this._initialLoaded.clear();
    }

    private void moveToEmbeddedList() {
        Iterator<InitialLoadBasicInfo> iter = this._initialLoaded.values().iterator();
        int inEmbeddedListFromInitialLoad = 0;
        int numPhantomsInEmbeddedListFromInitialLoad = 0;
        while (iter.hasNext()) {
            InitialLoadBasicInfo il = iter.next();
            if (il.isSingleUid()) {
                this.moveToSegment((SingleUidInitialLoadBasicInfo)il);
                if (il.containsPhantom()) {
                    ++numPhantomsInEmbeddedListFromInitialLoad;
                }
            } else {
                this.moveToSegment((MultiUidsInitialLoadBasicInfo)il);
                if (il.containsPhantom()) {
                    numPhantomsInEmbeddedListFromInitialLoad += il.getPhantoms().size();
                }
            }
            ++inEmbeddedListFromInitialLoad;
        }
        if (this.getLogger().isLoggable(Level.INFO)) {
            this.getLogger().info("[" + this._embeddedHandler.getMainSyncHandler().getSpaceEngine().getFullSpaceName() + "] loaded " + inEmbeddedListFromInitialLoad + " entries to embedded sync list during initial load. Number of phantoms=" + numPhantomsInEmbeddedListFromInitialLoad);
        }
    }

    private void moveToSegment(SingleUidInitialLoadBasicInfo il) {
        this._embeddedHandler.getMainSyncHandler().onEmbeddedOpFromInitialLoad(il.getUid(), il.getGenerationId(), il.getSeq(), il.containsPhantom());
    }

    private void moveToSegment(MultiUidsInitialLoadBasicInfo il) {
        this._embeddedHandler.getMainSyncHandler().onEmbeddedOpFromInitialLoad(il.getUids(), il.getGenerationId(), il.getSeq(), il.getPhantoms());
    }

    private Logger getLogger() {
        return this._embeddedHandler.getMainSyncHandler().getLogger();
    }

    private static class MultiUidsInitialLoadBasicInfo
    extends InitialLoadBasicInfo {
        private final List<String> _uids = new LinkedList<String>();
        private Set<String> _phantoms;

        public MultiUidsInitialLoadBasicInfo(long gen, long seq, String uid, boolean phantom) {
            super(gen, seq);
            this._uids.add(uid);
            if (phantom) {
                this._phantoms = new HashSet<String>();
                this._phantoms.add(uid);
            }
        }

        @Override
        public boolean isSingleUid() {
            return false;
        }

        @Override
        public boolean containsPhantom() {
            return this._phantoms != null && !this._phantoms.isEmpty();
        }

        @Override
        public Set<String> getPhantoms() {
            return this._phantoms;
        }

        @Override
        public String getUid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getUids() {
            return this._uids;
        }

        @Override
        public synchronized void add(String uid, boolean phantom) {
            this._uids.add(uid);
            if (phantom) {
                if (this._phantoms != null) {
                    this._phantoms = new HashSet<String>();
                }
                this._phantoms.add(uid);
            }
        }
    }

    private static class SingleUidInitialLoadBasicInfo
    extends InitialLoadBasicInfo {
        private final String _uid;
        private final boolean _phantom;

        public SingleUidInitialLoadBasicInfo(long gen, long seq, String uid, boolean phantom) {
            super(gen, seq);
            this._uid = uid;
            this._phantom = phantom;
        }

        @Override
        public boolean isSingleUid() {
            return true;
        }

        @Override
        public boolean containsPhantom() {
            return this._phantom;
        }

        @Override
        public Set<String> getPhantoms() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUid() {
            return this._uid;
        }

        @Override
        public List<String> getUids() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String uid, boolean phantom) {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class InitialLoadBasicInfo {
        private final long _generationId;
        private final long _seq;

        public InitialLoadBasicInfo(long generationId, long seq) {
            this._generationId = generationId;
            this._seq = seq;
        }

        public long getGenerationId() {
            return this._generationId;
        }

        public long getSeq() {
            return this._seq;
        }

        public abstract boolean isSingleUid();

        public abstract boolean containsPhantom();

        public abstract Set<String> getPhantoms();

        public abstract String getUid();

        public abstract List<String> getUids();

        public abstract void add(String var1, boolean var2);

        public int hashCode() {
            return Long.valueOf(this.getSeq()).hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            InitialLoadBasicInfo other = (InitialLoadBasicInfo)o;
            return other.getSeq() == this.getSeq() && other.getGenerationId() == this.getGenerationId();
        }
    }
}

