/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.EmbeddedSyncHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.IEmbeddedSyncOpInfo;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class PhantomsHandler {
    private final ConcurrentMap<String, IEmbeddedSyncOpInfo> _phantoms = new ConcurrentHashMap<String, IEmbeddedSyncOpInfo>();
    private final EmbeddedSyncHandler _embeddedHandler;
    private final long _currentGenerationId;
    private final AtomicInteger _numPhantoms;

    public PhantomsHandler(EmbeddedSyncHandler handler) {
        this._embeddedHandler = handler;
        this._currentGenerationId = this._embeddedHandler.getMainSyncHandler().getCurrentGenerationId();
        this._numPhantoms = new AtomicInteger();
    }

    public void add(IEmbeddedSyncOpInfo oi, String uid) {
        this.addToNumPhantoms();
        if (this._phantoms.putIfAbsent(uid, oi) != null) {
            IEmbeddedSyncOpInfo cur = (IEmbeddedSyncOpInfo)this._phantoms.get(uid);
            if (this.getLogger().isLoggable(Level.SEVERE)) {
                this.getLogger().log(Level.SEVERE, "[" + this._embeddedHandler.getMainSyncHandler().getSpaceEngine().getFullSpaceName() + "] DirectPersistencySyncHandler phantomsHandler:add phantom aleady exist uid=" + uid + " adding=" + oi.toString() + " existing=" + cur.toString());
            }
            throw new RuntimeException("trying to add phantom but phantom already exists uid=" + uid);
        }
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().log(Level.FINER, "[" + this._embeddedHandler.getMainSyncHandler().getSpaceEngine().getFullSpaceName() + "] DirectPersistencySyncHandler phantomsHandler:add phantom " + oi.getOriginalOpInfo());
        }
    }

    private Logger getLogger() {
        return this._embeddedHandler.getMainSyncHandler().getLogger();
    }

    private void addToNumPhantoms() {
        this._numPhantoms.incrementAndGet();
    }

    private void subFromNumPhantoms() {
        int res = this._numPhantoms.decrementAndGet();
        if (res < 0) {
            throw new RuntimeException("inconsistent state- negative # phantoms " + res);
        }
    }

    private boolean isEmpty() {
        return this._numPhantoms.get() == 0;
    }

    public void removePhantom(IEmbeddedSyncOpInfo oi, String uid) {
        this.removePhantom(oi, uid, false);
    }

    private void removePhantom(IEmbeddedSyncOpInfo oi, String uid, boolean alreadyVerifiedMap) {
        IEmbeddedSyncOpInfo cur;
        IEmbeddedSyncOpInfo iEmbeddedSyncOpInfo = cur = !alreadyVerifiedMap ? (IEmbeddedSyncOpInfo)this._phantoms.get(uid) : oi;
        if (cur != oi) {
            if (this.getLogger().isLoggable(Level.SEVERE)) {
                this.getLogger().log(Level.SEVERE, "[" + this._embeddedHandler.getMainSyncHandler().getSpaceEngine().getFullSpaceName() + "] DirectPersistencySyncHandler phantomsHandler:removePhantom not fitting uid=" + uid + " operated=" + oi.toString() + " existing=" + (cur != null ? cur.toString() : " null"));
            }
            throw new RuntimeException("[" + this._embeddedHandler.getMainSyncHandler().getSpaceEngine().getFullSpaceName() + "] DirectPersistencySyncHandler phantomsHandler:removePhantom not fitting uid=" + uid + " operated=" + oi.toString() + " existing=" + (cur != null ? cur.toString() : " null"));
        }
        this.getLogger().log(Level.FINER, "[" + this._embeddedHandler.getMainSyncHandler().getSpaceEngine().getFullSpaceName() + "] DirectPersistencySyncHandler phantomsHandler removing phantom " + oi.getOriginalOpInfo());
        this._embeddedHandler.getMainSyncHandler().getListHandler().getIoHandler().removePhantom(uid, oi.getOriginalOpInfo().getGenerationId() != this._currentGenerationId, oi.getOriginalOpInfo().getGenerationId(), oi.getOriginalOpInfo().getSequenceNumber());
        oi.resetPhantom(uid);
        this._phantoms.remove(uid, oi);
        this.subFromNumPhantoms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSpaceOpRemovePhantomIfExists(String uid) {
        if (this.isEmpty()) {
            return;
        }
        IEmbeddedSyncOpInfo cur = (IEmbeddedSyncOpInfo)this._phantoms.get(uid);
        if (cur == null) {
            return;
        }
        IEmbeddedSyncOpInfo iEmbeddedSyncOpInfo = cur;
        synchronized (iEmbeddedSyncOpInfo) {
            if (cur.containsPhantom(uid)) {
                if (!cur.isPersistedToMainList()) {
                    this._embeddedHandler.getMainSyncHandler().getListHandler().insertToPersistentSyncListFromEmbeddedList(cur.getOriginalOpInfo(), cur.getOriginalOpInfo().getGenerationId() != this._currentGenerationId);
                    cur.setPersistedToMainList();
                }
                this.removePhantom(cur, uid, true);
            }
        }
    }
}

